/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.IconResource;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ArrayProperty;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;

public abstract class Property
implements PropertyChangeListener {
    protected Property parent;
    protected Object owner;
    protected Object ownerForPropertyChanges;
    protected FeatureDescriptor descriptor;
    public static final int SHOW_USUAL = 0;
    public static final int SHOW_EXPERT = 1;
    public static final int SHOW_HIDDEN = 2;
    public static final int SHOW_PREFERRED = 4;
    protected boolean expanded = false;
    protected boolean bComponentFiresPropertyEventsItself;
    protected EventListenerList listenerList;
    private static PropWrapper classRetriever = new PropWrapper(null, null);

    public Object getOwner() {
        return this.owner != null ? this.owner : this.parent.getOwner();
    }

    protected Object readValue(Method method) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(this.getOwner(), (Object[])null);
        }
        catch (Exception e) {
            Logger.getLogger().error("When invoking method '" + method + "' on " + this.getOwner().getClass(), e);
            return null;
        }
    }

    protected Property(Property parent, Object theOwner, FeatureDescriptor theDescriptor) {
        this.parent = parent;
        this.owner = theOwner;
        this.descriptor = theDescriptor;
        if (this.owner instanceof DynamicPropertySet) {
            DynamicPropertySet dps = (DynamicPropertySet)this.owner;
            Class<?> type = dps.getType(this.descriptor.getName());
            try {
                this.descriptor = theDescriptor instanceof IndexedPropertyDescriptor ? new DynValueIndexedPropertyDescriptor(theOwner, type, (IndexedPropertyDescriptor)theDescriptor) : new DynValuePropertyDescriptor(theOwner, type, (PropertyDescriptor)theDescriptor);
            }
            catch (IntrospectionException ex) {
                Logger.getLogger().error("Error creating dynamic property", ex);
            }
            this.owner = new PropWrapper(theOwner, theDescriptor.getName());
        }
        this.ownerForPropertyChanges = theOwner;
    }

    static boolean invokeAddRemovePropertyChangeListenerMethod(Object firer, String propName, String methodName, PropertyChangeListener pcl) {
        Method method2;
        boolean bFirer = false;
        try {
            method2 = firer.getClass().getMethod(methodName, String.class, PropertyChangeListener.class);
            method2.invoke(firer, propName, pcl);
            method2.invoke(firer, propName + "", pcl);
            method2.invoke(firer, propName + ".read-only", pcl);
            method2.invoke(firer, propName + ".display-name", pcl);
            method2.invoke(firer, propName + ".added", pcl);
            method2.invoke(firer, propName + ".removed", pcl);
            bFirer = true;
        }
        catch (NoSuchMethodException method2) {
        }
        catch (IllegalAccessException method2) {
        }
        catch (InvocationTargetException method2) {
            // empty catch block
        }
        if (!bFirer) {
            try {
                method2 = firer.getClass().getMethod(methodName, PropertyChangeListener.class);
                method2.invoke(firer, pcl);
                bFirer = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return bFirer;
    }

    public Object getValue() {
        block3: {
            Method method = null;
            try {
                method = ((PropertyDescriptor)this.descriptor).getReadMethod();
                if (method != null) {
                    return method.invoke(this.getOwner(), (Object[])null);
                }
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) break block3;
                Logger.getLogger().error("getValue : property apply error: " + e + "\r\n\t property     = " + this.getClass() + "\r\n\t completeName = " + this.getCompleteName() + "\r\n\t owner        = " + this.owner + "\r\n\t getOwner()   = " + this.getOwner() + "\r\n\t ownerClass   = " + this.owner.getClass() + "\r\n\t method       = " + method + "\r\n\t parent       = " + this.parent + ":" + (this.parent == null ? null : this.parent.getClass()), e);
            }
        }
        return null;
    }

    public void setValue(Object value) throws NoSuchMethodException {
        Method method = ((PropertyDescriptor)this.descriptor).getWriteMethod();
        if (method == null) {
            return;
        }
        try {
            Object oldVal = this.getValue();
            method.invoke(this.getOwner(), value);
            if (!(this.bComponentFiresPropertyEventsItself || this.listenerList == null && this.parent == null)) {
                this.firePropertyChange(new PropertyChangeEvent(this.owner, this.getCompleteName() + "", oldVal, value));
            }
        }
        catch (Exception e) {
            Logger.getLogger().error("property apply error: " + e + "\r\n\t this    = " + this.getClass() + ":" + this.getCompleteName() + ":" + this.hashCode() + "\r\n\t owner   = " + this.owner + "\r\n\t method  = " + method + "\r\n\t parent  = " + this.parent + ":" + (this.parent == null ? null : this.parent.getClass()) + "\r\n\t value   = " + value + ", class = " + (value == null ? null : value.getClass()), e);
        }
    }

    public Property getParent() {
        return this.parent;
    }

    public FeatureDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getAttribute(String attrName) {
        Object value = this.descriptor.getValue(attrName);
        if (value instanceof Method) {
            value = this.readValue((Method)value);
        }
        return value;
    }

    protected boolean booleanFeature(String feature) {
        Object value = this.descriptor.getValue(feature);
        if (value instanceof Method) {
            value = this.readValue((Method)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public boolean getBooleanAttribute(String attrName) {
        return this.booleanFeature(attrName);
    }

    protected String stringFeature(String feature) {
        Object value = this.descriptor.getValue(feature);
        if (value instanceof Method) {
            value = this.readValue((Method)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getStringAttribute(String attrName) {
        return this.stringFeature(attrName);
    }

    public void setAttribute(String attrName, Object attrValue) {
        this.descriptor.setValue(attrName, attrValue);
    }

    public Class<?> getValueClass() {
        Object value = this.getValue();
        if (value != null) {
            return value.getClass();
        }
        if (this.descriptor instanceof PropertyDescriptor) {
            return ((PropertyDescriptor)this.descriptor).getPropertyType();
        }
        return ((BeanDescriptor)this.descriptor).getBeanClass();
    }

    public boolean isRecursive(Class<?> c) {
        Property p = this;
        while (p != null) {
            Class<?> other = p.getValueClass();
            if (other.equals(c)) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getCompleteName() {
        if (this.parent == null) {
            return this.getName();
        }
        if (this.parent.parent == null) {
            return this.getName();
        }
        return this.parent.getCompleteName() + '/' + this.getName();
    }

    public String getDisplayName() {
        String displayName = null;
        Object bean = this.getValue();
        if (!(bean == null || this.descriptor.getValue("beanDisplayNameMethod") == null || this.descriptor.getValue("displayName") != null || this.parent != null && this.parent instanceof ArrayProperty && this.parent.getDescriptor().getValue("childDisplayName") != null)) {
            try {
                Method method = (Method)this.descriptor.getValue("beanDisplayNameMethod");
                displayName = (String)method.invoke(bean, (Object[])null);
                return displayName;
            }
            catch (Exception e) {
                Logger.getLogger().error("Error getting bean display name", e);
            }
        }
        if (this.parent == null || !(this.parent instanceof ArrayProperty)) {
            displayName = this.stringFeature("displayName");
        } else {
            Object value = this.parent.getDescriptor().getValue("childDisplayName");
            if (value instanceof Method) {
                try {
                    displayName = (String)((Method)value).invoke(this.parent.getOwner(), this.descriptor.getValue("childIndex"), this.getValue());
                }
                catch (Exception e) {
                    Logger.getLogger().error("Error getting child display name for Array Property", e);
                }
            }
        }
        return displayName != null ? displayName : this.descriptor.getDisplayName();
    }

    public Image getIcon() {
        Image image = this.getIcon(1);
        if (image != null) {
            return image;
        }
        return this.getIcon(3);
    }

    public Image getIcon(int type) {
        Object icon = null;
        switch (type) {
            case 1: {
                icon = this.descriptor.getValue("node-icon: color16x16");
                break;
            }
            case 2: {
                icon = this.descriptor.getValue("node-icon: color32x32");
                break;
            }
            case 3: {
                icon = this.descriptor.getValue("node-icon: mono16x16");
                break;
            }
            case 4: {
                icon = this.descriptor.getValue("node-icon: mono32x32");
            }
        }
        if (icon instanceof Image) {
            return (Image)icon;
        }
        if (icon instanceof IconResource) {
            return ((IconResource)icon).getImage();
        }
        return null;
    }

    public Class<?> getPropertyEditorClass() {
        Class<?> editor = ((PropertyDescriptor)this.descriptor).getPropertyEditorClass();
        return editor;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getShortDescription() {
        return this.descriptor.getShortDescription();
    }

    public String getToolTip() {
        String tooltip = this.stringFeature("tooltip");
        return tooltip != null ? tooltip : this.getShortDescription();
    }

    public boolean isReadOnly() {
        if (this.parent != null && !(this.parent instanceof ArrayProperty) && this.parent.isReadOnly()) {
            return true;
        }
        if (this.parent instanceof ArrayProperty && this.parent.booleanFeature("child-read-only")) {
            return true;
        }
        return this.booleanFeature("read-only") || ((PropertyDescriptor)this.descriptor).getWriteMethod() == null;
    }

    public boolean isHideChildren() {
        return this.booleanFeature("hide-children");
    }

    public boolean isLeaf() {
        return this.getPropertyCount() == 0;
    }

    public boolean isSubstituteByChild() {
        return this.booleanFeature("substitute-by-child");
    }

    public Dimension getEditorPreferredSize() {
        Dimension value = (Dimension)this.descriptor.getValue("layout: preferred-size");
        return value;
    }

    public void setEditorPreferredSize(Dimension dim) {
        this.descriptor.setValue("layout: preferred-size", dim);
    }

    public abstract int getPropertyCount();

    public abstract Property getPropertyAt(int var1);

    public Property findProperty(String name) {
        if (name == null) {
            return this;
        }
        if (name.startsWith("../")) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.findProperty(name.substring(3));
        }
        int index = name.indexOf(47);
        String prefix = index == -1 ? name : name.substring(0, index);
        String suffix = index == -1 ? null : name.substring(index + 1);
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            Property p = this.getPropertyAt(i);
            if (!p.getName().equals(prefix)) continue;
            return suffix == null ? p : p.findProperty(suffix);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(int mode) {
        long start = System.currentTimeMillis();
        try {
            if ((this.descriptor.isHidden() || this.booleanFeature("node-hidden")) && (mode & 2) == 0 || this.descriptor.isExpert() && (mode & 1) == 0 || this.descriptor.isPreferred() && (mode & 4) == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (System.currentTimeMillis() - start > 100L) {
                Logger.getLogger().error("TOO SLOW isVisible()!");
                Logger.getLogger().error(" - prop.name=" + this.getName());
                Logger.getLogger().error(" - disp.name=" + this.getDisplayName());
                Enumeration<String> en = this.getDescriptor().attributeNames();
                int count = 0;
                while (en.hasMoreElements()) {
                    en.nextElement();
                    ++count;
                }
                Logger.getLogger().error(" - desc.size=" + count);
            }
        }
    }

    public int getVisibleCount(int mode) {
        int count = this.getPropertyCount();
        int visibleCount = 0;
        for (int i = 0; i < count; ++i) {
            if (!this.getPropertyAt(i).isVisible(mode)) continue;
            ++visibleCount;
        }
        return visibleCount;
    }

    public Property getVisiblePropertyAt(int index, int mode) {
        int count = this.getPropertyCount();
        int visibleCount = 0;
        for (int i = 0; i < count; ++i) {
            Property p = this.getPropertyAt(i);
            if (!p.isVisible(mode)) continue;
            if (index == visibleCount) {
                return p;
            }
            ++visibleCount;
        }
        return null;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isEnabled() {
        return true;
    }

    public Object[] getPathToRoot() {
        return null;
    }

    public String getNiceDescription() {
        String ret;
        String s = "";
        if (this.parent != null) {
            s = "+";
            StringTokenizer st = new StringTokenizer(this.parent.getCompleteName(), "/");
            for (int i = 0; i < st.countTokens(); ++i) {
                s = "    " + s;
            }
        }
        try {
            ret = s + this.getName() + ": " + this.getValue() + " #" + this.getClass().getName() + "\n";
        }
        catch (Exception ignore) {
            ret = s + this.getName() + ": ???\n";
        }
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            String nice = this.getPropertyAt(i).getNiceDescription();
            if (!nice.endsWith("\n")) {
                nice = nice + "\n";
            }
            ret = ret + nice;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Object object;
        if (this.listenerList == null) {
            object = this;
            synchronized (object) {
                if (this.listenerList == null) {
                    this.listenerList = new EventListenerList();
                    PropertyChangeListener pcl = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            Property.this.propertyChange(evt);
                        }
                    };
                    this.bComponentFiresPropertyEventsItself = false;
                    if (this.descriptor instanceof PropertyDescriptor) {
                        this.bComponentFiresPropertyEventsItself = Property.invokeAddRemovePropertyChangeListenerMethod(this.ownerForPropertyChanges, this.getName(), "addPropertyChangeListener", pcl);
                    }
                    if (this.parent != null && !this.parent.equals(listener)) {
                        this.listenerList.add(PropertyChangeListener.class, this.parent);
                    }
                }
            }
        }
        object = this.listenerList;
        synchronized (object) {
            PropertyChangeListener[] previous = (PropertyChangeListener[])this.listenerList.getListeners(PropertyChangeListener.class);
            if (Arrays.stream(previous).noneMatch(e -> e == listener)) {
                this.listenerList.add(PropertyChangeListener.class, listener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(PropertyChangeListener.class, listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String origPropName = evt.getPropertyName();
        try {
            ComponentModel model;
            Class<?> ownerClass = this.owner.getClass();
            Class<?> ejbClass = Class.forName("javax.ejb.EJBObject");
            if (ejbClass.isAssignableFrom(ownerClass) && !this.bComponentFiresPropertyEventsItself && (model = ComponentFactory.getModel(this.owner, ComponentFactory.Policy.DEFAULT)) != null) {
                model.firePropertyChange(new PropertyChangeEvent(evt.getSource(), "*", null, null));
                return;
            }
        }
        catch (Exception ownerClass) {
            // empty catch block
        }
        if (this.getPropertyCount() == 0 && origPropName.indexOf(this.getName()) >= 0 || origPropName.equals(this.getName())) {
            int dot = origPropName.indexOf(".");
            Object propagationId = evt.getPropagationId();
            evt = new PropertyChangeEvent(evt.getSource(), this.getCompleteName() + (dot > 0 ? origPropName.substring(dot) : ""), evt.getOldValue(), evt.getNewValue());
            evt.setPropagationId(propagationId);
            this.firePropertyChange(evt);
            return;
        }
        if (this.getPropertyCount() > 0) {
            this.firePropertyChange(evt);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PropertyChangeListener.class) continue;
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(evt);
            }
        }
        if (this.parent != null) {
            this.parent.propagatePropertyChange(evt);
        }
    }

    protected void propagatePropertyChange(PropertyChangeEvent evt) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PropertyChangeListener.class) continue;
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(evt);
            }
        }
        if (this.parent != null) {
            evt = new PropertyChangeEvent(evt.getSource(), this.descriptor.getName() + "/" + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            this.parent.propagatePropertyChange(evt);
        }
    }

    public static class PropWrapper {
        private final String name;
        private final Object owner;

        public PropWrapper(Object owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public DynamicPropertySet getOwner() {
            return (DynamicPropertySet)this.owner;
        }

        public Object getValue() {
            return ((DynamicPropertySet)this.owner).getValue(this.name);
        }

        public void setValue(Object value) {
            ((DynamicPropertySet)this.owner).setValue(this.name, value);
        }

        public Object getIndexedValue(int index) {
            return Array.get(((DynamicPropertySet)this.owner).getValue(this.name), index);
        }

        public void setIndexedValue(int index, Object value) {
            Array.set(((DynamicPropertySet)this.owner).getValue(this.name), index, value);
        }
    }

    static class DynValueIndexedPropertyDescriptor
    extends IndexedPropertyDescriptor {
        private Object owner = null;
        private Class<?> type = null;

        public DynValueIndexedPropertyDescriptor(Object owner, Class<?> type, IndexedPropertyDescriptor orig) throws IntrospectionException {
            super(orig.getName(), classRetriever.getClass(), "getValue", "setValue", "getIndexedValue", "setIndexedValue");
            this.owner = owner;
            this.type = type;
            this.setExpert(orig.isExpert());
            this.setHidden(orig.isHidden());
            this.setPreferred(orig.isPreferred());
            this.setDisplayName(orig.getDisplayName());
            this.setShortDescription(orig.getShortDescription());
            Enumeration<String> e = orig.attributeNames();
            while (e.hasMoreElements()) {
                String atr = e.nextElement();
                super.setValue(atr, orig.getValue(atr));
            }
        }

        @Override
        public Class<?> getPropertyType() {
            Object value;
            if (this.owner != null && (value = ((DynamicPropertySet)this.owner).getValue(this.getName())) != null && value.getClass().isArray()) {
                return value.getClass();
            }
            return this.type;
        }

        @Override
        public Class<?> getIndexedPropertyType() {
            return this.getPropertyType().getComponentType();
        }
    }

    static class DynValuePropertyDescriptor
    extends PropertyDescriptor {
        private final Object owner;
        private final Class<?> type;
        private final PropertyDescriptor orig;

        public DynValuePropertyDescriptor(Object owner, Class<?> type, PropertyDescriptor orig) throws IntrospectionException {
            super(orig.getName(), classRetriever.getClass(), "getValue", "setValue");
            this.owner = owner;
            this.type = type;
            this.orig = orig;
            this.setExpert(orig.isExpert());
            this.setPreferred(orig.isPreferred());
            this.setBound(orig.isBound());
            this.setConstrained(orig.isConstrained());
            this.setPropertyEditorClass(orig.getPropertyEditorClass());
            this.setDisplayName(orig.getDisplayName());
            this.setShortDescription(orig.getShortDescription());
            Enumeration<String> e = orig.attributeNames();
            while (e.hasMoreElements()) {
                String atr = e.nextElement();
                super.setValue(atr, orig.getValue(atr));
            }
        }

        @Override
        public boolean isHidden() {
            return this.orig.isHidden();
        }

        @Override
        public void setHidden(boolean value) {
            this.orig.setHidden(value);
        }

        @Override
        public Class<?> getPropertyType() {
            Object value = ((DynamicPropertySet)this.owner).getValue(this.getName());
            return value != null ? value.getClass() : this.type;
        }
    }
}

