/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import com.developmentontheedge.beans.model.InternalConstants;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Enumeration;

public class MergedPropertyDescriptor
extends PropertyDescriptor
implements InternalConstants {
    private PropertyDescriptor propertyDescriptor;
    private BeanDescriptor beanDescriptor;
    private boolean isDynamic;

    public MergedPropertyDescriptor(PropertyDescriptor propertyDescriptor, BeanDescriptor beanDescriptor, boolean isDynamic) throws IntrospectionException {
        super(propertyDescriptor.getName(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
        String attr;
        this.propertyDescriptor = propertyDescriptor;
        this.beanDescriptor = beanDescriptor;
        this.isDynamic = isDynamic;
        Enumeration<String> e = beanDescriptor.attributeNames();
        while (e.hasMoreElements()) {
            attr = e.nextElement();
            this.setValue(attr, beanDescriptor.getValue(attr));
        }
        e = propertyDescriptor.attributeNames();
        while (e.hasMoreElements()) {
            attr = e.nextElement();
            this.setValue(attr, propertyDescriptor.getValue(attr));
        }
        this.setValue("bean descriptor", beanDescriptor);
        this.setValue("property descriptor", propertyDescriptor);
    }

    @Override
    public boolean isBound() {
        return this.propertyDescriptor.isBound();
    }

    @Override
    public void setBound(boolean bound) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden() {
        return this.propertyDescriptor.isHidden();
    }

    @Override
    public void setHidden(boolean hidden) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConstrained() {
        return this.propertyDescriptor.isConstrained();
    }

    @Override
    public void setConstrained(boolean constrained) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isExpert() {
        return this.propertyDescriptor.isExpert();
    }

    @Override
    public boolean isPreferred() {
        return this.propertyDescriptor.isPreferred();
    }

    @Override
    public void setPreferred(boolean preferred) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDisplayName() {
        if (!this.isDynamic && this.propertyDescriptor.getDisplayName().equals(this.propertyDescriptor.getName()) && !this.beanDescriptor.getDisplayName().equals(this.beanDescriptor.getName())) {
            return this.beanDescriptor.getDisplayName();
        }
        return this.propertyDescriptor.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getShortDescription() {
        if (this.propertyDescriptor.getShortDescription().equals(this.propertyDescriptor.getName()) && !this.beanDescriptor.getShortDescription().equals(this.beanDescriptor.getName())) {
            return this.beanDescriptor.getShortDescription();
        }
        return this.propertyDescriptor.getShortDescription();
    }

    @Override
    public void setShortDescription(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> getPropertyEditorClass() {
        Class<?> cc;
        if (this.propertyDescriptor.getPropertyEditorClass() != null) {
            return this.propertyDescriptor.getPropertyEditorClass();
        }
        Class<?> editor = (Class<?>)this.beanDescriptor.getValue("bean-editor-class");
        if (editor == null && (cc = this.beanDescriptor.getCustomizerClass()) != null && PropertyEditor.class.isAssignableFrom(cc)) {
            editor = cc;
            this.beanDescriptor.setValue("bean-editor-class", editor);
        }
        return editor;
    }

    @Override
    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        throw new UnsupportedOperationException();
    }
}

