/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import com.developmentontheedge.beans.BeanEventListener;
import com.developmentontheedge.beans.DefaultValue;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.BeanEvent;
import com.developmentontheedge.beans.model.BeanMethod;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.Property;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Vector;

public class CompositeProperty
extends Property {
    protected Object bean;
    protected BeanInfo beanInfo;
    protected Vector<Property> properties;
    protected Vector<BeanEvent> events;
    protected Vector<BeanMethod> methods;
    protected volatile boolean propertiesInitialized = false;
    protected boolean eventsInitialized = false;
    protected boolean methodsInitialized = false;
    private boolean propertiesInitializing = false;
    protected ComponentFactory.Policy policy;

    public ComponentFactory.Policy getPolicy() {
        return this.policy;
    }

    protected CompositeProperty(Property parent, Object owner, PropertyDescriptor descriptor, BeanInfo beanInfo, ComponentFactory.Policy policy) {
        super(parent, owner, descriptor);
        this.bean = owner;
        this.beanInfo = beanInfo;
        this.policy = policy;
        this.setExpanded(false);
        this.propertiesInitialized = false;
        this.eventsInitialized = false;
        this.methodsInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initProperties() {
        if (this.propertiesInitialized) {
            return;
        }
        CompositeProperty compositeProperty = this;
        synchronized (compositeProperty) {
            if (this.propertiesInitialized || this.propertiesInitializing) {
                return;
            }
            this.propertiesInitializing = true;
            this.properties = new Vector();
            try {
                if (this.parent != null) {
                    Object defValue;
                    Object value = this.getValue();
                    if (value == null && (defValue = this.descriptor.getValue("defaultValue")) != null) {
                        value = defValue instanceof DefaultValue ? ((DefaultValue)defValue).clone() : (defValue instanceof Method ? ((Method)defValue).invoke(this.getOwner(), (Object[])null) : defValue);
                    }
                    ComponentFactory.createProperties(value, this.getValueClass(), this.beanInfo, this, this.properties, this.policy);
                } else {
                    ComponentFactory.createProperties(this.bean, this.bean.getClass(), this.beanInfo, this, this.properties, this.policy);
                }
            }
            catch (Exception e) {
                Logger.getLogger().error("initProperties()", e);
            }
            this.propertiesInitializing = false;
            this.propertiesInitialized = true;
        }
    }

    protected void initEvents() {
        if (this.eventsInitialized) {
            return;
        }
        this.events = new Vector();
        EventSetDescriptor[] eventsArray = this.beanInfo.getEventSetDescriptors();
        for (int i = 0; i < eventsArray.length; ++i) {
            BeanEvent evt = ComponentFactory.createEvent(this, eventsArray[i]);
            if (evt == null) continue;
            this.events.add(evt);
        }
        this.eventsInitialized = true;
    }

    protected void initMethods() {
        if (this.methodsInitialized) {
            return;
        }
        this.methods = new Vector();
        MethodDescriptor[] methodsArray = this.beanInfo.getMethodDescriptors();
        Object methodOwner = this.getValue();
        for (int i = 0; i < methodsArray.length; ++i) {
            BeanMethod meth = ComponentFactory.createMethod(methodOwner, methodsArray[i]);
            if (meth == null) continue;
            this.methods.add(meth);
        }
        this.methodsInitialized = true;
    }

    @Override
    public int getPropertyCount() {
        this.initProperties();
        return this.properties.size();
    }

    @Override
    public Property getPropertyAt(int index) {
        this.initProperties();
        return this.properties.elementAt(index);
    }

    public int getEventCount() {
        if (!this.eventsInitialized) {
            this.initEvents();
        }
        return this.events.size();
    }

    public BeanEvent getEventAt(int index) {
        if (!this.eventsInitialized) {
            this.initEvents();
        }
        return this.events.elementAt(index);
    }

    public int getMethodCount() {
        if (!this.methodsInitialized) {
            this.initMethods();
        }
        return this.methods.size();
    }

    public BeanMethod getMethodAt(int index) {
        if (!this.methodsInitialized) {
            this.initMethods();
        }
        return this.methods.elementAt(index);
    }

    public Object getBean() {
        return this.bean;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public void addBeanEventListener(String eventName, BeanEventListener listener) {
        for (BeanEvent be : this.events) {
            if (!be.getName().equals(eventName)) continue;
            be.addBeanEventListener(listener);
            break;
        }
    }

    public void removeBeanEventListener(String eventName, BeanEventListener listener) {
        for (BeanEvent be : this.events) {
            if (!be.getName().equals(eventName)) continue;
            be.removeBeanEventListener(listener);
            break;
        }
    }

    public void addBeanEventListener(BeanEventListener listener) {
        for (BeanEvent be : this.events) {
            be.addBeanEventListener(listener);
        }
    }

    public void removeBeanEventListener(BeanEventListener listener) {
        for (BeanEvent be : this.events) {
            be.removeBeanEventListener(listener);
        }
    }
}

