/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.IconResource;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ArrayProperty;
import com.developmentontheedge.beans.model.BeanEvent;
import com.developmentontheedge.beans.model.BeanMethod;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.CompositeProperty;
import com.developmentontheedge.beans.model.DynamicSetProperty;
import com.developmentontheedge.beans.model.InternalConstants;
import com.developmentontheedge.beans.model.MergedPropertyDescriptor;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.model.SimpleProperty;
import java.awt.Color;
import java.awt.Event;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ComponentFactory
implements InternalConstants {
    public static final String DEFAULT_SWING_BEANINFO_PATH = "com.developmentontheedge.beans.swing.infos";
    public static final String DEFAULT_AWT_BEANINFO_PATH = "com.developmentontheedge.beans.awt.infos";
    public static final int DEFAULT_MAX_PROPERTY_LEVEL = 7;
    private static final HashMap<String, Class<?>> classList = new HashMap();
    protected static final WeakHashMap<Object, WeakReference<ComponentModel>> instanceList = new WeakHashMap();
    private static String[] originalBeanInfoSearchPath;
    private static URLClassLoaderEx classLoader;
    private static SimpleProperty simplePropertyClassRetriver;

    protected static void createProperties(Object owner, Class<?> c, BeanInfo info, Property parent, Vector<Property> vProperties, Policy policy) {
        if (owner instanceof Property.PropWrapper) {
            owner = ((Property.PropWrapper)owner).getOwner();
        }
        try {
            if (owner == null) {
                if (c.toString().startsWith("interface") || (c.getModifiers() & 0x400) != 0) {
                    Logger.getLogger().warn("Cannot create properties for \"" + c + "\" in " + parent.getCompleteName() + " since it is interface or abstract class");
                    return;
                }
                if (ComponentFactory.findDefaultPublicConstructor(c) == null) {
                    Object obj = ComponentFactory.findStaticInstance(c);
                    if (obj == null) {
                        Logger.getLogger().warn("createProperties: No default constructor and no static instance found (owner is null) in " + parent.getCompleteName());
                        return;
                    }
                    owner = obj;
                } else {
                    owner = c.newInstance();
                }
            }
            if (info == null) {
                info = Introspector.getBeanInfo(c);
            }
            if (owner instanceof DynamicPropertySet) {
                Iterator<DynamicProperty> iterator = ((DynamicPropertySet)owner).propertyIterator();
                while (iterator.hasNext()) {
                    DynamicProperty dynamicProperty = iterator.next();
                    if (dynamicProperty != null) {
                        Property p = ComponentFactory.createProperty(dynamicProperty.getType(), owner, dynamicProperty.getDescriptor(), parent, policy);
                        if (p == null || policy.getSkipClassProperty() && p.getName().equals("class")) continue;
                        vProperties.addElement(p);
                        if (!policy.getAddPropertyChangeListeners()) continue;
                        p.addPropertyChangeListener(parent);
                        continue;
                    }
                    Logger.getLogger().error("Iterator.next() returned null dynamic property");
                }
            } else {
                PropertyDescriptor[] properties = (PropertyDescriptor[])info.getBeanDescriptor().getValue("properties-order");
                if (properties == null) {
                    properties = info.getPropertyDescriptors();
                }
                for (int i = 0; i < properties.length; ++i) {
                    PropertyDescriptor descr = properties[i];
                    Class<?> propType = ComponentFactory.derivePropertyType(owner, descr);
                    Property p = ComponentFactory.createProperty(propType, owner, descr, parent, policy);
                    if (p == null || policy.getSkipClassProperty() && p.getName().equals("class")) continue;
                    vProperties.addElement(p);
                    if (!policy.getAddPropertyChangeListeners()) continue;
                    p.addPropertyChangeListener(parent);
                }
            }
        }
        catch (Throwable t) {
            Logger.getLogger().error("Error when creating properties in " + parent.getCompleteName(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Property createProperty(Class<?> type, Object owner, PropertyDescriptor descriptor, Property parent, Policy policy) throws IntrospectionException {
        Object noRecursion;
        boolean isSimple;
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null) {
            if (!readMethod.getDeclaringClass().isAssignableFrom(owner.getClass())) {
                Logger.getLogger().error("Ignoring " + parent.getCompleteName() + "/" + descriptor.getName() + " since it's read method (" + readMethod.getDeclaringClass().getName() + "." + readMethod.getName() + ") doesn't belong to this bean class (" + owner.getClass().getName() + "). Perhaps PropertyDescriptor is incorrect.");
                return null;
            }
            try {
                readMethod.invoke(owner, (Object[])null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (Exception e) {
                Logger.getLogger().error("Error creating property '" + descriptor.getName() + "' in " + parent.getCompleteName() + ", owner = " + owner + ", readMethod = " + readMethod, e);
                return null;
            }
        }
        if (descriptor instanceof IndexedPropertyDescriptor || type.isArray() && !byte[].class.equals(type)) {
            ArrayProperty arrayProperty = new ArrayProperty(parent, owner, descriptor, policy);
            Object itemPrototype = descriptor.getValue("item-prototype");
            if (itemPrototype != null) {
                arrayProperty.setItemPrototype(itemPrototype);
            }
            if (!arrayProperty.isHideChildren()) {
                return arrayProperty;
            }
        }
        if (readMethod == null && descriptor.getWriteMethod() != null) {
            try {
                type.newInstance();
            }
            catch (Exception arrayProperty) {
                // empty catch block
            }
        }
        String typeName = type.getName();
        BeanInfo typeBeanInfo = Introspector.getBeanInfo(type);
        BeanDescriptor beanDescriptor = typeBeanInfo.getBeanDescriptor();
        if (beanDescriptor != null) {
            BeanDescriptor beanDescriptor2 = beanDescriptor;
            synchronized (beanDescriptor2) {
                beanDescriptor.attributeNames();
            }
        }
        descriptor = ComponentFactory.merge(beanDescriptor, descriptor, owner instanceof DynamicPropertySet);
        boolean bl = isSimple = (type.isPrimitive() || typeName.indexOf("java.lang") >= 0) && typeName.indexOf("java.lang.Object") == -1;
        if (!isSimple && descriptor.getValue("node-simple") != null) {
            isSimple = descriptor.getValue("node-simple").equals(Boolean.TRUE);
        }
        if (isSimple) {
            return new SimpleProperty(parent, owner, descriptor);
        }
        if (DynamicPropertySet.class.isAssignableFrom(type)) {
            return new DynamicSetProperty(parent, owner, descriptor, typeBeanInfo, policy);
        }
        if (parent != null && ((noRecursion = descriptor.getValue("node-no-recursion-check")) == null || !noRecursion.equals(Boolean.TRUE)) && parent.isRecursive(type)) {
            return null;
        }
        return new CompositeProperty(parent, owner, descriptor, typeBeanInfo, policy);
    }

    protected static Class<?> derivePropertyType(Object owner, PropertyDescriptor descr) {
        Method method;
        boolean isSafeToInvoke;
        Class<?> propType = descr.getPropertyType();
        boolean bl = isSafeToInvoke = propType == null || !Event.class.isAssignableFrom(propType);
        if (owner != null && isSafeToInvoke && (method = descr.getReadMethod()) != null) {
            try {
                Class<?> tmpClass;
                Object propInstance = method.invoke(owner, (Object[])null);
                if (propInstance != null && (tmpClass = propInstance.getClass()) != null) {
                    propType = tmpClass;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return propType;
    }

    protected static BeanEvent createEvent(Property ownerProperty, EventSetDescriptor esd) {
        try {
            BeanEvent be = new BeanEvent(ownerProperty, esd);
            EventListener listener = (EventListener)Proxy.newProxyInstance(esd.getListenerType().getClassLoader(), new Class[]{esd.getListenerType()}, (InvocationHandler)be);
            Method method = esd.getAddListenerMethod();
            method.invoke(ownerProperty.getValue(), listener);
            return be;
        }
        catch (Exception exc) {
            if (exc instanceof IllegalAccessException || exc instanceof InvocationTargetException) {
                Logger.getLogger().error("Error adding listener for the event \"" + esd.getName() + "\"", exc);
            }
            return null;
        }
    }

    protected static BeanMethod createMethod(Object owner, MethodDescriptor md) {
        BeanMethod bm = new BeanMethod(owner, md);
        return bm;
    }

    public static Class<?> forName(String aName) {
        try {
            String sName = null;
            Class<?> c = null;
            Class<?>[] classes = ComponentFactory.getLoadedClasses();
            for (int i = 0; i < classes.length; ++i) {
                c = classes[i];
                BeanInfo beanInfo = Introspector.getBeanInfo(c);
                sName = beanInfo.getBeanDescriptor().getName();
                if (!aName.equals(sName)) continue;
                return c;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        Logger.getLogger().error("ComponentFactory cannot find class '" + aName + "'");
        return null;
    }

    private static ComponentModel createComponentModel(Object comp, Policy policy) {
        try {
            Class<?> c = comp.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(c);
            ComponentModel model = new ComponentModel(comp, beanInfo, policy);
            return model;
        }
        catch (Exception e) {
            Logger.getLogger().error("ComponentFactory cannot create model for " + comp, e);
            return null;
        }
    }

    public static ComponentModel filterComponentModel(ComponentModel origin, String[] filter) {
        if (filter == null) {
            return origin;
        }
        ComponentModel filtered = new ComponentModel(origin.getBean(), origin.getBeanInfo(), origin.getPolicy());
        filtered.properties = new Vector();
        for (int i = 0; i < filter.length; ++i) {
            Property property = origin.findProperty(filter[i]);
            if (property != null) {
                filtered.properties.addElement(property);
                if (filter[i].indexOf("/") >= 0) continue;
                property.addPropertyChangeListener(filtered);
                continue;
            }
            Logger.getLogger().error("When filtering property not found: " + filter[i] + " in " + filtered.getName());
        }
        filtered.setExpanded(true);
        filtered.propertiesInitialized = true;
        return filtered;
    }

    public static ComponentModel filterByRemovingParentProperties(ComponentModel origin) {
        try {
            ComponentModel filtered = new ComponentModel(origin.getBean(), origin.getBeanInfo(), origin.getPolicy());
            filtered.properties = new Vector();
            BeanInfo parentBeanInfo = Introspector.getBeanInfo(origin.getBean().getClass().getSuperclass());
            PropertyDescriptor[] pds = parentBeanInfo.getPropertyDescriptors();
            for (int i = 0; i < origin.getPropertyCount(); ++i) {
                Property property = origin.getPropertyAt(i);
                String name = property.getName();
                boolean hasParent = false;
                for (int j = 0; j < pds.length; ++j) {
                    if (!name.equals(pds[j].getName())) continue;
                    hasParent = true;
                    break;
                }
                if (!hasParent) {
                    filtered.properties.addElement(property);
                    property.addPropertyChangeListener(filtered);
                    continue;
                }
                filtered.addPropertyToRemove(property.getCompleteName());
            }
            filtered.setExpanded(true);
            filtered.propertiesInitialized = true;
            return filtered;
        }
        catch (Exception e) {
            Logger.getLogger().error("ComponentFactory cannot create filtered model for " + origin, e);
            return origin;
        }
    }

    public static void loadComponents(String path, String subdir) {
        File[] files = null;
        int i = 0;
        try {
            File dir = new File(subdir.length() == 0 ? path : path + '/' + subdir);
            files = dir.isDirectory() ? dir.listFiles() : new File[]{dir};
            for (i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ComponentFactory.loadComponents(path, subdir.length() == 0 ? files[i].getName() : subdir + '/' + files[i].getName());
                    continue;
                }
                if (!files[i].getName().endsWith(".jar")) continue;
                ComponentFactory.loadComponents(files[i]);
            }
        }
        catch (Throwable e) {
            Logger.getLogger().error("Error while loading components", e);
        }
    }

    protected static void loadComponents(File f) {
        String compName = "";
        compName = f.getName();
        String path = "file:" + f.getPath();
        try {
            URL url = new URL(path);
            classLoader.addURL(url);
            try (JarFile jar = new JarFile(f);){
                Manifest mf = jar.getManifest();
                Map<String, Attributes> entries = mf.getEntries();
                for (String name : entries.keySet()) {
                    if (name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(".jpg") || name.endsWith(".JPG") || name.endsWith(".jpeg") || name.endsWith(".JPEG")) continue;
                    int end = name.indexOf(".class");
                    if (end != -1) {
                        name = name.substring(0, end);
                    }
                    name = name.replace('/', '.');
                    name = name.replace('\\', '.');
                    try {
                        classLoader.getURLs();
                        Class<?> c = classLoader.loadClass(name);
                        classList.put(name, c);
                    }
                    catch (Throwable e) {
                        Logger.getLogger().error("Error while loading component \"" + compName + ":" + name + "\"", e);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().error("Error while loading component \"" + compName + "\"", e);
        }
    }

    public static Image getIcon(Class<?> c) {
        return ComponentFactory.getIcon(c, 2);
    }

    public static Image getIcon(Class<?> c, int iconKind) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(c);
            return beanInfo.getIcon(iconKind);
        }
        catch (Exception e) {
            Logger.getLogger().error("Error while getting icon for \"" + c + "\"", e);
            return null;
        }
    }

    public static Class<?>[] getLoadedClasses() {
        return classList.values().toArray(new Class[0]);
    }

    public static ComponentModel getModel(String aName, Policy policy) {
        Class<?> clazz = ComponentFactory.forName(aName);
        return ComponentFactory.getModel(clazz, policy);
    }

    public static ComponentModel getModel(Class<?> c, Policy policy) {
        try {
            return ComponentFactory.getModel(c.newInstance(), policy);
        }
        catch (Exception e) {
            Logger.getLogger().error("ComponentFactory cannot instantiate " + c, e);
            return null;
        }
    }

    public static ComponentModel getModel(Object bean) {
        return ComponentFactory.getModel(bean, Policy.DEFAULT, false);
    }

    public static ComponentModel getModel(Object bean, Policy policy) {
        return ComponentFactory.getModel(bean, policy, false);
    }

    public static ComponentModel getModel(Object bean, Policy policy, boolean bIgnoreCache) {
        if (bean instanceof ComponentModel) {
            return (ComponentModel)bean;
        }
        ComponentModel model = null;
        if (!bIgnoreCache) {
            model = ComponentFactory.getFromComponentCache(bean);
        }
        if (model == null && (model = ComponentFactory.createComponentModel(bean, policy)) != null && !bIgnoreCache) {
            ComponentFactory.putIntoComponentCache(bean, model);
        }
        return model;
    }

    public static DynamicPropertySet toDPS(ComponentModel model) throws Exception {
        DynamicPropertySetSupport dpsObj = new DynamicPropertySetSupport();
        int limit = model.getPropertyCount();
        for (int i = 0; i < limit; ++i) {
            Property property = model.getPropertyAt(i);
            FeatureDescriptor desc = property.getDescriptor();
            if (desc instanceof PropertyDescriptor) {
                dpsObj.add(new DynamicProperty((PropertyDescriptor)desc, property.getValueClass(), property.getValue()));
                continue;
            }
            dpsObj.add(new DynamicProperty(property.getName(), property.getDisplayName(), property.getValueClass(), property.getValue()));
        }
        return dpsObj;
    }

    protected static PropertyDescriptor merge(BeanDescriptor beanDescriptor, PropertyDescriptor propertyDescriptor, boolean isDynamic) {
        if (beanDescriptor == null) {
            return propertyDescriptor;
        }
        ComponentFactory.processIcons(beanDescriptor);
        try {
            if (propertyDescriptor == null) {
                PropertyDescriptor result = new PropertyDescriptor(beanDescriptor.getName(), null, null);
                Class<?> editor = beanDescriptor.getCustomizerClass();
                if (editor != null && PropertyEditor.class.isAssignableFrom(editor)) {
                    result.setPropertyEditorClass(editor);
                }
                result.setDisplayName(beanDescriptor.getDisplayName());
                result.setShortDescription(beanDescriptor.getShortDescription());
                Enumeration<String> e = beanDescriptor.attributeNames();
                while (e.hasMoreElements()) {
                    String atr = e.nextElement();
                    result.setValue(atr, beanDescriptor.getValue(atr));
                }
                result.setValue("bean descriptor", beanDescriptor);
                return result;
            }
            return new MergedPropertyDescriptor(propertyDescriptor, beanDescriptor, isDynamic);
        }
        catch (Throwable t) {
            Logger.getLogger().error("Error during merge", t);
            return propertyDescriptor;
        }
    }

    private static void processIcons(BeanDescriptor beanDescriptor) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanDescriptor.getBeanClass());
            Image icon = beanInfo.getIcon(1);
            if (icon != null && beanDescriptor.getValue("node-icon: color16x16") == null) {
                beanDescriptor.setValue("node-icon: color16x16", new IconResource(null, icon));
            }
            if ((icon = beanInfo.getIcon(3)) != null && beanDescriptor.getValue("node-icon: mono16x16") == null) {
                beanDescriptor.setValue("node-icon: mono16x16", new IconResource(null, icon));
            }
            if ((icon = beanInfo.getIcon(2)) != null && beanDescriptor.getValue("node-icon: color32x32") == null) {
                beanDescriptor.setValue("node-icon: color32x32", new IconResource(null, icon));
            }
            if ((icon = beanInfo.getIcon(4)) != null && beanDescriptor.getValue("node-icon: mono32x32") == null) {
                beanDescriptor.setValue("node-icon: mono32x32", new IconResource(null, icon));
            }
        }
        catch (Exception e) {
            Logger.getLogger().error("Error when process icons for " + beanDescriptor.getBeanClass(), e);
        }
    }

    public static void updateDescriptor(Property property, BeanDescriptor beanDescriptor, PropertyDescriptor propertyDescriptor) {
        property.descriptor = ComponentFactory.merge(beanDescriptor, propertyDescriptor, false);
    }

    public static void recreateChildProperties(Property p) {
        if (!(p instanceof CompositeProperty) || !((CompositeProperty)p).propertiesInitialized) {
            return;
        }
        CompositeProperty property = (CompositeProperty)p;
        if (property.properties != null) {
            property.properties.removeAllElements();
        }
        ComponentFactory.createProperties(property.getValue(), property.getBean().getClass(), property.getBeanInfo(), property, property.properties, property.getPolicy());
        if (property instanceof ComponentModel && ((ComponentModel)property).hasPropertiesToRemove()) {
            String[] properties = ((ComponentModel)property).getPropertiesToRemove();
            for (int i = 0; i < properties.length; ++i) {
                Property propertyToRemove = property.findProperty(properties[i]);
                if (propertyToRemove == null) continue;
                property.properties.removeElement(propertyToRemove);
            }
        }
    }

    public static void sort(CompositeProperty cp, Comparator<Property> comparator) {
        Collections.sort(cp.properties, comparator);
    }

    public static void setSwingMode() {
        String[] newPath = new String[originalBeanInfoSearchPath.length + 1];
        newPath[0] = DEFAULT_SWING_BEANINFO_PATH;
        System.arraycopy(originalBeanInfoSearchPath, 0, newPath, 1, originalBeanInfoSearchPath.length);
        Introspector.setBeanInfoSearchPath(newPath);
    }

    public static void setAWTMode() {
        String[] newPath = new String[originalBeanInfoSearchPath.length + 1];
        newPath[0] = DEFAULT_AWT_BEANINFO_PATH;
        System.arraycopy(originalBeanInfoSearchPath, 0, newPath, 1, originalBeanInfoSearchPath.length);
        Introspector.setBeanInfoSearchPath(newPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putIntoComponentCache(Object bean, ComponentModel model) {
        WeakHashMap<Object, WeakReference<ComponentModel>> weakHashMap = instanceList;
        synchronized (weakHashMap) {
            instanceList.put(bean, new WeakReference<ComponentModel>(model));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ComponentModel getFromComponentCache(Object bean) {
        WeakHashMap<Object, WeakReference<ComponentModel>> weakHashMap = instanceList;
        synchronized (weakHashMap) {
            WeakReference<ComponentModel> ref = instanceList.get(bean);
            ComponentModel model = ref == null ? null : ref.get();
            return model;
        }
    }

    static Constructor<?> findDefaultPublicConstructor(Class<?> clazz) {
        Constructor<?> constructor = null;
        Constructor<?>[] cList = clazz.getConstructors();
        for (int i = 0; i < cList.length; ++i) {
            if (cList[i].getParameterTypes().length != 0) continue;
            constructor = cList[i];
            break;
        }
        return constructor;
    }

    public static Object instanceForClass(Class<?> c) {
        Object param = null;
        if (c.isArray()) {
            param = null;
        } else if (c.toString().equals("boolean") || c == Boolean.class) {
            param = Boolean.TRUE;
        } else if (c.toString().equals("int") || c == Integer.class) {
            param = 1;
        } else if (c.toString().equals("long") || c == Long.class) {
            param = 1L;
        } else if (c.toString().equals("float") || c == Float.class) {
            param = Float.valueOf(1.0f);
        } else if (c.toString().equals("double") || c == Double.class) {
            param = 1.0;
        } else if (c == Color.class) {
            param = Color.white;
        } else if (c == String.class) {
            param = "";
        } else if (c == Object.class) {
            param = new Object();
        } else if (c.isInterface()) {
            param = null;
        } else {
            param = null;
            Constructor<?> constructor = null;
            try {
                constructor = c.getConstructor(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                param = constructor != null ? constructor.newInstance(null) : null;
            }
            catch (Exception e) {
                param = null;
            }
        }
        return param;
    }

    public static Object findStaticInstance(Class<?> clazz) throws Exception {
        Field[] fList = clazz.getFields();
        for (int i = 0; i < fList.length; ++i) {
            if ((fList[i].getModifiers() & 8) == 0 || !fList[i].getType().equals(clazz)) continue;
            return fList[i].get(null);
        }
        Method[] mList = clazz.getMethods();
        for (int i = 0; i < mList.length; ++i) {
            if ((mList[i].getModifiers() & 8) == 0 || mList[i].getParameterTypes().length != 0 || !mList[i].getReturnType().equals(clazz)) continue;
            return mList[i].invoke(null, new Object[0]);
        }
        return null;
    }

    public static Class<? extends SimpleProperty> getPropertyClassInObfuscatedVersion() {
        return simplePropertyClassRetriver.getClass();
    }

    public static String getHTMLClassName(Class<?> clazz) {
        return "<html><code>" + ComponentFactory.getClassName(clazz) + "</code></html>";
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        if (clazz.toString().equals("boolean")) {
            return "boolean";
        }
        if (clazz.toString().equals("int")) {
            return "int";
        }
        if (clazz.toString().equals("long")) {
            return "long";
        }
        if (clazz.toString().equals("float")) {
            return "float";
        }
        if (clazz.toString().equals("double")) {
            return "double";
        }
        if (clazz.toString().equals("byte")) {
            return "byte";
        }
        if (clazz.toString().equals("char")) {
            return "char";
        }
        if (clazz.toString().equals("short")) {
            return "short";
        }
        StringTokenizer strTok = new StringTokenizer(clazz.getName(), ".");
        String name = null;
        while (strTok.hasMoreTokens()) {
            name = strTok.nextToken();
        }
        if (name.startsWith("[") || name.endsWith(";")) {
            String fullName = clazz.getName();
            int dim = fullName.lastIndexOf("[");
            String type = fullName.substring(dim + 1, dim + 2);
            StringBuffer buff = new StringBuffer("");
            if (type.equals("L")) {
                buff.append(name.substring(0, name.length() - 1));
            } else if (type.equals("B")) {
                buff.append("byte");
            } else if (type.equals("C")) {
                buff.append("char");
            } else if (type.equals("D")) {
                buff.append("double");
            } else if (type.equals("F")) {
                buff.append("float");
            } else if (type.equals("I")) {
                buff.append("int");
            } else if (type.equals("J")) {
                buff.append("long");
            } else if (type.equals("S")) {
                buff.append("short");
            } else if (type.equals("Z")) {
                buff.append("boolean");
            }
            while (dim-- >= 0) {
                buff.append("[]");
            }
            name = buff.toString();
        }
        return name;
    }

    static {
        Introspector.flushCaches();
        originalBeanInfoSearchPath = Introspector.getBeanInfoSearchPath();
        ComponentFactory.setSwingMode();
        classLoader = new URLClassLoaderEx();
        simplePropertyClassRetriver = new SimpleProperty(null, null, null);
    }

    private static class URLClassLoaderEx
    extends URLClassLoader {
        public URLClassLoaderEx() {
            super(new URL[0]);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }

    public static class Policy {
        public static final Policy DEFAULT = new Policy(false, false);
        public static final Policy UI = new Policy(true, true);
        private boolean addPropertyChangeListeners;
        private boolean skipClassProperty;

        public Policy() {
            this(false, false);
        }

        public Policy(boolean addPropertyChangeListeners, boolean skipClassProperty) {
            this.addPropertyChangeListeners = addPropertyChangeListeners;
            this.skipClassProperty = skipClassProperty;
        }

        public boolean getAddPropertyChangeListeners() {
            return this.addPropertyChangeListeners;
        }

        public boolean getSkipClassProperty() {
            return this.skipClassProperty;
        }
    }
}

