/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanMethod {
    private String displayName;
    private final MethodDescriptor descriptor;
    private final Object owner;
    private boolean voidType = true;
    private int paramCount = 0;

    public BeanMethod(Object owner, MethodDescriptor descriptor) {
        this.owner = owner;
        this.descriptor = descriptor;
        this.init();
    }

    protected void init() {
        StringBuffer result = new StringBuffer(this.descriptor.getDisplayName());
        result.append("(");
        ParameterDescriptor[] params = this.descriptor.getParameterDescriptors();
        if (params != null) {
            this.voidType = true;
            this.paramCount = params.length;
            for (int i = 0; i < params.length; ++i) {
                result.append(params[i].getDisplayName());
                if (i >= params.length - 1) continue;
                result.append(", ");
            }
        } else {
            Method meth = this.descriptor.getMethod();
            if (meth != null) {
                this.voidType = meth.getReturnType().equals(Void.TYPE);
                Class<?>[] pars = meth.getParameterTypes();
                this.paramCount = pars.length;
                for (int i = 0; i < pars.length; ++i) {
                    String pclass = pars[i].getName();
                    StringBuffer arr = new StringBuffer("");
                    int l = 0;
                    while (true) {
                        if (!pclass.substring(l, 1).equals("[")) break;
                        arr.append("[]");
                        ++l;
                    }
                    pclass = pclass.substring(l);
                    int index = pclass.lastIndexOf(".");
                    if (index > 0) {
                        pclass = pclass.substring(index + 1);
                    }
                    result.append(pclass + arr.toString());
                    if (i >= pars.length - 1) continue;
                    result.append(", ");
                }
            }
        }
        result.append(")");
        this.displayName = result.toString();
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object invoke() {
        try {
            this.descriptor.getMethod().invoke(this.owner, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public boolean isVoidType() {
        return this.voidType;
    }

    public int getParamCount() {
        return this.paramCount;
    }
}

