/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import com.developmentontheedge.beans.BeanEventListener;
import com.developmentontheedge.beans.BeanEventObject;
import com.developmentontheedge.beans.model.Property;
import java.beans.EventSetDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.swing.event.EventListenerList;

public class BeanEvent
implements InvocationHandler {
    private final EventListenerList listenerList = new EventListenerList();
    private final EventSetDescriptor descriptor;
    private final Property ownerProperty;

    public BeanEvent(Property ownerProperty, EventSetDescriptor descriptor) {
        this.ownerProperty = ownerProperty;
        this.descriptor = descriptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BeanEventListener.class) continue;
            ((BeanEventListener)listeners[i + 1]).beanEvent(new BeanEventObject(this.ownerProperty.getValue(), this.getName(), this.ownerProperty.getCompleteName(), method.getName(), args));
        }
        return null;
    }

    public void addBeanEventListener(BeanEventListener listener) {
        this.listenerList.add(BeanEventListener.class, listener);
    }

    public void removeBeanEventListener(BeanEventListener listener) {
        this.listenerList.remove(BeanEventListener.class, listener);
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public EventSetDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Property getOwnerProperty() {
        return this.ownerProperty;
    }
}

