/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.model;

import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.IndexedPropertyConstants;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.Property;
import java.beans.BeanDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class ArrayProperty
extends Property
implements IndexedPropertyConstants {
    private static final int MAX_SAFE_ELEMENT = 100;
    protected Object array = null;
    protected Vector<Property> itemProperties = null;
    protected boolean itemPropertiesInitialized;
    private Class<?> itemClass;
    protected BeanDescriptor itemInfo;
    private boolean onlyIndexedGetter;
    protected Object itemPrototype;
    protected ComponentFactory.Policy policy;

    public ComponentFactory.Policy getPolicy() {
        return this.policy;
    }

    protected ArrayProperty(Property parent, Object theOwner, PropertyDescriptor theDescriptor, ComponentFactory.Policy policy) {
        super(parent, theOwner, theDescriptor);
        this.policy = policy;
        try {
            this.itemClass = this.descriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)this.descriptor).getIndexedPropertyType() : ((PropertyDescriptor)this.descriptor).getPropertyType().getComponentType();
            this.itemInfo = Introspector.getBeanInfo(this.itemClass).getBeanDescriptor();
            this.onlyIndexedGetter = false;
            if (!(theOwner instanceof DynamicPropertySet)) {
                Class<?> retType;
                Method readMethod = ((PropertyDescriptor)this.descriptor).getReadMethod();
                boolean bl = this.onlyIndexedGetter = readMethod == null;
                if (!this.onlyIndexedGetter && !(retType = readMethod.getReturnType()).isArray()) {
                    this.onlyIndexedGetter = true;
                }
            }
            this.itemPropertiesInitialized = false;
        }
        catch (Exception e) {
            Logger.getLogger().error("Array property init error: " + e + "\r\n\t name   = " + this.descriptor.getDisplayName() + "\r\n\t owner   = " + this.owner + "\r\n\t parent  = " + parent, e);
        }
    }

    private void init() {
        if (this.itemProperties == null) {
            this.itemProperties = new Vector();
        }
        try {
            this.itemProperties.clear();
            if (!this.onlyIndexedGetter) {
                int size;
                this.array = this.getValue();
                if (this.array == null) {
                    this.array = Array.newInstance(this.itemClass, 0);
                }
                if ((size = Array.getLength(this.array)) > 100) {
                    this.addPropertyForIndex(0);
                    this.addPropertyForIndex(size - 1);
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.addPropertyForIndex(i);
                    }
                }
            } else {
                Object val;
                this.array = Array.newInstance(this.itemClass, 100);
                for (int i = 0; i < 100 && (val = this.getIndexedValue(i)) != null; ++i) {
                    Array.set(this.array, i, val);
                    this.addPropertyForIndex(i);
                }
                Object newArray = Array.newInstance(this.itemClass, this.itemProperties.size());
                System.arraycopy(this.array, 0, newArray, 0, Array.getLength(newArray));
                this.array = newArray;
            }
        }
        catch (Exception e) {
            Logger.getLogger().error("Exception in ArrayProperty.init(): " + this.getCompleteName() + ", " + e + ", --- " + this.array + ", onlyIndexedGetter = " + this.onlyIndexedGetter, e);
        }
        this.itemPropertiesInitialized = true;
    }

    private void addPropertyForIndex(int index) throws Exception {
        Property p;
        Class<?> type = this.itemClass;
        Value owner = new Value(this, index);
        ValuePropertyDescriptor pd = new ValuePropertyDescriptor(this, index);
        Class<?> realType = ComponentFactory.derivePropertyType(owner, pd);
        if (!realType.equals(type)) {
            BeanDescriptor newItemInfo = Introspector.getBeanInfo(realType).getBeanDescriptor();
            pd = new ValuePropertyDescriptor(newItemInfo, this, index);
            type = realType;
        }
        if ((p = ComponentFactory.createProperty(type, owner, pd, this, this.policy)) != null) {
            this.itemProperties.addElement(p);
        }
    }

    @Override
    public void setValue(Object value) throws NoSuchMethodException {
        if (!this.onlyIndexedGetter) {
            super.setValue(value);
        }
        this.init();
    }

    @Override
    public Object getValue() {
        if (this.onlyIndexedGetter) {
            return this.array;
        }
        return super.getValue();
    }

    public Object getIndexedValue(int index) {
        Method method = null;
        try {
            method = ((IndexedPropertyDescriptor)this.descriptor).getIndexedReadMethod();
            if (method == null) {
                return null;
            }
            Object value = method.invoke(this.getOwner(), index);
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isResizable() {
        return this.booleanFeature("array: can insert") && this.booleanFeature("array: can delete");
    }

    protected Property addItem() {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        try {
            int index = Array.getLength(this.array);
            this.insertItem(index, null);
            return this.getPropertyAt(index);
        }
        catch (Exception e) {
            Logger.getLogger().error("ArrayProperty.addItem: " + e, e);
            return null;
        }
    }

    protected Property provideItem(int index) {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        for (int i = this.itemProperties.size(); i <= index; ++i) {
            if (this.addItem() != null) continue;
            return null;
        }
        return this.getPropertyAt(index);
    }

    public void insertItem(int index, Object item) throws InstantiationException, IllegalAccessException {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        if (index < 0 || index > Array.getLength(this.array)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int size = Array.getLength(this.array) + 1;
        Object value = Array.newInstance(this.itemClass, size);
        if (item == null) {
            item = this.getDefaultItem();
        }
        int i = 0;
        int ii = 0;
        while (i < size) {
            if (i != index) {
                Array.set(value, i, Array.get(this.array, ii));
            } else {
                Array.set(value, i, item);
                --ii;
            }
            ++i;
            ++ii;
        }
        try {
            this.setValue(value);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private Object getDefaultItem() throws InstantiationException, IllegalAccessException {
        Object item = ArrayProperty.getDefaultPrimitiveInstance(this.itemClass);
        if (item != null) {
            return item;
        }
        if (this.itemPrototype != null) {
            try {
                return this.itemPrototype.getClass().getMethod("clone", new Class[0]).invoke(this.itemPrototype, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.itemClass.newInstance();
    }

    public void removeItem(int index) {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        if (index < 0 || index > Array.getLength(this.array) - 1) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int size = Array.getLength(this.array);
        Object value = Array.newInstance(this.itemClass, size - 1);
        int del = 0;
        int i = 0;
        while (i < size) {
            if (i == index) {
                --del;
            } else {
                Array.set(value, del, Array.get(this.array, i));
            }
            ++i;
            ++del;
        }
        this.itemProperties.removeElement(this.itemProperties.lastElement());
        try {
            this.setValue(value);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void moveDown(int index) {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        if (index >= 0 && index < Array.getLength(this.array) - 1) {
            Object up = Array.get(this.array, index + 1);
            Array.set(this.array, index + 1, Array.get(this.array, index));
            Array.set(this.array, index, up);
            try {
                super.setValue(this.array);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.firePropertyChange(new PropertyChangeEvent(this.getOwner(), this.getPropertyAt(index).getName(), null, null));
        this.firePropertyChange(new PropertyChangeEvent(this.getOwner(), this.getPropertyAt(index + 1).getName(), null, null));
    }

    @Override
    public int getPropertyCount() {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        return this.itemProperties == null ? 0 : this.itemProperties.size();
    }

    @Override
    public Property getPropertyAt(int i) {
        if (!this.itemPropertiesInitialized) {
            this.init();
        }
        try {
            return this.itemProperties.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.init();
        super.propertyChange(evt);
    }

    public static Object getDefaultPrimitiveInstance(Class<?> paramType) {
        Object object = null;
        String type = paramType.getName();
        if (type.equals("java.lang.String")) {
            object = "";
        } else if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            object = Boolean.FALSE;
        } else if (type.equals("java.lang.Byte") || type.equals("byte")) {
            object = (byte)0;
        } else if (type.equals("java.lang.Character") || type.equals("char")) {
            object = Character.valueOf('\u0000');
        } else if (type.equals("java.lang.Double") || type.equals("double")) {
            object = 0.0;
        } else if (type.equals("java.lang.Float") || type.equals("float")) {
            object = Float.valueOf(0.0f);
        } else if (type.equals("java.lang.Long") || type.equals("long")) {
            object = 0L;
        } else if (type.equals("java.lang.Short") || type.equals("short")) {
            object = (short)0;
        } else if (type.equals("java.lang.Integer") || type.equals("int")) {
            object = 0;
        }
        return object;
    }

    public boolean isOnlyIndexedGetter() {
        return this.onlyIndexedGetter;
    }

    public void setOnlyIndexedGetter(boolean onlyIndexedGetter) {
        this.onlyIndexedGetter = onlyIndexedGetter;
    }

    @Override
    public Class<?> getValueClass() {
        if (this.array == null) {
            return Array.newInstance(this.itemClass, 0).getClass();
        }
        return this.array.getClass();
    }

    public Class<?> getItemClass() {
        return this.itemClass;
    }

    public void setItemPrototype(Object itemPrototype) {
        this.itemPrototype = itemPrototype;
    }

    private static class ValuePropertyDescriptor
    extends PropertyDescriptor {
        private final ArrayProperty owner;
        private static Value classRetriever = new Value(null, 0);

        public ValuePropertyDescriptor(ArrayProperty owner, int index) throws IntrospectionException {
            this(owner.itemInfo, owner, index);
        }

        public ValuePropertyDescriptor(BeanDescriptor itemInfo, ArrayProperty owner, int index) throws IntrospectionException {
            super("[" + index + "]", classRetriever.getClass(), "getValue", "setValue");
            this.owner = owner;
            this.setExpert(itemInfo.isExpert());
            this.setHidden(itemInfo.isHidden());
            this.setPreferred(itemInfo.isPreferred());
            this.setShortDescription(itemInfo.getShortDescription());
            super.setValue("childIndex", index);
            Enumeration<String> e = itemInfo.attributeNames();
            while (e.hasMoreElements()) {
                String atr = e.nextElement();
                super.setValue(atr, itemInfo.getValue(atr));
            }
        }

        @Override
        public Class<?> getPropertyType() {
            return this.owner.itemClass;
        }
    }

    private static class Value {
        int index;
        ArrayProperty owner;

        public Value(ArrayProperty owner, int index) {
            this.owner = owner;
            this.index = index;
        }

        public Object getValue() {
            int size = Array.getLength(this.owner.array);
            if (this.index < size) {
                return Array.get(this.owner.array, this.index);
            }
            throw new ArrayIndexOutOfBoundsException(this.index);
        }

        public void setValue(Object value) {
            Array.set(this.owner.array, this.index, value);
        }
    }
}

