/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.log;

import com.developmentontheedge.beans.log.BeanLogger;
import com.developmentontheedge.beans.log.NullLogger;
import java.util.concurrent.Callable;

public class Logger {
    private static BeanLogger defLogger = new NullLogger();
    private static ThreadLocal<BeanLogger> log = ThreadLocal.withInitial(() -> defLogger);

    public static BeanLogger getLogger() {
        return log.get();
    }

    public static void setGlobalLogger(BeanLogger logger) {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new RuntimePermission("com.developmentontheedge.beans.setup"));
        }
        defLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V withLogger(BeanLogger logger, Callable<V> fn) throws Exception {
        BeanLogger oldLogger = log.get();
        log.set(logger);
        try {
            V v = fn.call();
            return v;
        }
        finally {
            log.set(oldLogger);
        }
    }
}

