/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextButtonEditor
extends CustomEditorSupport {
    protected JPanel editor;
    protected JTextField textField = new JTextField();
    protected JButton button;

    public TextButtonEditor() {
        this.editor = new JPanel(new BorderLayout());
        this.button = this.createButton();
        this.editor.add((Component)this.textField, "Center");
        this.editor.add((Component)this.button, "East");
        this.textField.addActionListener(this);
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextButtonEditor.this.firePropertyChange();
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextButtonEditor.this.buttonPressed();
            }
        });
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getButton() {
        return this.button;
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    protected JButton createButton() {
        return new JButton("...");
    }

    protected void buttonPressed() {
    }

    @Override
    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        return this.editor;
    }

    @Override
    public Component getCustomEditor() {
        return this.editor;
    }

    @Override
    public Object getValue() {
        return this.textField.getText();
    }

    @Override
    public void setValue(Object value) {
        this.textField.setText(value.toString());
        super.setValue(value);
    }
}

