/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.log.Logger;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;

public class TagEditorSupport
extends PropertyEditorSupport {
    protected String[] values;
    protected int startValue;

    protected TagEditorSupport() {
    }

    public TagEditorSupport(String[] values, int startValue) {
        this.values = values;
        this.startValue = startValue;
    }

    protected TagEditorSupport(String messageBundle, String key, int startValue) {
        this(messageBundle, TagEditorSupport.class, key, startValue);
    }

    public TagEditorSupport(String messageBundle, Class c, String key, int startValue) {
        try {
            this.startValue = startValue;
            ResourceBundle resources = ResourceBundle.getBundle(messageBundle, Locale.getDefault(), c.getClassLoader());
            this.values = resources.getStringArray(key);
        }
        catch (Exception e) {
            Logger.getLogger().error(this.getClass().getName(), e);
        }
    }

    @Override
    public String getAsText() {
        Integer integer = (Integer)this.getValue();
        if (integer == null) {
            return "0";
        }
        int index = integer - this.startValue;
        return this.values[index];
    }

    @Override
    public void setAsText(String text) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(text)) continue;
            this.setValue(i + this.startValue);
            return;
        }
    }

    @Override
    public String[] getTags() {
        return this.values;
    }
}

