/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GenericMultiSelectEditor
extends CustomEditorSupport {
    private JButton button = null;
    private MultiSelectPopup popup;

    private Component createComponent(Component parent, boolean isSelected) {
        this.button = new JButton("");
        this.button.setHorizontalAlignment(2);
        this.popup = new MultiSelectPopup(this.button);
        GenericMultiSelectItem value = this.getValueItem();
        if (value == null) {
            return this.button;
        }
        String key = value.getKey();
        Object[] vals = value.getAvailableValues();
        if (vals == null) {
            return this.button;
        }
        this.popup.getList().setListData((Object[])vals);
        this.popup.getList().setSelectedIndices(value.getIndexes());
        this.updateButtonText();
        this.popup.getList().addListSelectionListener(event -> this.doSet(key));
        return this.button;
    }

    protected String getText(List<Object> vals) {
        StringBuffer result = new StringBuffer();
        if (vals.isEmpty()) {
            return "(no selection)";
        }
        if (vals.size() > 1) {
            result.append("[" + String.valueOf(vals.size()) + "] ");
        }
        for (int i = 0; i < vals.size(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(vals.get(i).toString());
            if (result.length() > 100) break;
        }
        return result.toString();
    }

    private void updateButtonText() {
        this.button.setText(this.getText(this.popup.getList().getSelectedValuesList()));
    }

    private void doSet(String key) {
        this.setValue(new GenericMultiSelectItem(key, this.popup.getList().getSelectedValuesList().toArray(), this.getValueItem().getAvailableValues()).getValues());
        this.updateButtonText();
    }

    public void setStringValue(String[] val) {
        GenericMultiSelectItem value = this.getValueItem();
        this.setValue(new GenericMultiSelectItem(value.getKey(), val, value.getAvailableValues()).getValues());
    }

    protected Object[] getAvailableValues() {
        return null;
    }

    private GenericMultiSelectItem getValueItem() {
        Object[] valueObj = this.getValue();
        if (valueObj == null) {
            valueObj = new Object[]{};
        }
        GenericMultiSelectItem value = null;
        if (valueObj instanceof Object[]) {
            Object[] availVals;
            Object[] valuesArray = valueObj;
            String key = (String)this.getDescriptor().getValue("key");
            if (key == null) {
                key = "";
            }
            if ((availVals = this.getAvailableValues()) == null) {
                throw new IllegalStateException("No vals");
            }
            value = new GenericMultiSelectItem(key, valuesArray, availVals);
        }
        return value;
    }

    @Override
    public String[] getTags() {
        GenericMultiSelectItem value = this.getValueItem();
        if (value != null) {
            return (String[])Stream.of(value.getAvailableValues()).map(Object::toString).toArray(String[]::new);
        }
        return null;
    }

    @Override
    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        return this.createComponent(parent, isSelected);
    }

    @Override
    public Component getCustomEditor(Component parent, boolean isSelected) {
        return this.createComponent(parent, isSelected);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setStringValue(new String[]{text});
    }

    private static class GenericMultiSelectItem {
        private String key = null;
        private Object[] availableValues;
        private Object[] values;
        private int[] indexes;

        protected GenericMultiSelectItem(String key, Object[] values, Object[] availableValues) {
            this.availableValues = availableValues;
            if (availableValues == null) {
                return;
            }
            this.key = key;
            if (values == null) {
                return;
            }
            this.selectValues(values);
        }

        protected String getKey() {
            return this.key;
        }

        protected int[] getIndexes() {
            return this.indexes;
        }

        public Object[] getAvailableValues() {
            return this.availableValues;
        }

        public Object[] getValues() {
            if (this.availableValues == null) {
                return new Object[0];
            }
            return this.values;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof GenericMultiSelectItem)) {
                return false;
            }
            GenericMultiSelectItem item = (GenericMultiSelectItem)o;
            if (this.key == null && item.key != null || this.key != null && !this.key.equals(item.key)) {
                return false;
            }
            if (!Arrays.equals(this.indexes, item.indexes)) {
                return false;
            }
            return Arrays.equals(this.availableValues, item.availableValues);
        }

        private void selectValues(Object[] values) {
            int i;
            if (this.availableValues == null) {
                return;
            }
            HashMap<String, Integer> valToIdx = new HashMap<String, Integer>();
            for (i = 0; i < this.availableValues.length; ++i) {
                valToIdx.put(this.availableValues[i].toString(), i);
            }
            this.indexes = Stream.of(values).map(val -> (Integer)valToIdx.get(val.toString())).filter(Objects::nonNull).mapToInt(Integer::intValue).toArray();
            this.values = (Object[])Array.newInstance(this.availableValues.getClass().getComponentType(), this.indexes.length);
            for (i = 0; i < this.indexes.length; ++i) {
                this.values[i] = this.availableValues[this.indexes[i]];
            }
        }
    }

    private static class MultiSelectPopup
    extends JPopupMenu {
        private JList<Object> listBox;
        private JScrollPane scrollPane;
        private Insets insets;
        private JButton button;
        private static long deactivationTime = 0L;

        public MultiSelectPopup(JButton button) {
            this.button = button;
            this.listBox = new JList();
            this.listBox.setBackground(SystemColor.control);
            this.listBox.setVisibleRowCount(20);
            this.scrollPane = new JScrollPane(this.listBox);
            this.scrollPane.setBorder(null);
            this.scrollPane.setFocusable(false);
            this.scrollPane.getVerticalScrollBar().setFocusable(false);
            this.setOpaque(false);
            this.add(this.scrollPane);
            this.setFocusable(false);
            this.setBorder(new BevelBorder(1));
            this.insets = this.getBorder().getBorderInsets(this);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                    deactivationTime = System.currentTimeMillis();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent arg0) {
                }
            });
            button.addActionListener(ae -> {
                if (this.isVisible() || System.currentTimeMillis() - deactivationTime < 200L) {
                    return;
                }
                this.show();
            });
        }

        public JList<Object> getList() {
            return this.listBox;
        }

        @Override
        public void show() {
            if (this.listBox.getPreferredSize() == null || System.currentTimeMillis() - deactivationTime < 200L) {
                return;
            }
            this.setPreferredSize(new Dimension(this.button.getWidth(), Math.min(this.listBox.getPreferredScrollableViewportSize().height, this.listBox.getPreferredSize().height) + this.insets.top + this.insets.bottom));
            this.show(this.button, 0, this.button.getHeight());
            this.listBox.requestFocus();
        }

        @Override
        public void hide() {
            this.setVisible(false);
        }
    }
}

