/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.Component;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class GenericComboBoxEditor
extends CustomEditorSupport {
    private JComboBox<String> comboBox = new JComboBox();

    private Component createComponent(Component parent, boolean isSelected) {
        this.comboBox = new JComboBox();
        GenericComboBoxItem value = this.getValueItem();
        if (value == null) {
            return this.comboBox;
        }
        String[] vals = this.getTags();
        if (vals == null) {
            return this.comboBox;
        }
        for (String str : vals) {
            this.comboBox.addItem(str);
        }
        this.comboBox.setSelectedItem(value.toString());
        String key = value.getKey();
        this.comboBox.addActionListener(ae -> this.doSet(key));
        return this.comboBox;
    }

    private GenericComboBoxItem getValueItem() {
        Object valueObj = this.getValue();
        if (valueObj == null) {
            return null;
        }
        Object valueStr = valueObj;
        String key = (String)this.getDescriptor().getValue("key");
        if (key == null) {
            key = "";
        }
        Object[] availVals = this.getAvailableValues();
        GenericComboBoxItem value = null;
        if (availVals == null) {
            Object[] tagList = (Object[])this.getDescriptor().getValue("tagList");
            if (tagList == null) {
                throw new IllegalStateException("TagList is null");
            }
            value = new GenericComboBoxItem(key, valueStr, tagList);
        } else {
            value = new GenericComboBoxItem(key, valueStr, availVals);
        }
        return value;
    }

    @Override
    public void setAsText(String newValue) throws IllegalArgumentException {
        Object[] availableValues;
        GenericComboBoxItem newValueItem = null;
        GenericComboBoxItem valueItem = this.getValueItem();
        for (Object value : availableValues = valueItem == null ? this.getAvailableValues() : valueItem.getAvailableValues()) {
            if (!value.toString().equals(newValue)) continue;
            newValueItem = new GenericComboBoxItem(valueItem == null ? null : valueItem.getKey(), newValue, availableValues);
        }
        if (newValueItem != null) {
            this.setValue(newValueItem.getValue());
        }
    }

    @Override
    public String[] getTags() {
        Object[] vals = null;
        GenericComboBoxItem value = this.getValueItem();
        if (value != null) {
            if (value.getAvailableValues() != null) {
                this.getDescriptor().setValue("tagList", value.getAvailableValues());
            }
            vals = value.getAvailableValues();
        } else {
            vals = this.getAvailableValues();
        }
        if (vals == null) {
            return null;
        }
        return (String[])Stream.of(vals).map(Object::toString).toArray(String[]::new);
    }

    protected Object[] getAvailableValues() {
        return null;
    }

    private void doSet(String key) {
        this.setValue(new GenericComboBoxItem(key, this.comboBox.getSelectedItem().toString(), this.getValueItem().getAvailableValues()).getValue());
    }

    @Override
    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        GenericComboBoxItem item = this.getValueItem();
        JLabel label = new JLabel(item == null ? "" : item.toString());
        return label;
    }

    @Override
    public Component getCustomEditor(Component parent, boolean isSelected) {
        return this.createComponent(parent, isSelected);
    }

    static class GenericComboBoxItem {
        private String key = null;
        private int index = 0;
        private Object value = "";
        private Object[] availableValues;

        protected GenericComboBoxItem(String key, Object value, Object[] availableValues) {
            this.availableValues = availableValues;
            this.key = key;
            if (availableValues == null || availableValues.length == 0) {
                return;
            }
            if (value != null) {
                for (int i = 0; i < availableValues.length; ++i) {
                    if (!availableValues[i].toString().equals(value.toString())) continue;
                    this.value = availableValues[i];
                    this.index = i;
                    return;
                }
            }
            this.value = availableValues[0];
        }

        protected String getKey() {
            return this.key;
        }

        protected int getIndex() {
            return this.index;
        }

        public Object[] getAvailableValues() {
            return this.availableValues;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue().toString();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof GenericComboBoxItem)) {
                return false;
            }
            GenericComboBoxItem item = (GenericComboBoxItem)o;
            if (item.index != this.index) {
                return false;
            }
            if (this.value == null && item.value != null || this.value != null && !this.value.equals(item.value)) {
                return false;
            }
            return (this.key != null || item.key == null) && (this.key == null || this.key.equals(item.key));
        }
    }
}

