/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.CustomEditorSupport;
import com.developmentontheedge.beans.editors.FontChooser;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class FontEditor
extends CustomEditorSupport {
    JLabel label;

    @Override
    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        if (this.label == null) {
            this.label = this.createLabel();
        }
        FontEditor.setColor(this.label, isSelected, parent);
        return this.label;
    }

    @Override
    public Component getCustomEditor(Component parent, boolean isSelected) {
        this.label = this.createLabel();
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!FontEditor.this.label.isEnabled()) {
                    return;
                }
                Font font = FontChooser.showDialog(null, null, (Font)(FontEditor.this.getValue() != null ? FontEditor.this.getValue() : FontEditor.getDefaultFont()));
                FontEditor.this.setValue(font);
                JLabel source = (JLabel)e.getSource();
                source.setFont(font);
                source.setText(font.getFamily() + ", " + font.getSize());
            }
        });
        return this.label;
    }

    private static Font getDefaultFont() {
        return new Font(null, 0, 12);
    }

    private JLabel createLabel() {
        Font font = (Font)this.getValue();
        if (font == null) {
            font = FontEditor.getDefaultFont();
        }
        String info = font.getFamily() + ", " + font.getSize();
        JLabel label = new JLabel(info, 0);
        label.setOpaque(true);
        label.setFont(font);
        return label;
    }

    @Override
    protected Object processValue() {
        Font value = (Font)this.getValue();
        if (this.label == null) {
            value = new Font("Courier", 1, 14);
        }
        return value;
    }
}

