/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.FontChooserDialog;
import com.developmentontheedge.beans.editors.FontTracker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JComponent {
    protected SamplePanel samplePanel = new SamplePanel();
    protected JList<String> fontsList;
    protected JList<String> stylesList;
    protected JList<String> sizesList;
    protected Map<String, Integer> styles;
    protected static String samlpeText = "Sample text";
    protected static String[] styleNames = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};

    public FontChooser() {
        this(UIManager.getFont("Menu.font"));
    }

    public FontChooser(Font font) {
        JPanel main = new JPanel();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.fontsList = new JList<String>(fontNames);
        this.fontsList.setSelectionMode(0);
        this.fontsList.addListSelectionListener(new FontChangeListener());
        JPanel fontPanel = new JPanel(new BorderLayout());
        fontPanel.add((Component)new JLabel("Font:                                                                 ", 2), "North");
        fontPanel.add((Component)new JScrollPane(this.fontsList), "Center");
        this.styles = new Hashtable<String, Integer>();
        this.styles.put(styleNames[0], 0);
        this.styles.put(styleNames[1], 1);
        this.styles.put(styleNames[2], 2);
        this.styles.put(styleNames[3], 3);
        this.stylesList = new JList<String>(styleNames);
        this.stylesList.setSelectionMode(0);
        this.stylesList.addListSelectionListener(new StyleChangeListener());
        JPanel stylePanel = new JPanel(new BorderLayout());
        stylePanel.add((Component)new JLabel("Style:                     ", 2), "North");
        stylePanel.add((Component)new JScrollPane(this.stylesList), "Center");
        Vector<String> sizes = this.getSizes();
        String size = String.valueOf(font.getSize());
        if (!sizes.contains(size)) {
            sizes.add(size);
        }
        this.sizesList = new JList<String>(sizes);
        this.sizesList.setSelectionMode(0);
        this.sizesList.addListSelectionListener(new SizeChangeListener());
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.add((Component)new JLabel("Size:          ", 2), "North");
        sizePanel.add((Component)new JScrollPane(this.sizesList), "Center");
        main.add(fontPanel);
        main.add(stylePanel);
        main.add(sizePanel);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)main, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createBevelBorder(1));
        centerPanel.add((Component)this.samplePanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
        this.fontsList.setSelectedValue(font.getFamily(), true);
        this.sizesList.setSelectedValue(size, true);
        switch (font.getStyle()) {
            case 0: {
                this.stylesList.setSelectedValue(styleNames[0], true);
                break;
            }
            case 1: {
                this.stylesList.setSelectedValue(styleNames[1], true);
                break;
            }
            case 2: {
                this.stylesList.setSelectedValue(styleNames[2], true);
                break;
            }
            case 3: {
                this.stylesList.setSelectedValue(styleNames[3], true);
            }
        }
    }

    @Override
    public Font getFont() {
        String name = this.fontsList.getSelectedValue();
        int style = this.styles.get(this.stylesList.getSelectedValue());
        int size = Integer.parseInt(this.sizesList.getSelectedValue());
        return new Font(name, style, size);
    }

    public static Font showDialog(Component parent, String title, Font font) {
        if (title == null) {
            title = "Select Font";
        }
        FontChooser chooserPane = new FontChooser(font);
        FontTracker fontTracker = new FontTracker(chooserPane);
        FontChooserDialog dialog = new FontChooserDialog(parent, title, true, chooserPane, fontTracker, null);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Window w = e.getWindow();
                w.setVisible(false);
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Window w = (Window)e.getComponent();
                w.dispose();
            }
        });
        Dimension screenSize = dialog.getToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - dialog.getSize().width) / 2, (screenSize.height - dialog.getSize().height) / 2);
        dialog.pack();
        dialog.setVisible(true);
        return fontTracker.getFont() == null ? font : fontTracker.getFont();
    }

    private Vector<String> getSizes() {
        int i;
        Vector<String> sizes = new Vector<String>();
        for (i = 0; i < 13; ++i) {
            sizes.add(String.valueOf(i));
        }
        for (i = 14; i < 29; i += 2) {
            sizes.add(String.valueOf(i));
        }
        sizes.add("36");
        sizes.add("48");
        sizes.add("72");
        return sizes;
    }

    class SamplePanel
    extends JComponent {
        private static final long serialVersionUID = 1L;

        SamplePanel() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHints(hints);
            g2.setFont(FontChooser.this.getFont());
            FontMetrics fm = g2.getFontMetrics();
            Rectangle rect = this.getVisibleRect();
            double x = rect.getCenterX() - (double)fm.stringWidth(samlpeText) / 2.0;
            double y = rect.getCenterY() + (double)fm.getHeight() / 3.0;
            g2.drawString(samlpeText, (int)x, (int)y);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(300, 100);
        }
    }

    class SizeChangeListener
    implements ListSelectionListener {
        SizeChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontChooser.this.samplePanel.repaint();
        }
    }

    class StyleChangeListener
    implements ListSelectionListener {
        StyleChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontChooser.this.samplePanel.repaint();
        }
    }

    class FontChangeListener
    implements ListSelectionListener {
        FontChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontChooser.this.samplePanel.repaint();
        }
    }
}

