/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DimensionEditor
extends CustomEditorSupport {
    private final JPanel panel = new JPanel(new GridLayout(1, 2));
    private final JTextField width = new JTextField();
    private final JTextField height = new JTextField();

    public DimensionEditor() {
        this.width.setOpaque(false);
        this.panel.add(this.width);
        this.height.setOpaque(false);
        this.panel.add(this.height);
        this.width.setNextFocusableComponent(this.height);
        DimensionEditor.setColor(this.width, true, null);
        DimensionEditor.setColor(this.height, true, null);
        DimensionEditor.setColor(this.panel, true, null);
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }

    @Override
    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        Dimension dim = (Dimension)this.getValue();
        if (dim == null) {
            dim = new Dimension(0, 0);
        }
        JPanel panel = new JPanel(new GridLayout(1, 2));
        JLabel width = new JLabel("" + dim.getWidth());
        width.setOpaque(false);
        panel.add(width);
        JLabel height = new JLabel("" + dim.getHeight());
        height.setOpaque(false);
        panel.add(height);
        DimensionEditor.setColor(panel, isSelected, parent);
        return panel;
    }

    @Override
    protected Object processValue() {
        if (this.width == null || this.height == null) {
            return null;
        }
        return new Dimension(Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
    }
}

