/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import com.developmentontheedge.beans.editors.PropertyEditorEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;

public class CustomEditorSupport
extends PropertyEditorSupport
implements PropertyEditorEx,
ActionListener {
    protected Object bean;
    protected FeatureDescriptor descriptor;

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor(Component parent, boolean isSelected) {
        return this.getCustomEditor();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.firePropertyChange();
    }

    protected Object processValue() {
        this.firePropertyChange();
        return this.getValue();
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public FeatureDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(FeatureDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static void setColor(JComponent component, boolean isSelected, Component parent) {
        Color background = null;
        Color foreground = null;
        component.setOpaque(true);
        if (parent instanceof JTable) {
            if (isSelected) {
                background = ((JTable)parent).getSelectionBackground();
                foreground = ((JTable)parent).getSelectionForeground();
            } else {
                background = ((JTable)parent).getBackground();
                foreground = ((JTable)parent).getForeground();
            }
        } else if (parent instanceof JComponent) {
            String PREFIX = "javax.swing.J";
            Class<?> parentClass = parent.getClass();
            String className = parentClass.getName();
            while (!parentClass.equals(Object.class) && !className.startsWith("javax.swing.J")) {
                parentClass = parentClass.getSuperclass();
                className = parentClass.getName();
            }
            if (className.startsWith("javax.swing.J")) {
                String colorKey = className.substring("javax.swing.J".length());
                if (isSelected) {
                    background = UIManager.getColor(colorKey + ".selectionBackground");
                    foreground = UIManager.getColor(colorKey + ".selectionForeground");
                }
                if (background == null) {
                    background = UIManager.getColor(colorKey + ".background");
                }
                if (foreground == null) {
                    foreground = UIManager.getColor(colorKey + ".foreground");
                }
            }
        }
        if (background != null) {
            component.setBackground(background);
        }
        if (foreground != null) {
            component.setForeground(foreground);
        }
    }
}

