/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ColorComboBox
extends JComboBox<Color> {
    private static final long serialVersionUID = 1L;
    private Color bColor;
    private Color fColor;
    private Color curColor;
    private String curText;
    public static final String CUSTOM_TEXT = "more colors...";
    private static final int MAX_HIGHT = 15;
    private static final int REN_WIDTH = 30;
    private DefaultComboBoxModel<Color> model = new DefaultComboBoxModel();
    Vector<PropertyChangeListener> listeners;
    private static Font f = new Font("Arial", 0, 11);

    public ColorComboBox() {
        this((Color)null);
    }

    public ColorComboBox(Color current) {
        if (current != null) {
            if (!(current instanceof NamedColor)) {
                current = new NamedColor(current, "current");
            }
            this.model.addElement(current);
        }
        this.model.addElement(new NamedColor(Color.gray, "gray"));
        this.model.addElement(new NamedColor(Color.red, "red"));
        this.model.addElement(new NamedColor(Color.blue, "blue"));
        this.model.addElement(new NamedColor(Color.green, "green"));
        this.model.addElement(new NamedColor(Color.yellow, "yellow"));
        this.model.addElement(new NamedColor(Color.white, "white"));
        this.model.addElement(new NamedColor(Color.black, "black"));
        this.model.addElement(new NamedColor(Color.cyan, "cyan"));
        this.model.addElement(new NamedColor(Color.magenta, "magenta"));
        this.model.addElement(new NamedColor(Color.pink, "pink"));
        this.model.addElement(new NamedColor(Color.orange, "orange"));
        this.model.addElement(new NamedColor(Color.white, CUSTOM_TEXT, false));
        this.setModel(this.model);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedColor color = (NamedColor)ColorComboBox.this.getSelectedItem();
                Color oldValue = ColorComboBox.this.curColor;
                Color newValue = null;
                if (!color.name.equals(ColorComboBox.CUSTOM_TEXT)) {
                    newValue = color;
                } else {
                    newValue = JColorChooser.showDialog(null, "Choose color", oldValue);
                    if (newValue != null) {
                        oldValue = color;
                        newValue = new NamedColor(newValue, ColorComboBox.CUSTOM_TEXT);
                        ColorComboBox.this.model.removeElement(oldValue);
                        ColorComboBox.this.model.addElement(newValue);
                        ColorComboBox.this.model.setSelectedItem(newValue);
                    }
                }
                if (newValue != null) {
                    ColorComboBox.this.fireColorValueChanged(oldValue, newValue);
                    ColorComboBox.this.curColor = newValue;
                }
            }
        });
        this.installAncestorListener();
        this.setOpaque(true);
        this.updateUI();
        this.setSelectedIndex(0);
        this.setRenderer(new ComboBoxRenderer());
        this.setMaximumRowCount(7);
    }

    public void addColorPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    protected void fireColorValueChanged(Object oldValue, Object newValue) {
        if (this.listeners == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "Color", oldValue, newValue);
        for (int i = 0; i < this.listeners.size(); ++i) {
            PropertyChangeListener l = this.listeners.get(i);
            l.propertyChange(evt);
        }
    }

    public static ColorComboBox getInstance(Color color) {
        return new ColorComboBox(color);
    }

    public static Component getValueRenderer(final Color color) {
        return new Component(){

            @Override
            public void paint(Graphics g) {
                g.setColor(color);
                g.fillRect(9, 5, 30, 8);
                g.setColor(Color.black);
                g.drawRect(9, 5, 30, 8);
                String text = ColorComboBox.getText(color);
                if (text == null) {
                    text = "custom";
                }
                g.setFont(f);
                g.setColor(Color.black);
                g.drawString(text, 50, 12);
            }
        };
    }

    public static String getText(Color color) {
        if (color == null) {
            return null;
        }
        if (color instanceof NamedColor) {
            return ((NamedColor)color).name;
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.gray)) {
            return "gray";
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.blue)) {
            return "blue";
        }
        if (color.equals(Color.green)) {
            return "green";
        }
        if (color.equals(Color.yellow)) {
            return "yellow";
        }
        if (color.equals(Color.white)) {
            return "white";
        }
        if (color.equals(Color.black)) {
            return "black";
        }
        if (color.equals(Color.cyan)) {
            return "cyan";
        }
        if (color.equals(Color.magenta)) {
            return "magenta";
        }
        if (color.equals(Color.pink)) {
            return "pink";
        }
        if (color.equals(Color.orange)) {
            return "orange";
        }
        return null;
    }

    class ComboBoxRenderer
    extends JPanel
    implements ListCellRenderer<Color> {
        private static final long serialVersionUID = 1L;
        NamedColor color;

        ComboBoxRenderer() {
        }

        @Override
        public void paint(Graphics g) {
            Dimension dim = this.getSize();
            int y = 1;
            int height = dim.height;
            y = (dim.height - 8) / 2;
            if (dim.height >= 15) {
                y = (dim.height - 8) / 2;
                dim.height = 15;
            }
            g.setColor(ColorComboBox.this.bColor);
            g.fillRect(0, 0, dim.width - 1, dim.height - 1);
            if (this.color.showColor) {
                g.setColor(this.color);
                g.fillRect(5, y, 30, 8);
                g.setColor(Color.black);
                g.drawRect(5, y, 30, 8);
            }
            g.setColor(ColorComboBox.this.fColor);
            g.setFont(f);
            if (this.color.showColor) {
                g.drawString(this.color.name, 50, y + 9);
            } else {
                g.drawString(this.color.name, 5, y + 9);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Color> list, Color value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                ColorComboBox.this.bColor = list.getSelectionBackground();
                ColorComboBox.this.fColor = list.getSelectionForeground();
            } else {
                ColorComboBox.this.bColor = list.getBackground();
                ColorComboBox.this.fColor = list.getForeground();
            }
            if (index != -1) {
                Dimension dim = new Dimension(100, 15);
                this.setSize(dim);
                this.setPreferredSize(dim);
            }
            this.color = (NamedColor)value;
            return this;
        }
    }

    public static class NamedColor
    extends Color {
        private static final long serialVersionUID = 1L;
        protected String name;
        protected boolean showColor;

        public NamedColor(Color c, String name) {
            this(c, name, true);
        }

        public NamedColor(Color c, String name, boolean showColor) {
            super(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.name = name;
            this.showColor = showColor;
        }

        public String getName() {
            return this.name;
        }

        public boolean isShowColor() {
            return this.showColor;
        }

        @Override
        public String toString() {
            return this.name + ", " + super.toString() + ", showColor=" + this.showColor;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NamedColor) {
                return this.name.equals(((NamedColor)obj).name) && super.equals(obj);
            }
            return super.equals(obj);
        }
    }
}

