/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.PropertyChangeObservable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class WeakPropertyChangeForwarder
implements PropertyChangeListener {
    private Reference<PropertyChangeListener> targetRef;
    private PropertyChangeObservable observable;

    public WeakPropertyChangeForwarder(PropertyChangeListener target, PropertyChangeObservable observable) {
        this.targetRef = new WeakReference<PropertyChangeListener>(target);
        this.observable = observable;
        observable.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeListener target = this.targetRef.get();
        if (target == null) {
            this.observable.removePropertyChangeListener(this);
        } else {
            target.propertyChange(evt);
        }
    }
}

