/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertyBuilder;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetDecorator;
import com.developmentontheedge.beans.Option;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesDPS
extends Option
implements DynamicPropertySet {
    private static final long serialVersionUID = 1L;
    private final Properties properties;
    private boolean readOnly;

    public PropertiesDPS(Properties properties) {
        this.properties = properties;
    }

    public PropertiesDPS(Properties properties, boolean readOnly) {
        this.properties = properties;
        this.readOnly = readOnly;
    }

    @Override
    public Class<?> getType(String name) {
        try {
            return this.properties.get(name).getClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getValue(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getValueAsString(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public Long getValueAsLong(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        return Long.parseLong(val.toString());
    }

    @Override
    public <T> T cast(String name, Class<T> clazz) {
        return clazz.cast(this.getValue(name));
    }

    @Override
    public void setValue(String name, Object value) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        this.properties.put(name, value);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        try {
            return this.getProperty(name).getDescriptor();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public DynamicProperty getProperty(String name) {
        try {
            Object value = this.properties.get(name);
            DynamicProperty dynamicProperty = new DynamicProperty(name, value.getClass(), value);
            dynamicProperty.setReadOnly(this.readOnly);
            return dynamicProperty;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void renameProperty(String from, String to) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        Object value = this.properties.get(from);
        this.properties.remove(from);
        this.properties.put(to, value);
    }

    @Override
    public void add(DynamicProperty property) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        this.properties.put(property.getName(), property.getValue());
    }

    @Override
    public boolean addBefore(String propName, DynamicProperty property) {
        if (!this.properties.containsKey(propName)) {
            return false;
        }
        this.add(property);
        return true;
    }

    @Override
    public boolean addAfter(String propName, DynamicProperty property) {
        if (!this.properties.containsKey(propName)) {
            return false;
        }
        this.add(property);
        return true;
    }

    @Override
    public boolean contains(DynamicProperty property) {
        return this.properties.containsKey(property.getName());
    }

    @Override
    public Object remove(String name) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        if (!this.properties.containsKey(name)) {
            return null;
        }
        return this.properties.remove(name);
    }

    @Override
    public boolean moveTo(String name, int index) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        return this.properties.containsKey(name);
    }

    @Override
    public boolean replaceWith(String name, DynamicProperty prop) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        if (!this.properties.containsKey(name)) {
            return false;
        }
        this.properties.put(name, prop.getValue());
        return true;
    }

    @Override
    public Iterator<String> nameIterator() {
        return this.properties.keySet().stream().map(Object::toString).iterator();
    }

    @Override
    public Iterator<DynamicProperty> propertyIterator() {
        return this.properties.keySet().stream().map(Object::toString).map(this::getProperty).iterator();
    }

    @Override
    public Iterator<DynamicProperty> iterator() {
        return this.propertyIterator();
    }

    @Override
    public Map<String, Object> asMap() {
        Map<Object, Object> map = this.properties;
        if (this.readOnly) {
            map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removePropertyChangeListener(listener);
    }

    @Override
    public boolean hasListeners(String propertyName) {
        return this.listenerList != null && this.listenerList.getListenerCount() > 0;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent evt) {
        super.firePropertyChange(evt);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void setPropertyAttribute(String propName, String attrName, Object attrValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DynamicPropertyBuilder getAsBuilder(String name) {
        DynamicPropertyBuilder builder = new DynamicPropertyBuilder(this.getProperty(name));
        return builder;
    }

    @Override
    public String serializeAsXml(String beanName, String offset) {
        return new DynamicPropertySetDecorator(this).serializeAsXml(beanName, offset);
    }
}

