/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.DynamicPropertySetSerializer;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Preferences
extends DynamicPropertySetAsMap {
    private static final long serialVersionUID = 1L;
    public static final String DIALOGS = "dialogs";
    protected List<DynamicProperty> propertiesList = new ArrayList<DynamicProperty>();
    protected boolean saveOrder = false;

    public Preferences() {
    }

    public Preferences(DynamicPropertySet dps) {
        for (DynamicProperty property : dps) {
            this.propertiesMap.put(property.getName(), property);
            this.propertiesList.add(property);
        }
    }

    public boolean isSaveOrder() {
        return this.saveOrder;
    }

    public void setSaveOrder(boolean saveOrder) {
        this.saveOrder = saveOrder;
    }

    public void load(String fileName) {
        new DynamicPropertySetSerializer().load((DynamicPropertySet)this, fileName);
    }

    public void load(String fileName, ClassLoader classLoader) {
        new DynamicPropertySetSerializer().load((DynamicPropertySet)this, fileName, classLoader);
    }

    public void save(String fileName) throws IOException {
        new DynamicPropertySetSerializer().save(fileName, (DynamicPropertySet)this);
    }

    public void save(OutputStream out) throws IOException {
        new DynamicPropertySetSerializer().save(out, (DynamicPropertySet)this);
    }

    @Override
    protected DynamicProperty findProperty(String name) {
        if (name.indexOf("/") == -1) {
            return (DynamicProperty)this.propertiesMap.get(name);
        }
        return this.findProperty(new StringTokenizer(name, "/"), this);
    }

    protected DynamicProperty findProperty(StringTokenizer tokens, DynamicPropertySet ancestor) {
        if (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            DynamicProperty dp = ancestor.getProperty(name);
            if (!tokens.hasMoreTokens()) {
                return dp;
            }
            if (dp != null && dp.getValue() instanceof DynamicPropertySet) {
                return this.findProperty(tokens, (DynamicPropertySet)dp.getValue());
            }
        }
        return null;
    }

    public Map<String, Object> valuesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.fillMap(map, this, null);
        return map;
    }

    protected void fillMap(Map<String, Object> map, Preferences preferences, String prefix) {
        prefix = prefix == null ? "" : prefix + "/";
        Iterator<DynamicProperty> i = preferences.propertyIterator();
        while (i.hasNext()) {
            DynamicProperty dp = i.next();
            if (dp.getValue() instanceof Preferences) {
                this.fillMap(map, (Preferences)dp.getValue(), prefix + dp.getName());
                continue;
            }
            map.put(prefix + dp.getName(), dp.getValue());
        }
    }

    public void updateValues(Map<String, ?> map) {
        for (String name : map.keySet()) {
            Object newValue;
            Object oldValue = this.getValue(name);
            if (oldValue == (newValue = map.get(name))) continue;
            this.setValue(name, newValue);
        }
    }

    public Object getValue(String name, Object defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return property.getValue();
        }
        return defaultValue;
    }

    public boolean getBooleanValue(String name, boolean defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return (Boolean)property.getValue();
        }
        return defaultValue;
    }

    public int getIntValue(String name, int defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return (Integer)property.getValue();
        }
        return defaultValue;
    }

    public long getLongValue(String name, long defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return (Long)property.getValue();
        }
        return defaultValue;
    }

    public float getFloatValue(String name, float defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return ((Float)property.getValue()).floatValue();
        }
        return defaultValue;
    }

    public double getDoubleValue(String name, double defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return (Double)property.getValue();
        }
        return defaultValue;
    }

    public String getStringValue(String name, String defaultValue) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            if (property.getValue() == null) {
                return null;
            }
            if (property.getValue() instanceof String) {
                return (String)property.getValue();
            }
            return "" + property.getValue();
        }
        return defaultValue;
    }

    public Preferences getPreferencesValue(String name) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return (Preferences)property.getValue();
        }
        return null;
    }

    public void setValue(String name, Object value, PropertyDescriptor descriptor) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            this.setValue(name, value);
        } else {
            property = new DynamicProperty(descriptor, value.getClass(), value);
            this.add(property);
        }
    }

    public void addValue(String name, Object value, String displayName, String shortDescription) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            this.setValue(name, value);
        } else {
            String[] fields = name.split("/");
            String simpleName = fields[fields.length - 1];
            Preferences preferences = this;
            for (int i = 0; i < fields.length - 1; ++i) {
                Preferences subPreferences = preferences.getPreferencesValue(fields[i]);
                if (subPreferences == null) {
                    subPreferences = new Preferences();
                    preferences.add(new DynamicProperty(fields[i], Preferences.class, (Object)subPreferences));
                }
                preferences = subPreferences;
            }
            preferences.add(new DynamicProperty(simpleName, displayName, shortDescription, value.getClass(), value));
        }
    }

    public void addValue(String name, Object value) {
        this.addValue(name, value, null, null);
    }

    @Override
    public void add(DynamicProperty property) {
        Class<Object> type = property.getType();
        if (!(type.isAssignableFrom(String.class) || type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Long.class) || type.isAssignableFrom(Float.class) || type.isAssignableFrom(Double.class) || type.isAssignableFrom(Preferences.class))) {
            throw new IllegalArgumentException("Unsupported property type " + type.getName());
        }
        this.propertiesMap.put(property.getName(), property);
        this.propertiesList.add(property);
        property.setParent(this);
    }

    @Override
    public Iterator<DynamicProperty> propertyIterator() {
        if (!this.saveOrder) {
            return this.propertiesMap.values().iterator();
        }
        return this.propertiesList.iterator();
    }

    @Override
    public Object remove(String name) {
        if (super.remove(name) != null) {
            for (int i = 0; i < this.propertiesList.size(); ++i) {
                if (!this.propertiesList.get(i).getName().equals(name)) continue;
                this.propertiesList.remove(i);
                return true;
            }
        }
        return false;
    }
}

