/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.PropertyChangeObservable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public class Option
implements Serializable,
PropertyChangeObservable {
    private static final long serialVersionUID = -1728854926703429994L;
    private transient Option parent;
    private transient String nameInParent;
    protected transient EventListenerList listenerList;
    protected transient boolean notificationEnabled = true;
    protected transient boolean propagationEnabled = true;

    public Option() {
        this(null);
    }

    public Option(Option parent) {
        this.setParent(parent);
    }

    public void setParent(Option parent) {
        this.parent = parent;
    }

    public void setParent(Option parent, String nameInParent) {
        this.parent = parent;
        this.nameInParent = nameInParent;
    }

    public Option getParent() {
        return this.parent;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    public void copyListenersTo(Option options) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listSource = this.listenerList.getListenerList();
        for (int i = 0; i < listSource.length; ++i) {
            options.addPropertyChangeListener((PropertyChangeListener)listSource[i]);
        }
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void setNotificationEnabled(boolean enabled) {
        this.notificationEnabled = enabled;
    }

    public boolean isPropagationEnabled() {
        return this.propagationEnabled;
    }

    public void setPropagationEnabled(boolean enabled) {
        this.propagationEnabled = enabled;
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (!this.notificationEnabled || evt.getOldValue() != null && evt.getNewValue() != null && evt.getOldValue().equals(evt.getNewValue())) {
            return;
        }
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PropertyChangeListener.class) continue;
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(evt);
            }
        }
        if (this.notificationEnabled && this.propagationEnabled && this.parent != null) {
            evt.setPropagationId(this);
            this.parent.firePropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.notificationEnabled) {
            this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (!this.notificationEnabled || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (!this.notificationEnabled || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (!this.notificationEnabled || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public String getNameInParent() {
        return this.nameInParent;
    }
}

