/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.AbstractDynamicPropertySet;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertyBuilder;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.log.Logger;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DynamicPropertySetSupport
extends AbstractDynamicPropertySet {
    private static final long serialVersionUID = 1L;
    protected ArrayList<DynamicProperty> properties = new ArrayList();
    protected boolean useAddIndexes;
    protected Map<String, DynamicProperty> propHash = new TreeMap<String, DynamicProperty>(String.CASE_INSENSITIVE_ORDER);
    protected Map<String, DynamicProperty> propDisplayNameHash;
    protected boolean bAddAlways = false;
    private static final String[] dictionaryWords = new String[]{"uuid", "id", "phone", "number", "background", "name", "value", "column", "description", "code", "type", "size", "begin", "end", "price", "status", "border", "borders", "rows", "link", "text", "header", "level"};

    public DynamicPropertySetSupport() {
        this(true);
    }

    public DynamicPropertySetSupport(DynamicPropertySet dps, boolean useAddIndexes) {
        this(useAddIndexes);
        dps.forEach(dp -> {
            try {
                this.add(DynamicPropertySetSupport.cloneProperty(dp));
            }
            catch (Exception wierd) {
                Logger.getLogger().error("Unable to clone property " + dp.getName() + ", message = " + wierd.getMessage());
            }
        });
    }

    public DynamicPropertySetSupport(DynamicPropertySet dps) {
        this(dps, dps instanceof DynamicPropertySetSupport && ((DynamicPropertySetSupport)dps).isUseAddIndexes());
    }

    public DynamicPropertySetSupport(Map<?, ?> map) {
        this(map, false);
    }

    public DynamicPropertySetSupport(Map<?, ?> map, boolean useAddIndexes) {
        this(useAddIndexes);
        map.entrySet().stream().forEach(e -> {
            Class valueClass;
            if (e.getKey() == null) {
                return;
            }
            Object value = e.getValue();
            Class clazz = valueClass = e.getValue() != null ? e.getValue().getClass() : Object.class;
            if (value instanceof Map) {
                value = new DynamicPropertySetSupport((Map)value, useAddIndexes);
                valueClass = DynamicPropertySetSupport.class;
            } else if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) {
                    value = new Object[]{};
                    valueClass = Object[].class;
                } else if (list.get(0) instanceof Map) {
                    ArrayList<DynamicPropertySetSupport> dpsList = new ArrayList<DynamicPropertySetSupport>();
                    for (int i = 0; i < list.size(); ++i) {
                        dpsList.add(new DynamicPropertySetSupport((Map)list.get(i), useAddIndexes));
                    }
                    value = dpsList.toArray(new DynamicPropertySetSupport[0]);
                    valueClass = DynamicPropertySetSupport[].class;
                } else {
                    Class<Object> elemClass = list.get(0) != null ? list.get(0).getClass() : Object.class;
                    value = list.toArray((Object[])Array.newInstance(elemClass, 0));
                    valueClass = Array.newInstance(elemClass, 0).getClass();
                }
            }
            DynamicProperty prop = new DynamicProperty(e.getKey().toString(), valueClass);
            prop.setValue(value);
            this.add(prop);
        });
    }

    public DynamicPropertySetSupport(boolean useAddIndexes) {
        this.useAddIndexes = useAddIndexes;
    }

    public boolean isUseAddIndexes() {
        return this.useAddIndexes;
    }

    @Override
    protected DynamicProperty findProperty(String name) {
        DynamicProperty ret = this.propHash.get(name);
        if (ret == null && this.useAddIndexes && this.propDisplayNameHash != null) {
            ret = this.propDisplayNameHash.get(name);
        }
        return ret;
    }

    @Override
    public void renameProperty(String from, String to) {
        DynamicProperty property = this.findProperty(from);
        if (property == null) {
            return;
        }
        property.setName(to);
        this.propHash.put(to, property);
        this.propHash.remove(from);
    }

    protected final void addProperty(DynamicProperty property) {
        this.addProperty(this.properties.size(), property);
    }

    protected final void addProperty(int index, DynamicProperty property) {
        String pname = property.getName();
        if (!this.bAddAlways && this.propHash.get(pname) != null) {
            this.replaceWith(pname, property);
            return;
        }
        this.properties.add(index, property);
        this.propHash.put(pname, property);
        if (this.useAddIndexes) {
            if (this.propDisplayNameHash == null) {
                this.propDisplayNameHash = new HashMap<String, DynamicProperty>();
            }
            this.propDisplayNameHash.put(property.getDisplayName(), property);
        }
        property.setParent(this);
    }

    @Override
    public void add(DynamicProperty property) {
        this.addProperty(property);
    }

    public void add(int index, DynamicProperty property) {
        this.addProperty(index, property);
    }

    @Override
    public boolean addBefore(String propName, DynamicProperty property) {
        DynamicProperty beforeProperty = this.findProperty(propName);
        int ind = this.properties.indexOf(beforeProperty);
        if (ind >= 0) {
            this.add(ind, property);
            return true;
        }
        this.add(property);
        return false;
    }

    @Override
    public boolean addAfter(String propName, DynamicProperty property) {
        DynamicProperty afterProperty = this.findProperty(propName);
        int ind = this.properties.indexOf(afterProperty);
        if (ind >= 0) {
            this.add(ind + 1, property);
            return true;
        }
        this.add(property);
        return false;
    }

    public DynamicPropertyBuilder build(String name, Class<?> clazz) {
        DynamicPropertyBuilder builder = new DynamicPropertyBuilder(name, clazz);
        this.add(builder.get());
        return builder;
    }

    @Override
    public DynamicPropertyBuilder getAsBuilder(String name) {
        DynamicPropertyBuilder builder = new DynamicPropertyBuilder(this.findProperty(name));
        return builder;
    }

    @Override
    public boolean contains(DynamicProperty property) {
        return this.properties.contains(property);
    }

    @Override
    public Object remove(String name) {
        DynamicProperty property = this.findProperty(name);
        if (this.properties.remove(property)) {
            Object retValue = property.getValue();
            this.propHash.remove(property.getName());
            if (this.useAddIndexes && this.propDisplayNameHash != null) {
                this.propDisplayNameHash.remove(property.getDisplayName());
            }
            property.setParent(null);
            return retValue;
        }
        return null;
    }

    @Override
    public boolean moveTo(String name, int index) {
        if (index > this.properties.size() - 1) {
            return false;
        }
        DynamicProperty property = this.findProperty(name);
        int oldIndex = this.properties.indexOf(property);
        if (oldIndex == -1) {
            return false;
        }
        if (oldIndex == index) {
            return true;
        }
        this.properties.remove(oldIndex);
        this.properties.add(index, property);
        return true;
    }

    public boolean moveBefore(String name, String nameBefore) {
        DynamicProperty property = this.findProperty(name);
        int indexOfName = this.properties.indexOf(property);
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!nameBefore.equalsIgnoreCase(this.properties.get(i).getName())) continue;
            if (indexOfName < i) {
                return this.moveTo(name, i - 1);
            }
            return this.moveTo(name, i);
        }
        return false;
    }

    public boolean moveAfter(String name, String nameAfter) {
        DynamicProperty property = this.findProperty(name);
        int indexOfName = this.properties.indexOf(property);
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!nameAfter.equalsIgnoreCase(this.properties.get(i).getName())) continue;
            if (indexOfName < i) {
                return this.moveTo(name, i);
            }
            return this.moveTo(name, i + 1);
        }
        return false;
    }

    @Override
    public boolean replaceWith(String name, DynamicProperty prop) {
        DynamicProperty old = this.findProperty(name);
        if (old == null) {
            return false;
        }
        int index = this.properties.indexOf(old);
        if (index == -1) {
            return false;
        }
        old.setParent(null);
        if (this.useAddIndexes && this.propDisplayNameHash != null) {
            this.propDisplayNameHash.remove(old.getDisplayName());
        }
        this.properties.set(index, prop);
        this.propHash.put(prop.getName(), prop);
        if (this.useAddIndexes) {
            if (this.propDisplayNameHash == null) {
                this.propDisplayNameHash = new HashMap<String, DynamicProperty>();
            }
            this.propDisplayNameHash.put(prop.getDisplayName(), prop);
        }
        return true;
    }

    public DynamicPropertySet diff(DynamicPropertySet sample) {
        DynamicPropertySetSupport diff = new DynamicPropertySetSupport();
        boolean isEmpty = true;
        Iterator<DynamicProperty> entries = sample.propertyIterator();
        while (entries.hasNext()) {
            DynamicProperty prop = entries.next();
            if (this.propHash.containsKey(prop.getName())) continue;
            isEmpty = false;
            if (prop.hasDescriptor()) {
                diff.add(new DynamicProperty(prop.getDescriptor(), prop.getType(), prop.getValue()));
                continue;
            }
            DynamicProperty newProp = new DynamicProperty(prop.getName(), prop.getType(), prop.getValue());
            newProp.setDisplayName(prop.getDisplayName());
            newProp.setShortDescription(prop.getShortDescription());
            newProp.setExpert(prop.isExpert());
            newProp.setHidden(prop.isHidden());
            Enumeration<String> attributeNames = prop.attributeNames();
            while (attributeNames.hasMoreElements()) {
                String attribute = attributeNames.nextElement();
                newProp.setAttribute(attribute, prop.getAttribute(attribute));
            }
            diff.add(newProp);
        }
        if (isEmpty) {
            return null;
        }
        return diff;
    }

    public static DynamicProperty cloneProperty(DynamicProperty prop) throws IntrospectionException, InvocationTargetException, InstantiationException, NoSuchMethodException, IllegalAccessException {
        int i;
        DynamicPropertySet[] narr;
        DynamicPropertySet[] oarr;
        Class<?> propClass = prop.getClass();
        if (prop.hasDescriptor()) {
            DynamicPropertySet[] narr2;
            DynamicPropertySet[] oarr2;
            DynamicProperty newProp;
            PropertyDescriptor propertyDescriptor = prop.getDescriptor();
            PropertyDescriptor result = new PropertyDescriptor(propertyDescriptor.getName(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
            result.setBound(propertyDescriptor.isBound());
            result.setConstrained(propertyDescriptor.isConstrained());
            result.setExpert(propertyDescriptor.isExpert());
            result.setHidden(propertyDescriptor.isHidden());
            result.setPreferred(propertyDescriptor.isPreferred());
            if (!propertyDescriptor.getName().equals(propertyDescriptor.getDisplayName())) {
                result.setDisplayName(propertyDescriptor.getDisplayName());
            }
            if (!propertyDescriptor.getDisplayName().equals(propertyDescriptor.getShortDescription())) {
                result.setShortDescription(propertyDescriptor.getShortDescription());
            }
            result.setPropertyEditorClass(propertyDescriptor.getPropertyEditorClass());
            Enumeration<String> e = propertyDescriptor.attributeNames();
            while (e.hasMoreElements()) {
                String atr = e.nextElement();
                Object attrVal = propertyDescriptor.getValue(atr);
                if (attrVal instanceof DynamicPropertySetSupport) {
                    result.setValue(atr, ((DynamicPropertySetSupport)attrVal).clone());
                    continue;
                }
                if (attrVal instanceof DynamicPropertySetSupport[]) {
                    DynamicPropertySetSupport[] origArr = (DynamicPropertySetSupport[])attrVal;
                    DynamicPropertySetSupport[] newArr = (DynamicPropertySetSupport[])Array.newInstance(attrVal.getClass().getComponentType(), origArr.length);
                    for (int i2 = 0; i2 < origArr.length; ++i2) {
                        if (origArr[i2] == null) continue;
                        newArr[i2] = (DynamicPropertySetSupport)origArr[i2].clone();
                    }
                    result.setValue(atr, newArr);
                    continue;
                }
                result.setValue(atr, attrVal);
            }
            if (prop.getValue() instanceof DynamicPropertySetSupport) {
                newProp = (DynamicProperty)propClass.getConstructor(PropertyDescriptor.class, Class.class, Object.class).newInstance(result, prop.getType(), ((DynamicPropertySetSupport)prop.getValue()).clone());
                return newProp;
            }
            if (prop.getValue() instanceof DynamicPropertySetSupport[]) {
                oarr2 = (DynamicPropertySetSupport[])prop.getValue();
                narr2 = (DynamicPropertySetSupport[])Array.newInstance(prop.getValue().getClass().getComponentType(), oarr2.length);
                for (int i3 = 0; i3 < oarr2.length; ++i3) {
                    if (oarr2[i3] == null) continue;
                    narr2[i3] = (DynamicPropertySetSupport)((DynamicPropertySetSupport)oarr2[i3]).clone();
                }
                DynamicProperty newProp2 = (DynamicProperty)propClass.getConstructor(PropertyDescriptor.class, Class.class, Object.class).newInstance(result, prop.getType(), narr2);
                return newProp2;
            }
            if (prop.getValue() instanceof DynamicPropertySet[]) {
                oarr2 = (DynamicPropertySet[])prop.getValue();
                narr2 = (DynamicPropertySet[])Array.newInstance(prop.getValue().getClass().getComponentType(), oarr2.length);
                for (int i4 = 0; i4 < oarr2.length; ++i4) {
                    if (oarr2[i4] == null) continue;
                    narr2[i4] = (DynamicPropertySet)oarr2[i4].clone();
                }
                DynamicProperty newProp3 = (DynamicProperty)propClass.getConstructor(PropertyDescriptor.class, Class.class, Object.class).newInstance(result, prop.getType(), narr2);
                return newProp3;
            }
            newProp = (DynamicProperty)propClass.getConstructor(PropertyDescriptor.class, Class.class, Object.class).newInstance(result, prop.getType(), prop.getValue());
            return newProp;
        }
        DynamicProperty newProp = null;
        if (prop.getValue() instanceof DynamicPropertySetSupport) {
            newProp = (DynamicProperty)propClass.getConstructor(String.class, Class.class, Object.class).newInstance(prop.getName(), prop.getType(), ((DynamicPropertySetSupport)prop.getValue()).clone());
        } else if (prop.getValue() instanceof DynamicPropertySetSupport[]) {
            oarr = (DynamicPropertySetSupport[])prop.getValue();
            narr = (DynamicPropertySetSupport[])Array.newInstance(prop.getValue().getClass().getComponentType(), oarr.length);
            for (i = 0; i < oarr.length; ++i) {
                if (oarr[i] == null) continue;
                narr[i] = (DynamicPropertySetSupport)((DynamicPropertySetSupport)oarr[i]).clone();
            }
            newProp = (DynamicProperty)propClass.getConstructor(String.class, Class.class, Object.class).newInstance(prop.getName(), prop.getType(), narr);
        } else if (prop.getValue() instanceof DynamicPropertySet[]) {
            oarr = (DynamicPropertySet[])prop.getValue();
            narr = (DynamicPropertySet[])Array.newInstance(prop.getValue().getClass().getComponentType(), oarr.length);
            for (i = 0; i < oarr.length; ++i) {
                if (oarr[i] == null) continue;
                narr[i] = (DynamicPropertySet)oarr[i].clone();
            }
            newProp = (DynamicProperty)propClass.getConstructor(String.class, Class.class, Object.class).newInstance(prop.getName(), prop.getType(), narr);
        } else {
            newProp = (DynamicProperty)propClass.getConstructor(String.class, Class.class, Object.class).newInstance(prop.getName(), prop.getType(), prop.getValue());
        }
        newProp.setHidden(prop.isHidden());
        newProp.setExpert(prop.isExpert());
        newProp.setDisplayName(prop.getDisplayName());
        newProp.setShortDescription(prop.getShortDescription());
        Enumeration<String> attributeNames = prop.attributeNames();
        while (attributeNames.hasMoreElements()) {
            String attribute = attributeNames.nextElement();
            Object attrVal = prop.getAttribute(attribute);
            if (attrVal instanceof DynamicPropertySetSupport) {
                newProp.setAttribute(attribute, ((DynamicPropertySetSupport)attrVal).clone());
                continue;
            }
            if (attrVal instanceof DynamicPropertySetSupport[]) {
                DynamicPropertySetSupport[] origArr = (DynamicPropertySetSupport[])attrVal;
                DynamicPropertySetSupport[] newArr = (DynamicPropertySetSupport[])Array.newInstance(attrVal.getClass().getComponentType(), origArr.length);
                for (int i5 = 0; i5 < origArr.length; ++i5) {
                    if (origArr[i5] == null) continue;
                    newArr[i5] = (DynamicPropertySetSupport)origArr[i5].clone();
                }
                newProp.setAttribute(attribute, newArr);
                continue;
            }
            newProp.setAttribute(attribute, attrVal);
        }
        return newProp;
    }

    @Override
    public Object clone() {
        DynamicPropertySetSupport retVal = (DynamicPropertySetSupport)super.clone();
        retVal.pcSupport = null;
        retVal.properties = new ArrayList();
        retVal.propHash = new TreeMap<String, DynamicProperty>(String.CASE_INSENSITIVE_ORDER);
        Iterator<DynamicProperty> iter = this.propertyIterator();
        while (iter.hasNext()) {
            DynamicProperty prop = iter.next();
            try {
                retVal.add(DynamicPropertySetSupport.cloneProperty(prop));
            }
            catch (Exception wierd) {
                Logger.getLogger().error("Unable to clone property " + prop.getName(), wierd);
            }
        }
        return retVal;
    }

    public static DynamicPropertySet cloneAndSimplify(DynamicPropertySet orig) {
        DynamicPropertySetSupport dps = new DynamicPropertySetSupport(false);
        orig.forEach(dp -> {
            try {
                dps.add(DynamicPropertySetSupport.cloneAndSimplifyProperty(dp));
            }
            catch (Exception wierd) {
                System.err.println("Unable to clone property " + dp.getName() + ", message = " + wierd.getMessage());
            }
        });
        return dps;
    }

    public static DynamicProperty cloneAndSimplifyProperty(DynamicProperty prop) throws IntrospectionException, InvocationTargetException, InstantiationException, NoSuchMethodException, IllegalAccessException {
        DynamicProperty newProp = new DynamicProperty(prop.getName(), prop.getType(), prop.getValue());
        newProp.setHidden(prop.isHidden());
        newProp.setExpert(prop.isExpert());
        newProp.setDisplayName(prop.getDisplayName());
        newProp.setShortDescription(prop.getShortDescription());
        Enumeration<String> attributeNames = prop.attributeNames();
        while (attributeNames.hasMoreElements()) {
            String attribute = attributeNames.nextElement();
            Object attrVal = prop.getAttribute(attribute);
            if (attrVal instanceof DynamicPropertySet) {
                newProp.setAttribute(attribute, DynamicPropertySetSupport.cloneAndSimplify((DynamicPropertySet)attrVal));
                continue;
            }
            if (attrVal instanceof DynamicPropertySetSupport[]) {
                newProp.setAttribute(attribute, new DynamicPropertySetSupport[0]);
                continue;
            }
            newProp.setAttribute(attribute, attrVal);
        }
        return newProp;
    }

    @Override
    public Iterator<String> nameIterator() {
        return new Iterator<String>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < DynamicPropertySetSupport.this.properties.size();
            }

            @Override
            public String next() {
                return DynamicPropertySetSupport.this.properties.get(this.current++).getName();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("DynamicPropertySetSupport.nameItearator() does not support remove()");
            }
        };
    }

    @Override
    public Iterator<DynamicProperty> propertyIterator() {
        return new Iterator<DynamicProperty>(){
            int cursor;
            int lastRet = -1;

            @Override
            public boolean hasNext() {
                return this.cursor < DynamicPropertySetSupport.this.properties.size();
            }

            @Override
            public DynamicProperty next() {
                int i = this.cursor;
                if (i >= DynamicPropertySetSupport.this.properties.size()) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return DynamicPropertySetSupport.this.properties.get(this.lastRet);
            }

            @Override
            public void remove() {
                DynamicProperty property = DynamicPropertySetSupport.this.properties.remove(this.lastRet);
                DynamicPropertySetSupport.this.propHash.remove(property.getName());
                if (DynamicPropertySetSupport.this.useAddIndexes && DynamicPropertySetSupport.this.propDisplayNameHash != null) {
                    DynamicPropertySetSupport.this.propDisplayNameHash.remove(property.getDisplayName());
                }
                property.setParent(null);
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }
        };
    }

    @Override
    public Spliterator<DynamicProperty> spliterator() {
        return this.properties.spliterator();
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> viewMap = new LinkedHashMap<String, Object>(this.properties.size());
        for (DynamicProperty prop : this.properties) {
            viewMap.put(prop.getName(), prop.getValue());
        }
        return Collections.unmodifiableMap(viewMap);
    }

    public void setAttributeToAllChildren(String attrName, Object attrValue) throws Exception {
        for (DynamicProperty prop : this) {
            prop.setAttribute(attrName, attrValue);
            prop.setAttributeToAllChildren(attrName, attrValue);
        }
    }

    public void setAttributeToAllChildrenIfEmpty(String attrName, Object attrValue) throws Exception {
        for (DynamicProperty prop : this) {
            if (prop.getAttribute(attrName) == null) {
                prop.setAttribute(attrName, attrValue);
            }
            prop.setAttributeToAllChildrenIfEmpty(attrName, attrValue);
        }
    }

    public void setCanBeNullToAllChildren(boolean isNull) {
        for (DynamicProperty prop : this) {
            prop.setCanBeNull(isNull);
            Object value = prop.getValue();
            if (value instanceof DynamicPropertySetSupport) {
                ((DynamicPropertySetSupport)value).setCanBeNullToAllChildren(isNull);
                continue;
            }
            if (!(value instanceof DynamicPropertySetSupport[])) continue;
            for (DynamicPropertySetSupport propBean : (DynamicPropertySetSupport[])value) {
                propBean.setCanBeNullToAllChildren(isNull);
            }
        }
    }

    public void setExpertToAllChildren(boolean expert) throws Exception {
        for (DynamicProperty prop : this) {
            prop.setExpert(expert);
            Object value = prop.getValue();
            if (value instanceof DynamicPropertySetSupport) {
                ((DynamicPropertySetSupport)value).setExpertToAllChildren(expert);
                continue;
            }
            if (!(value instanceof DynamicPropertySetSupport[])) continue;
            for (DynamicPropertySetSupport propBean : (DynamicPropertySetSupport[])value) {
                propBean.setExpertToAllChildren(expert);
            }
        }
    }

    public void setReadOnlyToAllChildren(boolean expert) throws Exception {
        for (DynamicProperty prop : this) {
            prop.setReadOnly(expert);
            Object value = prop.getValue();
            if (value instanceof DynamicPropertySetSupport) {
                ((DynamicPropertySetSupport)value).setReadOnlyToAllChildren(expert);
                continue;
            }
            if (!(value instanceof DynamicPropertySetSupport[])) continue;
            for (DynamicPropertySetSupport propBean : (DynamicPropertySetSupport[])value) {
                propBean.setReadOnlyToAllChildren(expert);
            }
        }
    }

    public String toString() {
        StringWriter out = new StringWriter();
        this.printProperties(out, "");
        return "DPS(" + this.getClass().getName() + "):" + out.toString();
    }

    protected void printProperties(Writer out, String offset) {
        try {
            for (int i = 0; i < this.properties.size(); ++i) {
                StringWriter rout;
                out.write("\n  " + offset + (i + 1) + ". ");
                DynamicProperty dp = this.properties.get(i);
                String valStr = "";
                if (dp.getValue() instanceof DynamicPropertySetSupport) {
                    StringWriter rout2 = new StringWriter();
                    ((DynamicPropertySetSupport)dp.getValue()).printProperties(rout2, "   " + offset);
                    valStr = "DPS:" + rout2.toString();
                } else if (dp.getValue() instanceof DynamicPropertySetSupport[]) {
                    int ind = 0;
                    rout = new StringWriter();
                    for (DynamicPropertySet dynamicPropertySet : (DynamicPropertySetSupport[])dp.getValue()) {
                        rout.write("\n     " + offset + "[" + ind++ + "]:");
                        ((DynamicPropertySetSupport)dynamicPropertySet).printProperties(rout, "      " + offset);
                    }
                    valStr = "Array:" + rout.toString();
                } else if (dp.getValue() instanceof DynamicPropertySet[]) {
                    int ind = 0;
                    rout = new StringWriter();
                    for (DynamicPropertySet dynamicPropertySet : (DynamicPropertySet[])dp.getValue()) {
                        rout.write("\n     " + offset + "[" + ind++ + "]:");
                        ((DynamicPropertySetSupport)dynamicPropertySet).printProperties(rout, "      " + offset);
                    }
                    valStr = "Array:" + rout.toString();
                } else if (dp.getAttribute("arrayItemTemplate") instanceof DynamicPropertySetSupport) {
                    DynamicPropertySetSupport arrBean = (DynamicPropertySetSupport)dp.getAttribute("arrayItemTemplate");
                    rout = new StringWriter();
                    rout.write("\n     " + offset + "[]:");
                    dp.getAttribute("arrayItemTemplate");
                    arrBean.printProperties(rout, "      " + offset);
                    valStr = "Array:" + rout.toString();
                } else {
                    valStr = dp.getValue() instanceof Object[] ? Arrays.asList((Object[])dp.getValue()).toString() : "" + dp.getValue();
                }
                out.write(dp.getName() + " (" + dp.getType() + ") - " + valStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String asJSON() {
        StringWriter out = new StringWriter();
        this.printPropertiesAsJSON(out, true, "", false);
        return out.toString();
    }

    public String asJSON(boolean bSkipEmpty) {
        StringWriter out = new StringWriter();
        this.printPropertiesAsJSON(out, bSkipEmpty, "", false);
        return out.toString();
    }

    public String fullJSON() {
        StringWriter out = new StringWriter();
        this.printPropertiesAsJSON(out, false, "", false);
        return out.toString();
    }

    public String plainJSON() {
        StringWriter out = new StringWriter();
        this.printPropertiesAsJSON(out, true, "", true);
        return out.toString();
    }

    protected void printPropertiesAsJSON(Writer out, boolean bSkipEmpty, String offset, boolean bNoAttrs) {
        try {
            out.write(offset + "{");
            int propCount = 0;
            for (int i = 0; i < this.properties.size(); ++i) {
                DynamicProperty dp = this.properties.get(i);
                if (bSkipEmpty && dp.getValue() == null || bSkipEmpty && dp.getValue() instanceof Object[] && ((Object[])dp.getValue()).length == 0) continue;
                if (propCount > 0) {
                    out.write(",");
                }
                out.write("\n  " + offset + DynamicPropertySetSupport.makeJSONPropName(dp.getName()) + ": ");
                String valStr = "";
                if (dp.getValue() instanceof DynamicPropertySetSupport) {
                    StringWriter rout = new StringWriter();
                    ((DynamicPropertySetSupport)dp.getValue()).printPropertiesAsJSON(rout, bSkipEmpty, "  " + offset, bNoAttrs);
                    valStr = "\n" + rout.toString();
                } else if (dp.getValue() instanceof DynamicPropertySetSupport[]) {
                    int ind = 0;
                    StringWriter rout = new StringWriter();
                    rout.write(offset + "[");
                    for (DynamicPropertySetSupport arrBean : (DynamicPropertySetSupport[])dp.getValue()) {
                        if (ind > 0) {
                            rout.write(",");
                        }
                        rout.write("\n");
                        arrBean.printPropertiesAsJSON(rout, bSkipEmpty, "    " + offset, bNoAttrs);
                        ++ind;
                    }
                    rout.write("\n" + offset + "  ]");
                    valStr = "\n  " + rout.toString();
                } else if (dp.getValue() == null) {
                    valStr = "null";
                } else if (dp.getValue() instanceof String) {
                    Object disp;
                    valStr = DynamicPropertySetSupport.makeJSONStringValue((String)dp.getValue());
                    if (!bNoAttrs && dp.getAttribute("tag-list-attr") instanceof Map && (disp = ((Map)dp.getAttribute("tag-list-attr")).get(dp.getValue())) != null) {
                        valStr = valStr + ",\n  " + offset + DynamicPropertySetSupport.makeJSONPropName(dp.getName() + ":displayValue") + ": " + DynamicPropertySetSupport.makeJSONStringValue((String)disp);
                    }
                } else if (dp.getValue() instanceof String[]) {
                    String[] vals = (String[])dp.getValue();
                    valStr = "[";
                    for (int v = 0; v < vals.length; ++v) {
                        if (v > 0) {
                            valStr = valStr + ",";
                        }
                        valStr = valStr + DynamicPropertySetSupport.makeJSONStringValue(vals[v]);
                    }
                    valStr = valStr + "]";
                } else {
                    valStr = dp.getValue() instanceof java.util.Date ? "\"" + new Date(((java.util.Date)dp.getValue()).getTime()) + "\"" : (dp.getValue() instanceof File ? DynamicPropertySetSupport.makeJSONStringValue(((File)dp.getValue()).getCanonicalPath()) : "" + dp.getValue());
                }
                out.write(valStr);
                if (!bNoAttrs && !dp.getDisplayName().equals(dp.getName())) {
                    out.write(",\n  " + offset + DynamicPropertySetSupport.makeJSONPropName(dp.getName() + ":displayName") + ": " + DynamicPropertySetSupport.makeJSONStringValue(dp.getDisplayName()));
                }
                ++propCount;
            }
            out.write("\n" + offset + "}");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public DynamicPropertySetSupport skipLevel() {
        Iterator<DynamicProperty> iterator = this.iterator();
        if (iterator.hasNext()) {
            DynamicProperty prop = iterator.next();
            return (DynamicPropertySetSupport)prop.getValue();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String makeBetterDisplayName(String colName) {
        StringTokenizer st;
        if (colName == null || colName.length() < 1) {
            return colName;
        }
        StringBuffer label = new StringBuffer("");
        if (Character.isLowerCase(colName.charAt(0)) || colName.length() > 1 && Character.isUpperCase(colName.charAt(0)) && Character.isLowerCase(colName.charAt(1))) {
            label.append(Character.toUpperCase(colName.charAt(0)));
            int size = colName.length();
            for (int j = 1; j < size; ++j) {
                char cur = colName.charAt(j);
                if (Character.isUpperCase(cur) && Character.isLowerCase(colName.charAt(j - 1))) {
                    label.append(' ');
                    label.append(cur);
                    continue;
                }
                label.append(cur);
            }
        }
        if ((st = new StringTokenizer(label.length() > 0 ? label.toString() : colName, "_")).countTokens() > 1) {
            if (label.length() > 0) {
                label = new StringBuffer();
            }
            boolean isFirst = true;
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if ("".equals(word)) continue;
                if (!isFirst) {
                    label.append(' ');
                }
                word = word.toLowerCase();
                label.append(Character.toUpperCase(word.charAt(0)));
                label.append(word.substring(1));
                isFirst = false;
            }
            return label.toString();
        }
        if (label.length() != 0 && (!colName.equals(colName.toLowerCase()) || label.toString().indexOf(" ") >= 0)) return label.toString();
        label.setLength(0);
        label.append(Character.toUpperCase(colName.charAt(0)));
        label.append(colName.substring(1).toLowerCase());
        int labLen = label.length();
        for (String dictWord : dictionaryWords) {
            if (dictWord.equalsIgnoreCase(label.toString())) break;
            if (labLen <= dictWord.length() || !label.toString().endsWith(dictWord)) continue;
            int diff = labLen - dictWord.length();
            label.setCharAt(diff, Character.toUpperCase(label.charAt(diff)));
            label.insert(diff, ' ');
            return label.toString();
        }
        return label.toString();
    }
}

