/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.ObjectInputStreamWithLoader;
import com.developmentontheedge.beans.Preferences;
import com.developmentontheedge.beans.log.Logger;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DynamicPropertySetSerializer {
    private static String encoding = "UTF-8";
    private static final Pattern OLD_PREFIX = Pattern.compile("^com\\.beanexplorer\\.(beans\\.)");
    private static final String NEW_PREFIX = "com.developmentontheedge.beans.";
    protected static final String DYNAMIC_PROPERTY_SET_ELEMENT = "dynamicPropertySet";
    protected static final String PROPERTY_ELEMENT = "property";
    protected static final String NAME_ATTR = "name";
    protected static final String TYPE_ATTR = "type";
    protected static final String VALUE_ATTR = "value";
    protected static final String DISPLAY_NAME_ATTR = "display-name";
    protected static final String SHORT_DESCRIPTION_ATTR = "short-description";
    protected static final String PROPERTY_EDITOR_ATTR = "property-editor";
    protected static final String HIDDEN_ATTR = "hidden";
    protected static final String EXPERT_ATTR = "expert";
    protected static final String READ_ONLY_ATTR = "read-only";
    protected static final String ORDERED = "ordered";
    protected Map registry = null;
    DynamicPropertySet dpsLoaded;
    protected int indentation = 0;
    protected int indent = 4;
    protected OutputStream out;

    protected void error(String msg, Throwable t) {
        Logger.getLogger().error("Error: " + msg + (t == null ? "" : ", exception - " + t), t);
    }

    public void load(DynamicPropertySet dps, InputStream in, Map registry) {
        this.registry = registry;
        this.load(dps, in);
    }

    public void load(DynamicPropertySet dps, InputStream in) {
        this.dpsLoaded = dps;
        this.load(in, this.getClass().getClassLoader());
    }

    public void load(DynamicPropertySet dps, InputStream in, ClassLoader classLoader) {
        this.dpsLoaded = dps;
        this.load(in, classLoader);
    }

    public void load(InputStream in, ClassLoader classLoader) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SaxHandler handler = new SaxHandler(classLoader);
            saxParser.parse(new InputSource(in), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            this.error("Could not parse", t);
        }
    }

    public void load(DynamicPropertySet dps, String fileName) {
        this.load(dps, fileName, this.getClass().getClassLoader());
    }

    public void load(DynamicPropertySet dps, String fileName, ClassLoader classLoader) {
        this.dpsLoaded = dps;
        File file = new File(fileName);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SaxHandler saxHandler = new SaxHandler(classLoader);
            saxParser.parse(new File(fileName), (DefaultHandler)saxHandler);
        }
        catch (Throwable t) {
            this.error("could not load preferences, file=" + file.getAbsolutePath(), t);
        }
    }

    public void save(String fileName, DynamicPropertySet dps) throws IOException {
        this.save(new FileOutputStream(fileName), dps);
    }

    public void save(OutputStream out, DynamicPropertySet dps, Map registry) throws IOException {
        this.registry = registry;
        this.save(out, dps);
    }

    public void save(OutputStream out, DynamicPropertySet dps) throws IOException {
        this.out = out;
        if (dps.asMap().size() > 0) {
            this.writeln("<?xml version=" + this.quote("1.0") + " encoding=" + this.quote(encoding) + "?>");
            this.writeDynamicPropertySet(dps);
        }
    }

    protected void writeDynamicPropertySet(DynamicPropertySet dps) throws IOException {
        this.writeln("<dynamicPropertySet>");
        this.indentation += this.indent;
        Iterator<DynamicProperty> i = dps.propertyIterator();
        while (i.hasNext()) {
            this.writeProperty(i.next());
        }
        this.indentation -= this.indent;
        this.writeln("</dynamicPropertySet>");
    }

    protected void writeProperty(DynamicProperty property) throws IOException {
        this.write("<property");
        boolean fullRecord = true;
        if (this.registry != null && this.registry.containsKey(property.getName())) {
            fullRecord = false;
        }
        this.writeAttribute(NAME_ATTR, property.getName());
        if (fullRecord) {
            this.writeAttribute(TYPE_ATTR, property.getType().getName());
        }
        Object value = property.getValue();
        String strValue = null;
        try {
            if (value instanceof String) {
                strValue = ((String)value).replaceAll("\\n", "\\\\n");
            } else if (value instanceof Boolean) {
                strValue = ((Boolean)value).toString();
            } else if (value instanceof Integer) {
                strValue = ((Integer)value).toString();
            } else if (value instanceof Double) {
                strValue = ((Double)value).toString();
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(value);
                byte[] bytes = os.toByteArray();
                strValue = Base64.getEncoder().encodeToString(bytes);
                oos.close();
            }
        }
        catch (Exception e) {
            this.error("Cannot serialize value of property " + property.getName(), e);
        }
        if (value != null && !(value instanceof Preferences)) {
            this.writeAttribute(VALUE_ATTR, "" + strValue);
        }
        if (fullRecord) {
            PropertyDescriptor descriptor = property.getDescriptor();
            this.writeAttribute(DISPLAY_NAME_ATTR, descriptor.getDisplayName());
            this.writeAttribute(SHORT_DESCRIPTION_ATTR, descriptor.getShortDescription());
            if (descriptor.getPropertyEditorClass() != null) {
                this.writeAttribute(PROPERTY_EDITOR_ATTR, descriptor.getPropertyEditorClass().getName());
            }
            if (descriptor.isHidden()) {
                this.writeAttribute(HIDDEN_ATTR, "true");
            }
            if (descriptor.isExpert()) {
                this.writeAttribute(EXPERT_ATTR, "true");
            }
            if (this.booleanFeature(descriptor, READ_ONLY_ATTR)) {
                this.writeAttribute(READ_ONLY_ATTR, "true");
            }
        }
        if (!(value instanceof Preferences)) {
            this.out.write("/>".getBytes(encoding));
            this.out.write(" \n".getBytes(encoding));
        } else {
            if (((Preferences)value).isSaveOrder()) {
                this.writeAttribute(ORDERED, "true");
            }
            this.out.write(">\n".getBytes(encoding));
            this.indentation += this.indent;
            this.writeDynamicPropertySet((Preferences)value);
            this.indentation -= this.indent;
            this.writeln("</property>");
        }
    }

    protected void writeAttribute(String attr, String value) throws IOException {
        this.out.write((" " + attr + "=" + this.quote(value)).getBytes(encoding));
    }

    protected boolean booleanFeature(PropertyDescriptor descriptor, String feature) {
        Object value = descriptor.getValue(feature);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    protected void write(String exp) throws IOException {
        for (int i = 0; i < this.indentation; ++i) {
            this.out.write(32);
        }
        this.out.write(exp.getBytes(encoding));
    }

    protected void writeln(String exp) throws IOException {
        this.write(exp);
        this.out.write(" \n".getBytes(encoding));
    }

    protected String quote(String s) {
        return "\"" + DynamicPropertySetSerializer.quoteCharacters(s) + "\"";
    }

    public static String quoteCharacters(String s) {
        StringBuffer result = null;
        int max = s.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            String replacement = null;
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\'') {
                replacement = "&apos;";
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    protected class SaxHandler
    extends DefaultHandler {
        protected DynamicPropertySet dps;
        protected DynamicProperty property;
        protected Stack<DynamicPropertySet> parents = new Stack();
        protected ClassLoader classLoader;

        public SaxHandler(ClassLoader loader) {
            this.classLoader = loader;
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
        }

        @Override
        public void startElement(String namespaceURI, String name, String qualifiedName, Attributes attrs) throws SAXException {
            if (name.length() == 0) {
                name = qualifiedName;
            }
            if (DynamicPropertySetSerializer.DYNAMIC_PROPERTY_SET_ELEMENT.equals(name)) {
                if (this.dps == null) {
                    this.dps = DynamicPropertySetSerializer.this.dpsLoaded;
                } else {
                    this.parents.push(this.dps);
                    try {
                        this.dps = (DynamicPropertySet)this.property.getType().newInstance();
                    }
                    catch (Throwable t) {
                        DynamicPropertySetSerializer.this.error("Can instantiate DyanamicPropertySet, className=" + this.property.getType(), t);
                    }
                    if (this.dps == null) {
                        this.dps = new Preferences();
                    }
                    if (this.dps instanceof Preferences && this.property.getDescriptor().getValue(DynamicPropertySetSerializer.ORDERED) != null) {
                        ((Preferences)this.dps).setSaveOrder(true);
                    }
                    this.property.setValue(this.dps);
                }
            } else if (DynamicPropertySetSerializer.PROPERTY_ELEMENT.equals(name)) {
                this.readProperty(attrs);
            } else {
                DynamicPropertySetSerializer.this.error("Unknown tag <" + name + ">", null);
            }
        }

        @Override
        public void endElement(String namespaceURI, String name, String qualifiedName) throws SAXException {
            if (name.length() == 0) {
                name = qualifiedName;
            }
            if (DynamicPropertySetSerializer.DYNAMIC_PROPERTY_SET_ELEMENT.equals(name)) {
                this.dps = this.parents.empty() ? DynamicPropertySetSerializer.this.dpsLoaded : this.parents.pop();
            }
        }

        protected void readProperty(Attributes attrs) {
            String name = attrs.getValue(DynamicPropertySetSerializer.NAME_ATTR);
            String strType = null;
            Object value = null;
            PropertyDescriptor descriptor = null;
            if (DynamicPropertySetSerializer.this.registry != null && DynamicPropertySetSerializer.this.registry.containsKey(name)) {
                DynamicProperty dp = (DynamicProperty)DynamicPropertySetSerializer.this.registry.get(name);
                descriptor = dp.getDescriptor();
                strType = dp.getType().getName();
            } else {
                try {
                    descriptor = new PropertyDescriptor(attrs.getValue(DynamicPropertySetSerializer.NAME_ATTR), null, null);
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            }
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attr = attrs.getLocalName(i);
                if (attr.length() == 0) {
                    attr = attrs.getQName(i);
                }
                String valueStr = attrs.getValue(i);
                if (DynamicPropertySetSerializer.NAME_ATTR.equals(attr)) continue;
                if (DynamicPropertySetSerializer.TYPE_ATTR.equals(attr)) {
                    strType = valueStr;
                    continue;
                }
                if (DynamicPropertySetSerializer.VALUE_ATTR.equals(attr)) {
                    try {
                        try {
                            if (strType.equals(String.class.getName())) {
                                value = valueStr.replaceAll("\\\\n", "\n");
                            } else if (strType.equals(Boolean.class.getName())) {
                                value = Boolean.parseBoolean(valueStr);
                            } else if (strType.equals(Integer.class.getName())) {
                                value = Integer.parseInt(valueStr);
                            } else if (strType.equals(Double.class.getName())) {
                                value = Double.parseDouble(valueStr);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (value != null) continue;
                        byte[] encodedBytes = Base64.getDecoder().decode(valueStr);
                        ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader(new ByteArrayInputStream(encodedBytes), Thread.currentThread().getContextClassLoader());
                        value = ois.readObject();
                        ois.close();
                    }
                    catch (Exception e) {
                        DynamicPropertySetSerializer.this.error("Could not load object from property " + descriptor.getName(), e);
                    }
                    continue;
                }
                if (DynamicPropertySetSerializer.DISPLAY_NAME_ATTR.equals(attr)) {
                    descriptor.setDisplayName(valueStr);
                    continue;
                }
                if (DynamicPropertySetSerializer.SHORT_DESCRIPTION_ATTR.equals(attr)) {
                    descriptor.setShortDescription(valueStr);
                    continue;
                }
                if (DynamicPropertySetSerializer.HIDDEN_ATTR.equals(attr)) {
                    descriptor.setHidden("true".equalsIgnoreCase(valueStr));
                    continue;
                }
                if (DynamicPropertySetSerializer.EXPERT_ATTR.equals(attr)) {
                    descriptor.setExpert("true".equalsIgnoreCase(valueStr));
                    continue;
                }
                if (DynamicPropertySetSerializer.READ_ONLY_ATTR.equals(attr)) {
                    descriptor.setValue(DynamicPropertySetSerializer.READ_ONLY_ATTR, "true".equalsIgnoreCase(valueStr));
                    continue;
                }
                if (DynamicPropertySetSerializer.PROPERTY_EDITOR_ATTR.equals(attr)) {
                    try {
                        Class<?> c = this.classLoader.loadClass(OLD_PREFIX.matcher(valueStr).replaceFirst(DynamicPropertySetSerializer.NEW_PREFIX));
                        descriptor.setPropertyEditorClass(c);
                    }
                    catch (ClassNotFoundException e) {
                        DynamicPropertySetSerializer.this.error("Could not load property editor class " + valueStr + " for property " + descriptor.getName(), e);
                    }
                    continue;
                }
                if (DynamicPropertySetSerializer.ORDERED.equals(attr)) {
                    descriptor.setValue(DynamicPropertySetSerializer.ORDERED, "true".equalsIgnoreCase(valueStr));
                    continue;
                }
                descriptor.setValue(attr, valueStr);
            }
            if (strType == null) {
                DynamicPropertySetSerializer.this.error("Property type is missing for property " + descriptor.getName(), null);
                return;
            }
            Class<?> type = null;
            try {
                type = this.classLoader.loadClass(OLD_PREFIX.matcher(strType).replaceFirst(DynamicPropertySetSerializer.NEW_PREFIX));
            }
            catch (ClassNotFoundException e) {
                DynamicPropertySetSerializer.this.error("Could not find property value class'" + strType + "', property " + descriptor.getName(), e);
                return;
            }
            this.property = new DynamicProperty(descriptor, type, value);
            this.dps.add(this.property);
        }
    }
}

