/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.AbstractDynamicPropertySet;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.log.Logger;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.TreeMap;

public class DynamicPropertySetAsMap
extends AbstractDynamicPropertySet {
    private static final long serialVersionUID = 1L;
    protected Map<String, DynamicProperty> propertiesMap = new TreeMap<String, DynamicProperty>(new PropertyComparator());

    @Override
    public boolean contains(DynamicProperty property) {
        return this.propertiesMap.containsValue(property);
    }

    @Override
    protected DynamicProperty findProperty(String name) {
        return this.propertiesMap.get(name);
    }

    @Override
    public void renameProperty(String from, String to) {
        throw new RuntimeException("Not yet implmented!");
    }

    @Override
    public Object clone() {
        DynamicPropertySetAsMap retVal = (DynamicPropertySetAsMap)super.clone();
        retVal.pcSupport = null;
        retVal.propertiesMap = new TreeMap<String, DynamicProperty>(new PropertyComparator());
        Iterator<DynamicProperty> iter = this.propertyIterator();
        while (iter.hasNext()) {
            DynamicProperty prop = iter.next();
            try {
                retVal.add(DynamicPropertySetSupport.cloneProperty(prop));
            }
            catch (Exception wierd) {
                Logger.getLogger().error("Unable to clone property " + prop.getName(), wierd);
            }
        }
        return retVal;
    }

    @Override
    public Iterator<String> nameIterator() {
        return this.propertiesMap.keySet().iterator();
    }

    @Override
    public Iterator<DynamicProperty> propertyIterator() {
        return this.propertiesMap.values().iterator();
    }

    @Override
    public Spliterator<DynamicProperty> spliterator() {
        return this.propertiesMap.values().spliterator();
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> viewMap = new HashMap<String, Object>(this.propertiesMap.size());
        for (Map.Entry<String, DynamicProperty> entry : this.propertiesMap.entrySet()) {
            DynamicProperty prop = entry.getValue();
            viewMap.put(entry.getKey(), prop.getValue());
        }
        return Collections.unmodifiableMap(viewMap);
    }

    @Override
    public void add(DynamicProperty property) {
        Object newValue;
        Object oldValue = this.getValue(property.getName());
        this.propertiesMap.put(property.getName(), property);
        property.setParent(this);
        if (this.hasListeners(property.getName()) && oldValue != (newValue = property.getValue()) && (oldValue == null || newValue == null || !oldValue.equals(newValue))) {
            this.firePropertyChange(new PropertyChangeEvent(this, property.getName(), oldValue, newValue));
        }
    }

    @Override
    public Object remove(String name) {
        if (this.propertiesMap.containsKey(name)) {
            DynamicProperty property = this.propertiesMap.get(name);
            property.setParent(null);
            this.propertiesMap.remove(name);
            return property.getValue();
        }
        return null;
    }

    @Override
    public boolean addBefore(String propName, DynamicProperty property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAfter(String propName, DynamicProperty property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveTo(String name, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replaceWith(String name, DynamicProperty prop) {
        if (this.findProperty(name) != null) {
            this.remove(name);
            this.add(prop);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.propertiesMap.size();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        this.printProperties(out);
        return "DynamicPropertySetAsMap:" + out.toString();
    }

    protected void printProperties(Writer out) {
        try {
            int i = 0;
            for (DynamicProperty dp : this.propertiesMap.values()) {
                out.write("\n  " + (++i + 1) + ". ");
                out.write(dp.getName() + " (" + dp.getType().getSimpleName() + ") - " + dp.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class PropertyComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 1L;

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

