/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.util.LinkedHashMap;
import java.util.Map;

public class DynamicPropertyBuilder {
    private final DynamicProperty property;

    public DynamicPropertyBuilder(String name, Class<?> clazz) {
        this.property = new DynamicProperty(name, name, clazz);
    }

    DynamicPropertyBuilder(DynamicProperty prop) {
        this.property = prop;
    }

    public DynamicPropertyBuilder title(String title) {
        this.property.setDisplayName(title);
        return this;
    }

    public DynamicPropertyBuilder value(Object value) {
        this.property.setValue(value);
        return this;
    }

    public DynamicPropertyBuilder readonly(boolean condition) {
        this.property.setReadOnly(condition);
        return this;
    }

    public DynamicPropertyBuilder readonly() {
        return this.readonly(true);
    }

    public DynamicPropertyBuilder nullable(boolean condition) {
        this.property.setCanBeNull(condition);
        return this;
    }

    public DynamicPropertyBuilder nullable() {
        return this.nullable(true);
    }

    public DynamicPropertyBuilder hidden(boolean condition) {
        this.property.setHidden(condition);
        return this;
    }

    public DynamicPropertyBuilder hidden() {
        return this.hidden(true);
    }

    public DynamicPropertyBuilder attr(String name, Object value) {
        this.property.setAttribute(name, value);
        return this;
    }

    public DynamicPropertyBuilder attrs(Map<String, Object> vals) {
        for (String key : vals.keySet()) {
            this.property.setAttribute(key, vals.get(key));
        }
        return this;
    }

    public DynamicPropertyBuilder noServerCheck() {
        this.property.setAttribute("skip-server-null-check", true);
        return this;
    }

    public DynamicPropertyBuilder dynamicTags(Object tags) {
        return this.attr("tag-list-attr", tags).attr("dynamic-tag-list-attr", true);
    }

    public DynamicPropertyBuilder customEditor(Object editor) {
        return this.attr("custom-editor-attr", editor);
    }

    public DynamicPropertyBuilder tags(Object tags) {
        return this.attr("tag-list-attr", tags);
    }

    public DynamicPropertyBuilder extraAttrs(Map<String, String> attrs) {
        return this.attr("extra-attrs-attr", attrs);
    }

    public DynamicPropertyBuilder extraAttr(String name, String value) {
        LinkedHashMap<String, String> attrs = (LinkedHashMap<String, String>)this.property.getAttribute("extra-attrs-attr");
        if (null == attrs) {
            attrs = new LinkedHashMap<String, String>();
        }
        attrs.put(name, value);
        return this.extraAttrs(attrs);
    }

    public DynamicPropertyBuilder onchange(String javascript) {
        return this.extraAttr("onchange", javascript);
    }

    public DynamicPropertyBuilder onclick(String javascript) {
        return this.extraAttr("onclick", javascript);
    }

    public DynamicPropertyBuilder placeholder(String text) {
        return this.extraAttr("placeholder", text);
    }

    public DynamicPropertyBuilder reloadOnChange() {
        return this.attr("reload-on-change", true);
    }

    public DynamicPropertyBuilder reloadOnClick() {
        return this.attr("reload-on-click", true);
    }

    public DynamicPropertyBuilder external(String tableFrom, String column, String tableTo) {
        return this.attr("external-tag-list", tableTo).attr("origEntity", tableFrom).attr("origName", column);
    }

    public DynamicPropertyBuilder autocomplete(String tableFrom, String column, String tableTo) {
        return this.attr("external-tag-list", tableTo).attr("origEntity", tableFrom).attr("origName", column).attr("use-autocomplete", true);
    }

    public DynamicPropertyBuilder select2(String tableFrom, String column, String tableTo) {
        return this.attr("external-tag-list", tableTo).attr("origEntity", tableFrom).attr("origName", column).attr("use-select2", true);
    }

    public DynamicPropertyBuilder select2() {
        return this.attr("use-select2", true);
    }

    public DynamicPropertyBuilder chosen() {
        return this.attr("use-chosen", true);
    }

    public DynamicPropertyBuilder externalTagList(String tableName) {
        return this.attr("external-tag-list", tableName);
    }

    public DynamicPropertyBuilder multiple() {
        return this.attr("multiple-selection-list", true);
    }

    public DynamicPropertyBuilder inputType(String type) {
        return this.attr("custom-input-type-attr", type);
    }

    public DynamicPropertyBuilder columnSize(int size) {
        return this.attr("column-size-attr", String.valueOf(size));
    }

    public DynamicPropertyBuilder size(int size) {
        return this.attr("input-size-attr", String.valueOf(size));
    }

    public DynamicPropertyBuilder groupId(String groupId) {
        return this.attr("group-id", groupId);
    }

    public DynamicPropertyBuilder groupName(String groupName) {
        return this.attr("group-name", groupName);
    }

    public DynamicPropertyBuilder group(String groupId, String groupName) {
        return this.groupId(groupId).groupName(groupName);
    }

    public DynamicPropertyBuilder group(String groupName) {
        return this.group(groupName, groupName);
    }

    public DynamicPropertyBuilder tabId(int tabId) {
        return this.attr("tab-id", tabId);
    }

    public DynamicPropertyBuilder tabName(String tabName) {
        return this.attr("tab-name", tabName);
    }

    public DynamicPropertyBuilder tab(int tabId, String tabName) {
        return this.tabId(tabId).tabName(tabName);
    }

    public DynamicPropertyBuilder rawValue(boolean rawValue) {
        return this.attr("raw-value", rawValue);
    }

    public DynamicPropertyBuilder rawValue() {
        return this.rawValue(true);
    }

    public DynamicPropertyBuilder rawValue(String value) {
        return this.rawValue().value(value);
    }

    public DynamicPropertyBuilder shortdesc(String desc) {
        this.property.setShortDescription(desc);
        return this;
    }

    public DynamicPropertyBuilder expert() {
        return this.expert(true);
    }

    public DynamicPropertyBuilder expert(boolean condition) {
        this.property.setExpert(condition);
        return this;
    }

    public DynamicPropertyBuilder parent(DynamicPropertySet parent) {
        this.property.setParent(parent);
        return this;
    }

    private void addToAttrMap(String attrName, Map<String, Object> map) {
        Map curMap = (Map)this.property.getAttribute(attrName);
        if (curMap == null) {
            this.property.setAttribute(attrName, new LinkedHashMap<String, Object>(map));
        } else {
            curMap.putAll(map);
        }
    }

    public DynamicPropertyBuilder type(Class<?> clazz) {
        this.property.setType(clazz);
        return this;
    }

    public DynamicProperty get() {
        return this.property;
    }
}

