/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DynamicProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DynamicPropertySet parent;
    public static final String XML_ELEMENT_NAME = "xml-element-name";
    public static final String XML_IGNORE = "xml-ignore";
    public static final String XML_NAMESPACE = "xml-name-space";
    public static final String XML_ATTRIBUTES = "xml-attributes";
    public static final String XML_ATTRIBUTES_ARRAY = "xml-attributes-array";
    private static final String[] digits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    protected transient PropertyDescriptor descriptor;
    String localName = null;
    String localDisplayName = null;
    String localShortDescription = null;
    Class<?> type;
    protected Object value;
    private HashMap<String, Object> localAttrs = null;
    private static Set<String> emptySet = Collections.emptySet();
    private boolean localHidden = false;
    private boolean localExpert = false;

    public static Object reuseValue(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String vals = (String)value;
        if (vals.length() == 1 && Character.isDigit(vals.charAt(0))) {
            return digits[vals.charAt(0) - 48];
        }
        for (String sval : new String[]{"no", "yes", ".js", ".css", "Filter", "Java", "Java and .Net", "1D", "1D_unknown", "All records", "*** Selection view ***", "Insert", "Edit", "Clone", "Delete", "male", "female"}) {
            if (!sval.equals(value)) continue;
            return sval;
        }
        return value;
    }

    public DynamicProperty(String name, Class<?> type) {
        this(name, null, null, type, null);
    }

    public DynamicProperty(PropertyDescriptor descriptor, Class<?> type) {
        this(descriptor, type, null);
    }

    public DynamicProperty(String name, Class<?> type, Object value) {
        this(name, null, null, type, value);
    }

    public DynamicProperty(String name, String displayName, Class<?> type) {
        this(name, displayName, null, type, null);
    }

    public DynamicProperty(String name, String displayName, String shortDesc, Class<?> type) {
        this(name, displayName, shortDesc, type, null);
    }

    public DynamicProperty(String name, String displayName, Class<?> type, Object value) {
        this(name, displayName, null, type, value);
    }

    public DynamicProperty(String name, String displayName, String shortDesc, Class<?> type, Object value) {
        this.localName = name;
        this.type = type;
        this.value = DynamicProperty.reuseValue(value);
        this.setDisplayName(displayName);
        this.setShortDescription(shortDesc);
    }

    public DynamicProperty(PropertyDescriptor descriptor, Class<?> type, Object value) {
        this.descriptor = descriptor;
        this.type = type;
        this.value = DynamicProperty.reuseValue(value);
    }

    public boolean hasDescriptor() {
        return this.descriptor != null;
    }

    public PropertyDescriptor getDescriptor() {
        if (this.descriptor == null) {
            try {
                this.descriptor = new PropertyDescriptor(this.localName, null, null);
                this.descriptor.setDisplayName(this.localDisplayName);
                this.descriptor.setShortDescription(this.localShortDescription);
                this.descriptor.setExpert(this.localExpert);
                this.descriptor.setHidden(this.localHidden);
                if (this.localAttrs != null) {
                    for (Map.Entry<String, Object> entry : this.localAttrs.entrySet()) {
                        this.descriptor.setValue(entry.getKey(), entry.getValue());
                    }
                }
                this.localName = null;
                this.localDisplayName = null;
                this.localShortDescription = null;
                this.localAttrs = null;
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.descriptor;
    }

    public void setDescriptor(PropertyDescriptor desc) {
        this.localName = null;
        this.localDisplayName = null;
        this.localShortDescription = null;
        this.descriptor = desc;
    }

    public String getName() {
        if (this.descriptor != null) {
            return this.descriptor.getName();
        }
        return this.localName;
    }

    public void setName(String name) {
        if (this.descriptor != null) {
            this.descriptor.setName(name);
        }
        this.localName = name;
    }

    public String getDisplayName() {
        if (this.descriptor != null) {
            return this.descriptor.getDisplayName();
        }
        return this.localDisplayName == null ? this.localName : this.localDisplayName;
    }

    public void setDisplayName(String name) {
        if (this.descriptor != null) {
            this.descriptor.setDisplayName(name);
        }
        this.localDisplayName = name != null && name.equals(this.localName) ? null : name;
    }

    public String getShortDescription() {
        if (this.descriptor != null) {
            return this.descriptor.getShortDescription();
        }
        return this.localShortDescription == null ? this.getDisplayName() : this.localShortDescription;
    }

    public void setShortDescription(String shortDesc) {
        if (this.descriptor != null) {
            this.descriptor.setShortDescription(shortDesc);
        }
        this.localShortDescription = shortDesc != null && shortDesc.equals(this.getDisplayName()) ? null : shortDesc;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        Object oldValue = this.value;
        this.value = DynamicProperty.reuseValue(value);
        if (this.parent != null) {
            this.parent.firePropertyChange(this.getName(), oldValue, this.value);
        }
    }

    public Object getAttribute(String attrName) {
        if (this.descriptor != null) {
            return this.descriptor.getValue(attrName);
        }
        if (this.localAttrs != null) {
            return this.localAttrs.get(attrName);
        }
        return null;
    }

    public boolean getBooleanAttribute(String attrName) {
        Object val = this.getAttribute(attrName);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    public String getStringAttribute(String attrName) {
        Object val = this.getAttribute(attrName);
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    public void setAttribute(String attrName, Object attrValue) {
        attrValue = DynamicProperty.reuseValue(attrValue);
        if (this.descriptor != null) {
            this.descriptor.setValue(attrName, attrValue);
            return;
        }
        if (this.localAttrs == null) {
            this.localAttrs = new HashMap();
        }
        this.localAttrs.put(attrName, attrValue);
    }

    public Enumeration<String> attributeNames() {
        if (this.descriptor != null) {
            return this.descriptor.attributeNames();
        }
        if (this.localAttrs == null) {
            return Collections.enumeration(emptySet);
        }
        return Collections.enumeration(this.localAttrs.keySet());
    }

    public boolean isHidden() {
        if (this.descriptor != null) {
            return this.descriptor.isHidden();
        }
        return this.localHidden;
    }

    public void setHidden(boolean hidden) {
        if (this.descriptor != null) {
            this.descriptor.setHidden(hidden);
        }
        this.localHidden = hidden;
    }

    public boolean isExpert() {
        if (this.descriptor != null) {
            return this.descriptor.isExpert();
        }
        return this.localExpert;
    }

    public void setExpert(boolean expert) {
        if (this.descriptor != null) {
            this.descriptor.setExpert(expert);
        }
        this.localExpert = expert;
    }

    public boolean isReadOnly() {
        Object attr = this.getAttribute("read-only");
        return attr != null && Boolean.TRUE.equals(attr);
    }

    public void setReadOnly(boolean value) {
        this.setAttribute("read-only", value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isCanBeNull() {
        Object attr = this.getAttribute("can-be-null");
        return attr != null && Boolean.TRUE.equals(attr);
    }

    public void setCanBeNull(boolean value) {
        this.setAttribute("can-be-null", value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void resetTagList(Object tagList) {
        this.setAttribute("tag-list-attr", tagList);
        if (this.getAttribute("external-tag-list") != null) {
            this.setAttribute("external-tag-list", "");
        }
    }

    public DynamicPropertySet getParent() {
        return this.parent;
    }

    public void setParent(DynamicPropertySet parent) {
        this.parent = parent;
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.setName((String)aStream.readObject());
        aStream.readObject();
        aStream.readObject();
        aStream.readBoolean();
        aStream.readBoolean();
        String dispName = (String)aStream.readObject();
        this.setExpert(aStream.readBoolean());
        this.setHidden(aStream.readBoolean());
        this.setDisplayName(dispName);
        aStream.readBoolean();
        aStream.readObject();
        this.setShortDescription((String)aStream.readObject());
        String attribute = (String)aStream.readObject();
        while (!attribute.equals("")) {
            Object value = aStream.readObject();
            this.setAttribute(attribute, value);
            attribute = (String)aStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.defaultWriteObject();
        aStream.writeObject(this.getName());
        aStream.writeObject(null);
        aStream.writeObject(null);
        aStream.writeBoolean(false);
        aStream.writeBoolean(false);
        aStream.writeObject(this.getDisplayName());
        aStream.writeBoolean(this.isExpert());
        aStream.writeBoolean(this.isHidden());
        aStream.writeBoolean(false);
        aStream.writeObject(null);
        aStream.writeObject(this.getShortDescription());
        Enumeration<String> attributeNames = this.attributeNames();
        while (attributeNames.hasMoreElements()) {
            String attribute = attributeNames.nextElement();
            aStream.writeObject(attribute);
            aStream.writeObject(this.getAttribute(attribute));
        }
        aStream.writeObject("");
    }

    public void setAttributeToAllChildren(String attrName, Object attrValue) throws Exception {
        Object value = this.getValue();
        if (value instanceof DynamicPropertySetSupport) {
            ((DynamicPropertySetSupport)value).setAttributeToAllChildren(attrName, attrValue);
        } else if (value instanceof DynamicPropertySetSupport[]) {
            for (DynamicPropertySetSupport propBean : (DynamicPropertySetSupport[])value) {
                propBean.setAttributeToAllChildren(attrName, attrValue);
            }
        }
    }

    public void setAttributeToAllChildrenIfEmpty(String attrName, Object attrValue) throws Exception {
        Object value = this.getValue();
        if (value instanceof DynamicPropertySetSupport) {
            ((DynamicPropertySetSupport)value).setAttributeToAllChildrenIfEmpty(attrName, attrValue);
        } else if (value instanceof DynamicPropertySetSupport[]) {
            for (DynamicPropertySetSupport propBean : (DynamicPropertySetSupport[])value) {
                propBean.setAttributeToAllChildrenIfEmpty(attrName, attrValue);
            }
        }
    }

    public void NS(Object value) throws Exception {
        this.setAttribute(XML_NAMESPACE, value);
    }

    public void childrenNS(Object value) throws Exception {
        this.setAttributeToAllChildrenIfEmpty(XML_NAMESPACE, value);
    }

    protected Object[] getOtherArray(Object dpValue) {
        return null;
    }

    protected String getNamespace() {
        Object ns = this.getAttribute(XML_NAMESPACE);
        if (ns == null) {
            return "";
        }
        return ns.toString() + ":";
    }

    public String serializeAsXml(String offset) {
        String retXml = "";
        try {
            if (this.getAttribute(XML_IGNORE) != null) {
                return retXml;
            }
            Object dpValue = this.getValue();
            String elementName = this.getName();
            if (this.getAttribute(XML_ELEMENT_NAME) != null) {
                elementName = this.getAttribute(XML_ELEMENT_NAME).toString();
            }
            elementName = this.getNamespace() + elementName;
            if (dpValue == null || dpValue instanceof String && "".equals(((String)dpValue).trim())) {
                retXml = retXml + "\n" + offset + "<" + elementName + this.serializeAsXmlAttributes() + "/>";
            } else {
                Object[] otherArray = null;
                if (dpValue instanceof DynamicPropertySet) {
                    retXml = retXml + "\n" + offset + "<" + elementName + this.serializeAsXmlAttributes() + ">";
                    for (DynamicProperty dp : (DynamicPropertySet)dpValue) {
                        retXml = retXml + dp.serializeAsXml("   " + offset);
                    }
                    retXml = retXml + "\n" + offset + "</" + elementName + ">";
                } else if (dpValue instanceof DynamicPropertySet[]) {
                    DynamicPropertySet[] arrp = (DynamicPropertySet[])dpValue;
                    DynamicPropertySet[] arratt = (DynamicPropertySet[])this.getAttribute(XML_ATTRIBUTES_ARRAY);
                    if (arratt == null) {
                        arratt = new DynamicPropertySet[arrp.length];
                    }
                    for (int i = 0; i < arrp.length; ++i) {
                        DynamicPropertySet dps = arrp[i];
                        retXml = retXml + "\n" + offset + "<" + elementName + this.serializeAsXmlAttributesCommon(i < arratt.length ? arratt[i] : null) + ">";
                        for (DynamicProperty dp : dps) {
                            retXml = retXml + dp.serializeAsXml("   " + offset);
                        }
                        retXml = retXml + "\n" + offset + "</" + elementName + ">";
                    }
                } else {
                    otherArray = this.getOtherArray(dpValue);
                    if (otherArray != null) {
                        for (Object scr : otherArray) {
                            String value = scr.toString();
                            value = value.replace("\\", "\\\\");
                            value = value.replace("\"", "\\\"");
                            value = value.replace("&", "&amp;");
                            value = value.replace(">", "&gt;");
                            value = value.replace("<", "&lt;");
                            retXml = retXml + "\n" + offset + "<" + elementName + this.serializeAsXmlAttributes() + ">" + value + "</" + elementName + ">";
                        }
                    } else if (dpValue instanceof Object[]) {
                        for (Object obj : (Object[])dpValue) {
                            String value = obj.toString().replace("\\", "\\\\");
                            value = value.replace("\"", "\\\"");
                            value = value.replace("&", "&amp;");
                            value = value.replace(">", "&gt;");
                            value = value.replace("<", "&lt;");
                            retXml = retXml + "\n" + offset + "<" + elementName + this.serializeAsXmlAttributes() + ">" + value + "</" + elementName + ">";
                        }
                    } else {
                        String value = dpValue.toString().replace("\\", "\\\\");
                        value = value.replace("\"", "\\\"");
                        value = value.replace("&", "&amp;");
                        value = value.replace(">", "&gt;");
                        value = value.replace("<", "&lt;");
                        retXml = retXml + "\n" + offset + "<" + elementName + this.serializeAsXmlAttributes() + ">" + value + "</" + elementName + ">";
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retXml;
    }

    public String serializeAsXmlAttributes() {
        return this.serializeAsXmlAttributesCommon((DynamicPropertySet)this.getAttribute(XML_ATTRIBUTES));
    }

    public String serializeAsXmlAttributesCommon(DynamicPropertySet attrs) {
        if (attrs == null) {
            return "";
        }
        String result = "";
        for (DynamicProperty attr : attrs) {
            if (attr.getValue() != null && !"".equals(attr.getValue().toString().trim())) {
                String val = attr.getValue().toString().replace("'", "&apos;");
                val = val.replace("\"", "&quot;");
                result = result + " " + attr.getName() + "=\"" + val + "\"";
                continue;
            }
            result = result + " " + attr.getName() + "=\"\"";
        }
        return result;
    }

    public String toString() {
        return "name: " + this.getName() + ", type:" + this.type + ", value: " + this.value;
    }
}

