/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DPSProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private final DynamicPropertySet dps;

    public DPSProperties(DynamicPropertySet dps) {
        this.dps = dps;
    }

    @Override
    public synchronized void clear() {
        Iterator<String> nameIterator = this.dps.nameIterator();
        ArrayList<String> names = new ArrayList<String>();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        for (String name : names) {
            this.dps.remove(name);
        }
    }

    @Override
    public synchronized Object clone() {
        return new DPSProperties((DynamicPropertySet)this.dps.clone());
    }

    @Override
    public synchronized boolean contains(Object element) {
        Iterator<DynamicProperty> iterator = this.dps.propertyIterator();
        while (iterator.hasNext()) {
            DynamicProperty property = iterator.next();
            try {
                if (!property.getValue().equals(element)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object elementName) {
        return this.dps.getProperty(elementName.toString()) != null;
    }

    @Override
    public boolean containsValue(Object element) {
        return this.contains(element);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        return Collections.enumeration(this.asMap().values());
    }

    private Map<Object, Object> asMap() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Iterator<DynamicProperty> iterator = this.dps.propertyIterator();
        while (iterator.hasNext()) {
            DynamicProperty property = iterator.next();
            result.put(property.getName(), property.getValue());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.asMap().entrySet();
    }

    @Override
    public synchronized Object get(Object elementName) {
        return this.dps.getValue(elementName.toString());
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.dps.isEmpty();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.asMap().keySet());
    }

    @Override
    public Set<Object> keySet() {
        return this.asMap().keySet();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        DynamicProperty property = this.dps.getProperty(key.toString());
        if (property == null) {
            property = new DynamicProperty(key.toString(), value == null ? String.class : value.getClass(), value);
            this.dps.add(property);
            return null;
        }
        Object oldValue = property.getValue();
        property.setValue(value);
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
        map.forEach(this::put);
    }

    @Override
    public synchronized Object remove(Object key) {
        Object obj = this.dps.getValue(key.toString());
        this.dps.remove(key.toString());
        return obj;
    }

    @Override
    public synchronized int size() {
        return this.dps.size();
    }

    @Override
    public Collection<Object> values() {
        return this.asMap().values();
    }

    @Override
    public String getProperty(String key) {
        Object oval = this.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }
}

