/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.BeanInfoConstants;
import com.developmentontheedge.beans.IconResource;
import com.developmentontheedge.beans.PropertyDescriptorEx;
import com.developmentontheedge.beans.StubMessageBundle;
import com.developmentontheedge.beans.annot.ExpertProperty;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.editors.StringTagEditor;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.util.HtmlUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Stream;

public class BeanInfoEx
extends SimpleBeanInfo
implements BeanInfoConstants {
    public static final String HTML_DESCRIPTION_PROPERTY = "htmlDescription";
    protected Class<?> beanClass;
    protected BeanDescriptor beanDescriptor;
    protected ResourceBundle resources = null;
    protected ResourceBundle childResources = null;
    protected static ResourceBundle parentResources = null;
    protected Vector<PropertyDescriptor> properties = new Vector();
    protected Method displayNameMethod = null;
    protected String helpId = null;
    protected Boolean hidden = null;
    protected Boolean substituteByChild = null;
    protected Boolean readOnly = null;
    protected Boolean hideChildren = null;
    protected Boolean simple = null;
    protected Boolean noRecursionCheck = null;
    protected Class<?> beanEditorClass;
    protected String compositeEditorPropertyList;
    protected LayoutManager compositeEditorLayoutManager;
    protected Dimension editorPreferredSize;

    public BeanInfoEx(Class<?> beanClass) {
        this(beanClass, beanClass.getName() + "MessageBundle");
    }

    public BeanInfoEx(Class<?> beanClass, boolean stubResource) {
        this(beanClass, stubResource ? StubMessageBundle.class.getName() : beanClass.getName() + "MessageBundle");
    }

    public BeanInfoEx(Class<?> beanClass, String resourceBundleName) {
        ExpertProperty expertProperty;
        PropertyDescription propertyDescription;
        boolean ourHack;
        this.beanClass = beanClass;
        this.initResources(resourceBundleName);
        this.beanDescriptor = new BeanDescriptor(beanClass);
        String className = this.getClass().getName();
        String beanClassName = beanClass.getName();
        String bareName = beanClassName.substring(beanClassName.lastIndexOf(".") + 1);
        boolean bl = ourHack = className.equals("com.developmentontheedge.beans.swing.infos." + bareName + "BeanInfo") || className.equals("com.developmentontheedge.beans.awt.infos." + bareName + "BeanInfo");
        if (!className.startsWith(beanClassName) && !ourHack) {
            this.logError("Bean class \"" + beanClassName + "\" mismatch BeanInfo \"" + className + "\" class!");
        }
        try {
            this.initProperties();
        }
        catch (Exception e) {
            this.logError("Can not initialize properties", e);
        }
        PropertyName propertyName = beanClass.getAnnotation(PropertyName.class);
        if (propertyName != null) {
            this.beanDescriptor.setDisplayName(this.convertString(propertyName.value()));
        }
        if ((propertyDescription = beanClass.getAnnotation(PropertyDescription.class)) != null) {
            BeanInfoEx.setHtmlDescription(this.beanDescriptor, this.convertString(propertyDescription.value()));
        }
        if ((expertProperty = beanClass.getAnnotation(ExpertProperty.class)) != null) {
            this.beanDescriptor.setExpert(true);
        }
    }

    private static void setHtmlDescription(FeatureDescriptor descriptor, String description) {
        String textDescription = HtmlUtil.stripHtml(description);
        if (!textDescription.equals(description)) {
            descriptor.setValue(HTML_DESCRIPTION_PROPERTY, description);
        }
        descriptor.setShortDescription(textDescription);
    }

    private String convertString(String value) {
        if (value == null) {
            return null;
        }
        CharSequence[] fields = value.split("\\$");
        for (int i = 0; i < fields.length; ++i) {
            if (i % 2 == 0) continue;
            try {
                fields[i] = this.beanClass.getField((String)fields[i]).get(this.beanClass).toString();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.join((CharSequence)"", fields);
    }

    protected BeanInfoEx() {
    }

    @Override
    public Image getIcon(int iconKind) {
        Object res = null;
        switch (iconKind) {
            case 1: {
                res = this.getBeanDescriptor().getValue("node-icon: color16x16");
                break;
            }
            case 3: {
                res = this.getBeanDescriptor().getValue("node-icon: mono16x16");
                break;
            }
            case 2: {
                res = this.getBeanDescriptor().getValue("node-icon: color32x32");
                break;
            }
            case 4: {
                res = this.getBeanDescriptor().getValue("node-icon: mono32x32");
            }
        }
        if (res != null) {
            if (res instanceof IconResource) {
                return ((IconResource)res).getImage();
            }
            if (res instanceof Image) {
                return (Image)res;
            }
        }
        return super.getIcon(iconKind);
    }

    protected void initProperties() throws Exception {
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties.toArray(new PropertyDescriptor[this.properties.size()]);
    }

    private void annotate(PropertyDescriptor pd) {
        Method readMethod;
        PropertyName propertyName = null;
        PropertyDescription propertyDescription = null;
        ExpertProperty expertProperty = null;
        Method writeMethod = pd.getWriteMethod();
        if (writeMethod != null) {
            propertyName = writeMethod.getAnnotation(PropertyName.class);
            propertyDescription = writeMethod.getAnnotation(PropertyDescription.class);
            expertProperty = writeMethod.getAnnotation(ExpertProperty.class);
        }
        if ((readMethod = pd.getReadMethod()) != null) {
            propertyName = readMethod.getAnnotation(PropertyName.class);
            propertyDescription = readMethod.getAnnotation(PropertyDescription.class);
            expertProperty = readMethod.getAnnotation(ExpertProperty.class);
        }
        if (propertyName != null) {
            pd.setDisplayName(this.convertString(propertyName.value()));
        }
        if (propertyDescription != null) {
            BeanInfoEx.setHtmlDescription(pd, this.convertString(propertyDescription.value()));
        }
        if (expertProperty != null) {
            pd.setExpert(true);
        }
    }

    public void add(PropertyDescriptor pd) {
        this.properties.add(pd);
        this.annotate(pd);
    }

    public void add(int index, PropertyDescriptor pd) {
        this.properties.add(index, pd);
        this.annotate(pd);
    }

    public void add(PropertyDescriptor pd, String displayName, String description) {
        this.add(this.properties.size(), pd, displayName, description);
    }

    public void add(int index, PropertyDescriptor pd, String displayName, String description) {
        pd.setDisplayName(displayName);
        if (description != null) {
            pd.setShortDescription(description);
        }
        this.add(index, pd);
    }

    public void add(PropertyDescriptor pd, Class<?> propertyEditor) {
        this.add(this.properties.size(), pd, propertyEditor);
    }

    public void add(int index, PropertyDescriptor pd, Class<?> propertyEditor) {
        pd.setPropertyEditorClass(propertyEditor);
        this.add(index, pd);
    }

    public void add(PropertyDescriptor pd, Class<?> propertyEditor, String displayName, String description) {
        this.add(this.properties.size(), pd, propertyEditor, displayName, description);
    }

    public void add(int index, PropertyDescriptor pd, Class<?> propertyEditor, String displayName, String description) {
        pd.setDisplayName(displayName);
        pd.setPropertyEditorClass(propertyEditor);
        if (description != null) {
            pd.setShortDescription(description);
        }
        this.add(index, pd);
    }

    public void addHidden(PropertyDescriptor pd) {
        pd.setHidden(true);
        this.add(pd);
    }

    public void addHidden(PropertyDescriptor pd, Class<?> propertyEditor) {
        pd.setPropertyEditorClass(propertyEditor);
        pd.setHidden(true);
        this.add(pd);
    }

    public int findPropertyIndex(String programmaticName) {
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyDescriptor pd = this.properties.elementAt(i);
            if (!pd.getName().equals(programmaticName)) continue;
            return i;
        }
        return this.properties.size();
    }

    public PropertyDescriptor findPropertyDescriptor(String programmaticName) {
        for (PropertyDescriptor pd : this.properties) {
            if (!pd.getName().equals(programmaticName)) continue;
            return pd;
        }
        return null;
    }

    public void setDisplayNameMethod(Method method) {
        this.displayNameMethod = method;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setSubstituteByChild(boolean substituteByChild) {
        this.substituteByChild = substituteByChild;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setHideChildren(boolean hide) {
        this.hideChildren = hide;
    }

    public void setSimple(boolean value) {
        this.simple = value;
    }

    public void setNoRecursionCheck(boolean noRecursionCheck) {
        this.noRecursionCheck = noRecursionCheck;
    }

    public void setBeanEditor(Class<?> editorClass) {
        this.beanEditorClass = editorClass;
    }

    public void setCompositeEditor(String propertyList, LayoutManager layoutManager) {
        this.compositeEditorPropertyList = propertyList;
        this.compositeEditorLayoutManager = layoutManager;
    }

    public void setEditorPreferredSize(Dimension editorPreferredSize) {
        this.editorPreferredSize = editorPreferredSize;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        if (this.beanEditorClass != null) {
            BeanDescriptor bd = new BeanDescriptor(this.beanClass, this.beanEditorClass);
            bd.setDisplayName(this.beanDescriptor.getDisplayName());
            bd.setShortDescription(this.beanDescriptor.getShortDescription());
            this.beanDescriptor = bd;
        }
        if (this.displayNameMethod != null) {
            this.beanDescriptor.setValue("beanDisplayNameMethod", this.displayNameMethod);
        }
        if (this.hidden != null) {
            this.beanDescriptor.setHidden(this.hidden);
        }
        if (this.substituteByChild != null) {
            this.beanDescriptor.setValue("substitute-by-child", this.substituteByChild);
        }
        if (this.noRecursionCheck != null) {
            this.beanDescriptor.setValue("node-no-recursion-check", this.noRecursionCheck);
        }
        if (this.helpId != null) {
            this.beanDescriptor.setValue("help-id", this.helpId);
        }
        if (this.simple != null) {
            this.beanDescriptor.setValue("node-simple", this.simple);
        }
        if (this.hideChildren != null) {
            this.beanDescriptor.setValue("hide-children", this.hideChildren);
        }
        if (this.editorPreferredSize != null) {
            this.beanDescriptor.setValue("layout: preferred-size", this.editorPreferredSize);
        }
        if (this.compositeEditorPropertyList != null) {
            this.beanDescriptor.setValue("composite-editor: property list", this.compositeEditorPropertyList);
        }
        if (this.compositeEditorLayoutManager != null) {
            this.beanDescriptor.setValue("composite-editor: layout manager", this.compositeEditorLayoutManager);
        }
        PropertyDescriptor[] props = this.getPropertyDescriptors();
        this.beanDescriptor.setValue("properties-order", props);
        if (this.readOnly != null && Boolean.TRUE.equals(this.readOnly)) {
            this.beanDescriptor.setValue("read-only", this.readOnly);
            for (int i = 0; i < props.length; ++i) {
                props[i].setValue("read-only", this.readOnly);
            }
        }
        return this.beanDescriptor;
    }

    public String getResourceString(String key) {
        try {
            return this.resources.getString(key);
        }
        catch (Throwable t) {
            this.logError("Missing resource <" + key + "> in " + this.beanClass);
            return key;
        }
    }

    protected void initResources(String resourceBundleName) {
        try {
            if (resourceBundleName == null) {
                this.childResources = this.resources = parentResources;
                return;
            }
            ClassLoader cl = this.beanClass.getClassLoader();
            ResourceBundle resourceBundle = this.childResources = cl != null ? ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl) : ResourceBundle.getBundle(resourceBundleName, Locale.getDefault());
            if (parentResources == null) {
                this.resources = this.childResources;
                return;
            }
            this.resources = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) throws MissingResourceException {
                    try {
                        return BeanInfoEx.this.childResources.getObject(key);
                    }
                    catch (MissingResourceException e) {
                        MissingResourceException mre = e;
                        try {
                            return parentResources.getObject(key);
                        }
                        catch (MissingResourceException missingResourceException) {
                            throw mre;
                        }
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    Enumeration<String> result = new Enumeration<String>(){
                        final Enumeration<String> childKeys;
                        final Enumeration<String> parentKeys;
                        String temp;
                        {
                            this.childKeys = BeanInfoEx.this.childResources.getKeys();
                            this.parentKeys = parentResources.getKeys();
                            this.temp = null;
                        }

                        @Override
                        public boolean hasMoreElements() {
                            if (this.temp == null) {
                                this.nextElement();
                            }
                            return this.temp != null;
                        }

                        @Override
                        public String nextElement() {
                            String returnVal = this.temp;
                            if (this.childKeys.hasMoreElements()) {
                                this.temp = this.childKeys.nextElement();
                                return returnVal;
                            }
                            this.temp = null;
                            while (this.temp == null && this.parentKeys.hasMoreElements()) {
                                this.temp = this.parentKeys.nextElement();
                                try {
                                    BeanInfoEx.this.childResources.getObject(this.temp);
                                    this.temp = null;
                                }
                                catch (MissingResourceException missingResourceException) {}
                            }
                            return returnVal;
                        }
                    };
                    return result;
                }
            };
        }
        catch (MissingResourceException mre) {
            this.logError("Resource '" + resourceBundleName + "' can not be initilized", mre);
        }
    }

    protected void logError(String message, Throwable t) {
        Logger.getLogger().error(message, t);
    }

    protected void logError(String message) {
        this.logError(message, null);
    }

    public PropertyDescriptorBuilder property(String name) {
        return new PropertyDescriptorBuilder(name);
    }

    public PropertyDescriptorBuilder property(PropertyDescriptorEx pd) {
        return new PropertyDescriptorBuilder(pd);
    }

    public void add(String name) {
        this.property(name).add();
    }

    public void addWithTags(String name, String ... tags) {
        this.property(name).tags(tags).add();
    }

    public void addWithTags(PropertyDescriptorEx pd, String ... tags) {
        this.property(pd).tags(tags).add();
    }

    public void add(String name, Class<?> editor) throws IntrospectionException {
        this.add(new PropertyDescriptorEx(name, this.beanClass), editor);
    }

    public void addHidden(String name) throws IntrospectionException {
        PropertyDescriptorEx pd = new PropertyDescriptorEx(name, this.beanClass);
        pd.setHidden(true);
        this.add(pd);
    }

    public void addExpert(String name) throws IntrospectionException {
        PropertyDescriptorEx pd = new PropertyDescriptorEx(name, this.beanClass);
        pd.setExpert(true);
        this.add(pd);
    }

    public void addExpert(String name, Class<?> editor) throws IntrospectionException {
        PropertyDescriptorEx pd = new PropertyDescriptorEx(name, this.beanClass);
        pd.setExpert(true);
        this.add(pd, editor);
    }

    public void addHidden(PropertyDescriptorEx pde, String hiddenMethodName) throws SecurityException, NoSuchMethodException {
        pde.setHidden(this.beanClass.getMethod(hiddenMethodName, new Class[0]));
        this.add(pde);
    }

    public void addHidden(PropertyDescriptorEx pde, Class<?> editor, String hiddenMethodName) throws SecurityException, NoSuchMethodException {
        pde.setHidden(this.beanClass.getMethod(hiddenMethodName, new Class[0]));
        this.add(pde, editor);
    }

    public void addHidden(String name, String hiddenMethodName) throws SecurityException, NoSuchMethodException, IntrospectionException {
        this.addHidden(new PropertyDescriptorEx(name, this.beanClass), hiddenMethodName);
    }

    public void addReadOnly(String name, String readOnlyMethodName) throws SecurityException, NoSuchMethodException, IntrospectionException {
        this.addReadOnly(new PropertyDescriptorEx(name, this.beanClass), readOnlyMethodName);
    }

    public void addReadOnly(PropertyDescriptorEx pde, String readOnlyMethodName) throws SecurityException, NoSuchMethodException {
        pde.setReadOnly(this.beanClass.getMethod(readOnlyMethodName, new Class[0]));
        this.add(pde);
    }

    public void addHidden(String name, Class<?> editor, String hiddenMethodName) throws SecurityException, NoSuchMethodException, IntrospectionException {
        this.addHidden(new PropertyDescriptorEx(name, this.beanClass), editor, hiddenMethodName);
    }

    public class PropertyDescriptorBuilder {
        protected final PropertyDescriptorEx pd;

        public PropertyDescriptorBuilder(String name) {
            try {
                this.pd = new PropertyDescriptorEx(name, BeanInfoEx.this.beanClass);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }

        public PropertyDescriptorBuilder(PropertyDescriptorEx pd) {
            this.pd = pd;
        }

        public void add() {
            BeanInfoEx.this.add(this.pd);
        }

        protected PropertyDescriptorBuilder tagsFunction(Function<Object, Stream<String>> tagsSupplier) {
            this.pd.setValue("tagSupplierFunction", tagsSupplier);
            this.pd.setPropertyEditorClass(LambdaTagEditor.class);
            return this;
        }

        public PropertyDescriptorBuilder tags(String ... tags) {
            return this.tagsFunction(bean -> Stream.of(tags));
        }

        public PropertyDescriptorBuilder editor(Class<?> editor) {
            this.pd.setPropertyEditorClass(editor);
            return this;
        }

        public PropertyDescriptorBuilder title(String title) {
            this.pd.setDisplayName(BeanInfoEx.this.getResourceString(title));
            return this;
        }

        public PropertyDescriptorBuilder description(String description) {
            this.pd.setShortDescription(BeanInfoEx.this.getResourceString(description));
            return this;
        }

        public PropertyDescriptorBuilder titleRaw(String title) {
            this.pd.setDisplayName(title);
            return this;
        }

        public PropertyDescriptorBuilder descriptionRaw(String description) {
            this.pd.setShortDescription(description);
            return this;
        }

        public PropertyDescriptorBuilder numberFormat(String pattern) {
            this.pd.setNumberFormat(pattern);
            return this;
        }

        public PropertyDescriptorBuilder hidden() {
            this.pd.setHidden(true);
            return this;
        }

        public PropertyDescriptorBuilder expert() {
            this.pd.setExpert(true);
            return this;
        }

        public PropertyDescriptorBuilder readOnly() {
            this.pd.setReadOnly(true);
            return this;
        }

        public PropertyDescriptorBuilder canBeNull() {
            this.pd.setCanBeNull(true);
            return this;
        }

        public PropertyDescriptorBuilder hidden(String methodName) {
            try {
                this.pd.setHidden(BeanInfoEx.this.beanClass.getMethod(methodName, new Class[0]));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public PropertyDescriptorBuilder readOnly(String methodName) {
            try {
                this.pd.setReadOnly(BeanInfoEx.this.beanClass.getMethod(methodName, new Class[0]));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public PropertyDescriptorBuilder simple() {
            this.pd.setSimple(true);
            return this;
        }
    }

    public static final class LambdaTagEditor
    extends StringTagEditor {
        protected static final String TAG_SUPPLIER_FUNCTION = "tagSupplierFunction";

        @Override
        public String[] getTags() {
            Function fn = (Function)this.getDescriptor().getValue(TAG_SUPPLIER_FUNCTION);
            Stream stream = (Stream)fn.apply(this.getBean());
            return stream == null ? new String[]{} : (String[])stream.toArray(String[]::new);
        }
    }
}

