/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans;

import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertyBuilder;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.StringTokenizer;

public abstract class AbstractDynamicPropertySet
implements DynamicPropertySet {
    private static final long serialVersionUID = 1L;
    protected PropertyChangeSupport pcSupport = null;

    protected abstract DynamicProperty findProperty(String var1);

    @Override
    public Iterator<DynamicProperty> iterator() {
        return this.propertyIterator();
    }

    @Override
    public Object getValue(String name) {
        DynamicProperty property = this.findProperty(name);
        return property != null ? property.getValue() : null;
    }

    @Override
    public String getValueAsString(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public Long getValueAsLong(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        return Long.parseLong(val.toString());
    }

    @Override
    public <T> T cast(String name, Class<T> clazz) {
        return clazz.cast(this.getValue(name));
    }

    @Override
    public DynamicProperty getProperty(String name) {
        return this.findProperty(name);
    }

    public DynamicProperty retrieveProperty(String name) {
        StringTokenizer st = new StringTokenizer(name, "./");
        if (st.countTokens() > 1) {
            AbstractDynamicPropertySet bean = this;
            DynamicProperty ret = null;
            while (st.hasMoreTokens()) {
                String propName = st.nextToken();
                if (ret != null) {
                    DynamicPropertySet dynamicPropertySet = bean = ret.getValue() instanceof DynamicPropertySet ? (DynamicPropertySet)ret.getValue() : null;
                }
                if (bean != null) {
                    ret = bean.getProperty(propName);
                    continue;
                }
                return null;
            }
            return ret;
        }
        return this.findProperty(name);
    }

    public String retrieveStringValue(String name) {
        DynamicProperty prop = this.retrieveProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue().toString();
    }

    @Override
    public DynamicPropertyBuilder getAsBuilder(String name) {
        return new DynamicPropertyBuilder(this.findProperty(name));
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException c) {
            throw new InternalError();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent evt) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(evt);
        }
    }

    @Override
    public boolean hasListeners(String propertyName) {
        if (this.pcSupport == null) {
            return false;
        }
        return this.pcSupport.hasListeners(propertyName);
    }

    @Override
    public Class<?> getType(String name) {
        DynamicProperty property = this.findProperty(name);
        return property != null ? property.getType() : null;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        DynamicProperty property = this.findProperty(name);
        if (property != null) {
            return property.getDescriptor();
        }
        return null;
    }

    @Override
    public void setPropertyAttribute(String propName, String attrName, Object attrValue) {
        DynamicProperty property = this.findProperty(propName);
        if (property != null) {
            property.setAttribute(attrName, attrValue);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void setValue(String name, Object value) {
        DynamicProperty property = this.findProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Property \"" + name + "\" not found");
        }
        Object oldValue = property.getValue();
        property.setValue(value);
        if (this.hasListeners(name)) {
            this.firePropertyChange(new PropertyChangeEvent(this, name, oldValue, value));
        }
    }

    protected static String makeJSONPropName(String name) {
        return "\"" + name + "\"";
    }

    public static String makeJSONStringValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len * 2);
        char[] chars = string.toCharArray();
        char[] buffer = new char[1030];
        int bufferIndex = 0;
        sb.append('\"');
        block11: for (int i = 0; i < len; ++i) {
            if (bufferIndex > 1024) {
                sb.append(buffer, 0, bufferIndex);
                bufferIndex = 0;
            }
            char b = c;
            c = chars[i];
            switch (c) {
                case '\"': 
                case '\\': {
                    buffer[bufferIndex++] = 92;
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                case '/': {
                    if (b == '<') {
                        buffer[bufferIndex++] = 92;
                    }
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\b': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 98;
                                continue block11;
                            }
                            case '\t': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 116;
                                continue block11;
                            }
                            case '\n': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 110;
                                continue block11;
                            }
                            case '\f': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 102;
                                continue block11;
                            }
                            case '\r': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 114;
                                continue block11;
                            }
                        }
                        String t = "000" + Integer.toHexString(c);
                        int tLength = t.length();
                        buffer[bufferIndex++] = 92;
                        buffer[bufferIndex++] = 117;
                        buffer[bufferIndex++] = t.charAt(tLength - 4);
                        buffer[bufferIndex++] = t.charAt(tLength - 3);
                        buffer[bufferIndex++] = t.charAt(tLength - 2);
                        buffer[bufferIndex++] = t.charAt(tLength - 1);
                        continue block11;
                    }
                    buffer[bufferIndex++] = c;
                }
            }
        }
        sb.append(buffer, 0, bufferIndex);
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public String serializeAsXml(String beanName, String offset) {
        String retXml = "";
        try {
            if (this.getProperty(beanName) == null) {
                retXml = retXml + "\n" + offset + "<" + beanName + ">";
                for (DynamicProperty dp : this) {
                    retXml = retXml + dp.serializeAsXml("    " + offset);
                }
                retXml = retXml + "\n" + offset + "</" + beanName + ">";
            } else {
                retXml = retXml + this.getProperty(beanName).serializeAsXml(offset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retXml;
    }
}

