/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.jobcontrol;

import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Logger;
import ru.biosoft.jobcontrol.ClassJobControl;
import ru.biosoft.jobcontrol.Iteration;

public abstract class StackProgressJobControl
extends ClassJobControl {
    private Stack<Range> stack = new Stack();

    public StackProgressJobControl(Logger log) {
        super(log);
        this.stack.push(new Range(0.0, 100.0));
    }

    public void pushProgress(int from, int to) {
        this.stack.push(this.stack.peek().getSubrange(from, to));
    }

    public void popProgress() {
        this.setPreparedness(100);
        this.stack.pop();
    }

    public void popAndShrink() {
        this.setPreparedness(100);
        Range range1 = this.stack.pop();
        Range range2 = this.stack.pop();
        this.stack.push(new Range(range1.to, range2.to));
    }

    public <T> boolean forCollection(Collection<T> collection, Iteration<T> iteration) {
        int size = collection.size();
        Iterator<T> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.pushProgress((int)(100L * (long)n / (long)size), (int)(100L * (long)(n + 1) / (long)size));
            if (!iteration.run(iterator.next())) {
                this.popProgress();
                return false;
            }
            this.popProgress();
            if (this.getStatus() == 4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void setPreparedness(int percent) {
        super.setPreparedness((int)this.stack.peek().translateValue(percent));
    }

    private static class Range {
        double from;
        double to;

        public Range(double from, double to) {
            this.from = from;
            this.to = to;
        }

        public double translateValue(double value) {
            return (this.to - this.from) * value / 100.0 + this.from;
        }

        public Range getSubrange(double from, double to) {
            return new Range(this.translateValue(from), this.translateValue(to));
        }
    }
}

