/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.jobcontrol;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.ClassJobControl;
import ru.biosoft.jobcontrol.JobAction;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListenerAdapter;

public class JobControlPane
extends JPanel {
    private final Logger log = Logger.getLogger(JobControlPane.class.getName());
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final MToolBar toolBar = new MToolBar();
    private final JPanel centerPanel = new JPanel();
    private final FlowLayout flowLayout1 = new FlowLayout();
    private final JProgressBar progressBar = new JProgressBar();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final JPanel labelPane = new JPanel();
    private final JLabel statusLabel = new JLabel();
    private final JLabel label1 = new JLabel();
    private final JLabel remainingLabel = new JLabel("         ");
    private final JLabel elapsedLabel = new JLabel("         ");
    private JobControl jobControl;
    private JobAction actionTerminate;
    private JobAction actionPause;
    private JobAction actionStart;

    public JobControlPane() {
        this.init();
    }

    public JobControlPane(ClassJobControl jobControl) {
        this.setJobControl(jobControl);
        this.init();
    }

    public void enableStart(boolean flag) {
        this.actionStart.setEnabled(flag);
    }

    public void setJobControl(JobControl jobCtrl) {
        this.actionStart.setEnabled(true);
        this.jobControl = jobCtrl;
        this.jobControl.addListener(new JobControlListenerAdapter(){

            @Override
            public void valueChanged(JobControlEvent event) {
                JobControlPane.this.log.log(Level.FINE, "JobControlListener pane : valueChanged " + event.getPreparedness());
                JobControlPane.this.progressBar.setValue(event.getPreparedness());
                long remainingTime = event.getJobControl().getRemainedTime();
                String remainingString = AbstractJobControl.format(remainingTime, "HH:mm:ss");
                JobControlPane.this.remainingLabel.setText(" " + remainingString);
                long elapsedTime = event.getJobControl().getElapsedTime();
                String elapsedString = AbstractJobControl.format(elapsedTime, "HH:mm:ss");
                JobControlPane.this.elapsedLabel.setText(" " + elapsedString);
            }

            @Override
            public void jobStarted(JobControlEvent event) {
                JobControlPane.this.statusLabel.setText("Running...");
                JobControlPane.this.actionPause.setEnabled(true);
                JobControlPane.this.actionTerminate.setEnabled(true);
            }

            @Override
            public void jobTerminated(JobControlEvent event) {
                int status = JobControlPane.this.jobControl.getStatus();
                String msg = null;
                JobControlPane.this.actionPause.setEnabled(false);
                JobControlPane.this.actionTerminate.setEnabled(false);
                switch (status) {
                    case 3: {
                        msg = "Completed";
                        break;
                    }
                    case 5: {
                        msg = "Terminated by error";
                        break;
                    }
                    case 4: {
                        msg = "Terminated by user";
                    }
                }
                JobControlPane.this.progressBar.setValue(0);
                JobControlPane.this.statusLabel.setText(msg);
            }

            @Override
            public void jobPaused(JobControlEvent event) {
                JobControlPane.this.statusLabel.setText("Paused");
            }

            @Override
            public void jobResumed(JobControlEvent event) {
                JobControlPane.this.statusLabel.setText("Continue...");
            }
        });
    }

    private void init() {
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Progress status");
        this.setBorder(titledBorder1);
        this.setLayout(this.borderLayout1);
        this.toolBar.setFloatable(true);
        this.flowLayout1.setAlignment(2);
        JCPActionListener actionListener = new JCPActionListener();
        this.actionTerminate = JobAction.createTerminateAction(actionListener);
        this.actionPause = JobAction.createPauseAction(actionListener);
        this.actionStart = JobAction.createStartAction(actionListener);
        this.actionTerminate.setEnabled(false);
        this.actionPause.setEnabled(false);
        this.actionStart.setEnabled(false);
        this.addAction(this.toolBar, this.actionStart);
        this.addAction(this.toolBar, this.actionPause);
        this.addAction(this.toolBar, this.actionTerminate);
        this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        this.centerPanel.setSize(new Dimension(250, 100));
        this.centerPanel.setLayout(this.gridBagLayout1);
        this.labelPane.setLayout(new BorderLayout());
        this.label1.setText("Status:");
        this.labelPane.setMinimumSize(new Dimension(10, 20));
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.progressBar, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.labelPane, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        JPanel elapsedTimePane = new JPanel(new GridLayout(0, 2));
        elapsedTimePane.add(new JLabel("Elapsed time:"));
        elapsedTimePane.add(this.elapsedLabel);
        this.centerPanel.add((Component)elapsedTimePane, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        JPanel remainingTimePane = new JPanel(new GridLayout(0, 2));
        remainingTimePane.add(new JLabel("Remaining time:"));
        remainingTimePane.add(this.remainingLabel);
        this.centerPanel.add((Component)remainingTimePane, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        this.labelPane.add((Component)this.statusLabel, "Center");
        this.labelPane.add((Component)this.label1, "West");
        this.add((Component)this.toolBar, "South");
    }

    private AbstractButton addAction(MToolBar toolBar, Action action) {
        JButton b = toolBar.createActionComponent(action);
        b.setAlignmentY(0.5f);
        b.setAction(action);
        b.setActionCommand((String)action.getValue("ActionCommandKey"));
        toolBar.add(b);
        return b;
    }

    private static class MToolBar
    extends JToolBar {
        MToolBar() {
            this.setFloatable(true);
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        @Override
        protected JButton createActionComponent(Action a) {
            return super.createActionComponent(a);
        }
    }

    private class JCPActionListener
    implements ActionListener {
        private JCPActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("start")) {
                switch (JobControlPane.this.jobControl.getStatus()) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: {
                        new Thread(){

                            @Override
                            public void run() {
                                JobControlPane.this.jobControl.run();
                            }
                        }.start();
                        break;
                    }
                    case 2: {
                        JobControlPane.this.jobControl.resume();
                        break;
                    }
                }
            } else if (cmd.equals("pause")) {
                JobControlPane.this.jobControl.pause();
            } else if (cmd.equals("terminate")) {
                JobControlPane.this.jobControl.terminate();
            }
        }
    }
}

