/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.jobcontrol;

import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;

public class JobControlEvent {
    protected JobControl jobControl = null;
    protected String message;
    protected Object[] results;
    protected JobControlException ex;

    public JobControlEvent(JobControl jobControl, String message) {
        this.jobControl = jobControl;
        this.message = message;
    }

    public JobControlEvent(JobControl jobControl, JobControlException ex) {
        this.jobControl = jobControl;
        this.message = ex.getMessage();
        this.ex = ex;
    }

    public JobControlEvent(JobControl jobControl, Object[] resultPaths) {
        this.jobControl = jobControl;
        this.message = "results";
        this.results = resultPaths;
    }

    public JobControlEvent(JobControl jobControl) {
        this.jobControl = jobControl;
    }

    public JobControlEvent(String msg) {
        this(null, msg);
    }

    public JobControl getJobControl() {
        return this.jobControl;
    }

    public int getPreparedness() {
        if (this.jobControl != null) {
            return this.jobControl.getPreparedness();
        }
        return 0;
    }

    public String getMessage() {
        if (this.message == null && this.jobControl != null) {
            return this.jobControl.getTextStatus();
        }
        return this.message;
    }

    public JobControlException getException() {
        return this.ex;
    }

    public Object[] getResults() {
        return this.results;
    }

    public int getStatus() {
        if (this.jobControl == null) {
            return -1;
        }
        return this.jobControl.getStatus();
    }
}

