/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.jobcontrol;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class JobAction
extends AbstractAction {
    public static final String ACTION_PAUSE = "pause";
    public static final String ACTION_TERMINATE = "terminate";
    public static final String ACTION_START = "start";
    protected static final Logger log = Logger.getLogger(JobAction.class.getName());
    private Vector<ActionListener> actionListeners = null;

    protected JobAction(String name, String shortDesc, String longDesc, int mnemonic, String imageFile, String cmd, ActionListener listener) {
        this.putValue("Name", name);
        this.putValue("ShortDescription", shortDesc);
        this.putValue("LongDescription", longDesc);
        this.putValue("MnemonicKey", mnemonic);
        this.putValue("ActionCommandKey", cmd);
        URL url = this.getClass().getResource("resources/" + imageFile);
        if (url == null) {
            log.log(Level.SEVERE, "Error loading resource resources/" + imageFile);
            return;
        }
        ImageIcon imageIcon = new ImageIcon(url);
        this.putValue("SmallIcon", imageIcon);
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public static JobAction createPauseAction(ActionListener listener) {
        return new JobAction("Pause", "Pause process", "Pause process", 79, "pause.gif", ACTION_PAUSE, listener);
    }

    public static JobAction createStartAction(ActionListener listener) {
        return new JobAction("Start", "Start process", "Start process", 79, "start.gif", ACTION_START, listener);
    }

    public static JobAction createTerminateAction(ActionListener listener) {
        return new JobAction("Terminate", "Terminate process", "Terminate process", 79, "terminate.gif", ACTION_TERMINATE, listener);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.fireActionPerformed(evt);
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.add(l);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        ActionEvent event = new ActionEvent(this, evt.getID(), evt.getActionCommand());
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener l = this.actionListeners.get(i);
                l.actionPerformed(event);
            }
        }
    }
}

