/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.jobcontrol;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.jobcontrol.JobControlListener;

public abstract class AbstractJobControl
implements JobControl {
    private static final long MAXIMAL_TIME = 216000000L;
    protected Logger log;
    protected Date startedDate;
    protected int status = 0;
    private volatile CountDownLatch latch;
    protected int runStatus;
    protected int preparedness = 0;
    private final Date createdDate;
    private Date endedDate;
    private long curTime = 0L;
    private final Vector<JobControlListener> listeners = new Vector();
    private boolean isPaused = false;
    protected boolean isTerminated = false;

    public AbstractJobControl(Logger log) {
        this.log = log;
        this.createdDate = Calendar.getInstance().getTime();
    }

    public AbstractJobControl(Logger log, JobControlListener listener) {
        this(log);
        if (listener != null) {
            this.addListener(listener);
        } else {
            log.log(Level.WARNING, "Listener is null");
        }
    }

    protected abstract void doRun() throws JobControlException;

    public void begin() {
        this.begin(null);
    }

    protected void begin(String msg) {
        if (this.status == 1) {
            return;
        }
        if (msg != null) {
            // empty if block
        }
        this.reset();
        this.startedDate = Calendar.getInstance().getTime();
        this.isTerminated = false;
        this.status = 1;
        this.fireJobStarted(msg);
        this.runStatus = 3;
    }

    public void exceptionOccured(JobControlException ex) {
        if (this.log != null) {
            this.log.log(Level.FINE, "exceptionOccured() ", ex);
        }
        this.runStatus = ex.getStatus();
    }

    protected boolean isStatusTerminated() {
        return this.status == 0 || this.status == 3 || this.status == 4 || this.status == 5;
    }

    public void end() {
        this.end((String)null);
    }

    protected void end(String msg) {
        if (!this.isStatusTerminated()) {
            this.setTerminated(this.runStatus);
        }
        this.fireJobTerminated(msg, null);
        this.resetFlags();
    }

    public void end(JobControlException ex) {
        if (!this.isStatusTerminated()) {
            this.setTerminated(this.runStatus);
        }
        this.fireJobTerminated(null, ex);
        this.resetFlags();
    }

    @Override
    public void run() {
        this.begin();
        JobControlException jcex = null;
        try {
            this.doRun();
            this.end(jcex);
            if (this.log != null) {
                this.log.log(Level.FINE, "end called");
            }
        }
        catch (JobControlException ex) {
            try {
                this.exceptionOccured(ex);
                jcex = ex;
                this.end(jcex);
                if (this.log != null) {
                    this.log.log(Level.FINE, "end called");
                }
            }
            catch (Throwable throwable) {
                this.end(jcex);
                if (this.log != null) {
                    this.log.log(Level.FINE, "end called");
                }
                throw throwable;
            }
        }
    }

    @Override
    public void pause() {
        if (this.log != null) {
            this.log.log(Level.FINE, "pause()");
        }
        if (this.status == 1) {
            this.latch = new CountDownLatch(1);
            this.isPaused = true;
            this.status = 2;
            this.fireJobPaused();
        }
    }

    @Override
    public void resume() {
        if (this.log != null) {
            this.log.log(Level.FINE, "resume()");
        }
        if (this.status == 2) {
            this.isPaused = false;
            this.status = 1;
            this.fireJobResumed();
            CountDownLatch latch = this.latch;
            if (latch != null) {
                latch.countDown();
            }
            this.latch = null;
        }
    }

    @Override
    public void terminate() {
        if (this.log != null) {
            this.log.log(Level.FINE, "terminate()");
        }
        if (this.status == 1 || this.status == 2) {
            this.setTerminated(4);
            CountDownLatch latch = this.latch;
            if (latch != null) {
                latch.countDown();
            }
            this.latch = null;
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public static String getTextStatus(int status) {
        switch (status) {
            case 0: {
                return "Created";
            }
            case 1: {
                return "Running";
            }
            case 2: {
                return "Paused";
            }
            case 3: {
                return "Completed";
            }
            case 4: {
                return "Terminated by request";
            }
            case 5: {
                return "Terminated by error";
            }
        }
        return "Error";
    }

    @Override
    public String getTextStatus() {
        return AbstractJobControl.getTextStatus(this.getStatus());
    }

    @Override
    public int getPreparedness() {
        return this.preparedness;
    }

    @Override
    public long getCreatedTime() {
        return this.createdDate == null ? -1L : this.createdDate.getTime();
    }

    @Override
    public long getStartedTime() {
        if (this.startedDate == null) {
            return -1L;
        }
        return this.startedDate.getTime();
    }

    @Override
    public long getEndedTime() {
        return this.endedDate == null ? -1L : this.endedDate.getTime();
    }

    @Override
    public long getElapsedTime() {
        long start = this.getStartedTime();
        long curTime = Calendar.getInstance().getTime().getTime();
        if (start == -1L) {
            return 0L;
        }
        return curTime - start;
    }

    @Override
    public long getRemainedTime() {
        int percent = this.getPreparedness();
        long start = this.getStartedTime();
        if (start == -1L) {
            return this.getCreatedTime() + 216000000L;
        }
        if (percent == 0) {
            return this.getStartedTime() + 216000000L;
        }
        return start + 100L * (this.curTime - start) / (long)percent - this.curTime;
    }

    @Override
    public void addListener(JobControlListener listener) {
        if (listener != null) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removeListener(JobControlListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    protected void fireJobStarted(String msg) {
        JobControlEvent event = new JobControlEvent((JobControl)this, msg);
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.jobStarted(event);
        }
    }

    protected void fireJobPaused() {
        JobControlEvent event = new JobControlEvent(this);
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.jobPaused(event);
        }
    }

    protected void fireJobResumed() {
        JobControlEvent event = new JobControlEvent(this);
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.jobResumed(event);
        }
    }

    public void fireValueChanged() {
        JobControlEvent event = new JobControlEvent(this);
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.valueChanged(event);
        }
    }

    protected void fireJobTerminated(String msg) {
        this.fireJobTerminated(msg, null);
    }

    protected void fireJobTerminated(String msg, JobControlException ex) {
        JobControlEvent event = ex == null ? new JobControlEvent((JobControl)this, msg) : new JobControlEvent((JobControl)this, ex);
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.jobTerminated(event);
        }
    }

    private final boolean isPaused() {
        return this.isPaused;
    }

    private final boolean isTerminated() {
        return this.isTerminated;
    }

    protected void setTerminated(int status) {
        this.status = status;
        this.isTerminated = true;
        this.endedDate = new Date();
    }

    @Override
    public void setPreparedness(int percent) {
        if (this.preparedness != percent) {
            this.curTime = Calendar.getInstance().getTime().getTime();
            this.preparedness = percent;
            this.fireValueChanged();
        }
    }

    public void resultsAreReady() {
        JobControlEvent event = new JobControlEvent((JobControl)this, "results");
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.resultsReady(event);
        }
        this.setCompleted();
    }

    public void resultsAreReady(Object[] results) {
        JobControlEvent event = new JobControlEvent((JobControl)this, results);
        for (JobControlListener listener : this.listeners.toArray(new JobControlListener[this.listeners.size()])) {
            listener.resultsReady(event);
        }
        if (this.status != 4) {
            this.setCompleted();
        }
    }

    protected void setCompleted() {
        this.status = 3;
        this.isTerminated = true;
    }

    protected void reset() {
        this.status = 0;
        this.resetFlags();
    }

    protected void resetFlags() {
        this.isTerminated = false;
        this.isPaused = false;
    }

    public void checkStatus() throws JobControlException {
        CountDownLatch latch;
        if (this.isTerminated()) {
            this.fireJobTerminated("" + AbstractJobControl.getTextStatus(4), null);
            throw new JobControlException(4);
        }
        if (this.isPaused() && (latch = this.latch) != null) {
            while (true) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    public static String format(long time) {
        return AbstractJobControl.format(time, "HH:mm:ss");
    }

    public static String format(long time, String format) {
        String chaos = "";
        time /= 10L;
        String s = "" + (time /= 100L) % 60L;
        if (s.length() == 1) {
            s = "0" + s;
        }
        chaos = s + chaos;
        s = "" + (time /= 60L) % 60L;
        if (s.length() == 1) {
            s = "0" + s;
        }
        chaos = s + ":" + chaos;
        s = "" + (time /= 60L);
        if (s.length() == 1) {
            s = "0" + s;
        }
        chaos = s + ":" + chaos;
        if (time > 100L) {
            return "?";
        }
        return chaos;
    }
}

