/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.ae.AeModel;

public class NewtonSolver {
    private static final double STPMX = 100.0;
    private static final double EPS = 1.0E-4;
    private static final double TOLERANCE_X = 1.0E-7;
    private static final double ALF = 1.0E-4;

    public static boolean solve(double[] initialGuess, AeModel model) throws Exception {
        double MAXITS = 20000.0;
        double TOLF = 1.0E-10;
        double TOLMIN = 1.0E-12;
        double TOLX = 1.0E-13;
        return NewtonSolver.solve(initialGuess, model, MAXITS, TOLF, TOLMIN, TOLX);
    }

    public static boolean solve(double[] initialGuess, AeModel model, double MAXITS, double TOLF, double TOLMIN, double TOLX) throws Exception {
        int n = initialGuess.length;
        double fNorm = NewtonSolver.calculateHalfNorm(initialGuess, model);
        double[] currentFunctionValues = model.solveAlgebraic(initialGuess);
        double[] currentArgumentValues = initialGuess;
        double[] xOld = new double[n];
        double[] directions = new double[n];
        double test = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(currentFunctionValues[i]) > test)) continue;
            test = Math.abs(currentFunctionValues[i]);
        }
        if (test < 0.01 * TOLF) {
            return false;
        }
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += currentArgumentValues[i] * currentArgumentValues[i];
        }
        double maxStep = 100.0 * Math.max(Math.sqrt(sum), (double)n);
        int itearations = 0;
        while ((double)itearations < MAXITS) {
            int i;
            int i2;
            double[][] yacobian = NewtonSolver.jacobian(currentArgumentValues, currentFunctionValues, model);
            double[] gradient = new double[n];
            for (i2 = 0; i2 < n; ++i2) {
                double sum1 = 0.0;
                for (int j = 0; j < n; ++j) {
                    sum1 += yacobian[j][i2] * currentFunctionValues[j];
                }
                gradient[i2] = sum1;
            }
            for (i2 = 0; i2 < n; ++i2) {
                xOld[i2] = currentArgumentValues[i2];
            }
            double fOldNorm = fNorm;
            for (i2 = 0; i2 < n; ++i2) {
                directions[i2] = -currentFunctionValues[i2];
            }
            int[] permutations = NewtonSolver.luDecomposition(yacobian);
            NewtonSolver.luBackSubstitution(yacobian, permutations, directions);
            boolean[] check = new boolean[1];
            fNorm = NewtonSolver.lineSearch(xOld, fOldNorm, gradient, directions, maxStep, currentArgumentValues, model, check);
            currentFunctionValues = model.solveAlgebraic(currentArgumentValues);
            test = 0.0;
            for (i = 0; i < n; ++i) {
                if (!(Math.abs(currentFunctionValues[i]) > test)) continue;
                test = Math.abs(currentFunctionValues[i]);
            }
            if (test < TOLF) {
                return false;
            }
            if (check[0]) {
                test = 0.0;
                double den = Math.max(fNorm, 0.5 * (double)n);
                double temp = 0.0;
                for (int i3 = 0; i3 < n; ++i3) {
                    temp = Math.abs(gradient[i3]) * Math.max(Math.abs(currentArgumentValues[i3]), 1.0) / den;
                    if (!(temp > test)) continue;
                    test = temp;
                }
                return test < TOLMIN;
            }
            test = 0.0;
            for (i = 0; i < n; ++i) {
                double temp = Math.abs(currentArgumentValues[i] - xOld[i]) / Math.max(Math.abs(currentArgumentValues[i]), 1.0);
                if (!(temp > test)) continue;
                test = temp;
            }
            if (test < TOLX) {
                return false;
            }
            ++itearations;
        }
        throw new Exception("Error during solving algebraic system: max iteration number exceeded");
    }

    public static double lineSearch(double[] xOld, double fOld, double[] gradient, double[] direction, double maxStep, double[] x, AeModel model, boolean[] check) throws Exception {
        int i;
        double alam2 = 0.0;
        double f2 = 0.0;
        int n = xOld.length;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += direction[i] * direction[i];
        }
        if ((sum = Math.sqrt(sum)) > maxStep) {
            i = 0;
            while (i < n) {
                int n2 = i++;
                direction[n2] = direction[n2] * (maxStep / sum);
            }
        }
        double slope = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            slope += gradient[i2] * direction[i2];
        }
        if (slope >= 0.0) {
            throw new Exception("roundoff problem in lineSearch");
        }
        double test = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            double temp = Math.abs(direction[i3]) / Math.max(Math.abs(xOld[i3]), 1.0);
            if (!(temp > test)) continue;
            test = temp;
        }
        double alamin = 1.0E-7 / test;
        double alam = 1.0;
        double fTemp = fOld;
        while (true) {
            double tmpAlam;
            int i4;
            for (i4 = 0; i4 < n; ++i4) {
                x[i4] = xOld[i4] + alam * direction[i4];
            }
            double f = NewtonSolver.calculateHalfNorm(x, model);
            if (f == fTemp) {
                return f;
            }
            fTemp = f;
            if (alam < alamin) {
                for (i4 = 0; i4 < n; ++i4) {
                    x[i4] = xOld[i4];
                }
                check[0] = true;
                return f;
            }
            if (f <= fOld + 1.0E-4 * alam * slope) {
                check[0] = false;
                return f;
            }
            if (alam == 1.0) {
                tmpAlam = -slope / (1.0 * (f - fOld - slope));
            } else {
                double disc;
                double rhs1 = f - fOld - alam * slope;
                double rhs2 = f2 - fOld - alam2 * slope;
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmpAlam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + Math.sqrt(disc)) / (3.0 * a) : -slope / (b + Math.sqrt(disc))));
                if (tmpAlam > 0.5 * alam) {
                    tmpAlam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            alam = Math.max(tmpAlam, 0.1 * alam);
        }
    }

    public static int[] luDecomposition(double[][] matrix) throws Exception {
        int n = matrix.length;
        if (n == 0 || n != matrix[0].length) {
            throw new Exception("Wrong matrix on input");
        }
        double[] scalingVector = new double[n];
        int[] rowPermutation = new int[n];
        int parity = 1;
        for (int i = 0; i < n; ++i) {
            double max = 0.0;
            double temp = 0.0;
            for (int j = 0; j < n; ++j) {
                double d;
                temp = Math.abs(matrix[i][j]);
                if (!(d > max)) continue;
                max = temp;
            }
            if (max == 0.0) {
                // empty if block
            }
            scalingVector[i] = 1.0 / max;
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < j; ++i) {
                double sum = matrix[i][j];
                for (int k = 0; k < i; ++k) {
                    sum -= matrix[i][k] * matrix[k][j];
                }
                matrix[i][j] = sum;
            }
            double max = 0.0;
            int maxI = j;
            for (int i = j; i < n; ++i) {
                double d;
                double sum = matrix[i][j];
                for (int k = 0; k < j; ++k) {
                    sum -= matrix[i][k] * matrix[k][j];
                }
                matrix[i][j] = sum;
                double dum = Math.abs(sum);
                if (!(d >= max)) continue;
                max = dum;
                maxI = i;
            }
            if (j != maxI) {
                for (int k = 0; k < n; ++k) {
                    double t = matrix[maxI][k];
                    matrix[maxI][k] = matrix[j][k];
                    matrix[j][k] = t;
                }
                parity = -parity;
                scalingVector[maxI] = scalingVector[j];
            }
            rowPermutation[j] = maxI;
            if (j == n - 1) continue;
            double t = 1.0 / matrix[j][j];
            for (int i = j + 1; i < n; ++i) {
                double[] dArray = matrix[i];
                int n2 = j;
                dArray[n2] = dArray[n2] * t;
            }
        }
        return rowPermutation;
    }

    public static void luBackSubstitution(double[][] luDecomposition, int[] rowPermutation, double[] rightHandSide) throws Exception {
        int j;
        double sum;
        int i;
        int n = luDecomposition.length;
        if (n == 0 || n != luDecomposition[0].length || n != rightHandSide.length || n != rowPermutation.length) {
            throw new Exception("Wrong matrix on input");
        }
        int ii = -1;
        for (i = 0; i < n; ++i) {
            int ip = rowPermutation[i];
            sum = rightHandSide[ip];
            rightHandSide[ip] = rightHandSide[i];
            if (ii >= 0) {
                for (j = ii; j < i; ++j) {
                    sum -= luDecomposition[i][j] * rightHandSide[j];
                }
            } else if (sum > 0.0) {
                ii = i;
            }
            rightHandSide[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = rightHandSide[i];
            for (j = i + 1; j < n; ++j) {
                sum -= luDecomposition[i][j] * rightHandSide[j];
            }
            rightHandSide[i] = sum / luDecomposition[i][i];
        }
    }

    public static double[][] jacobian(double[] x, double[] function, AeModel model) throws Exception {
        int n = x.length;
        if (n == 0 || function.length != n) {
            throw new Exception("invalid format");
        }
        double[][] yacoby = new double[n][n];
        for (int j = 0; j < n; ++j) {
            double temp = x[j];
            double h = 1.0E-4 * Math.abs(temp);
            if (h < 1.0E-4) {
                h = 1.0E-4;
            }
            x[j] = temp + h;
            h = x[j] - temp;
            double[] fResult = model.solveAlgebraic(x);
            x[j] = temp;
            for (int i = 0; i < n; ++i) {
                yacoby[i][j] = (fResult[i] - function[i]) / h;
            }
        }
        return yacoby;
    }

    public static double calculateHalfNorm(double[] x, AeModel m) throws Exception {
        double[] result = m.solveAlgebraic(x);
        if (result.length < x.length) {
            throw new Exception("Algebraic system is undeterminated: " + result.length + " equations and " + x.length + " variables");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += result[i] * result[i];
        }
        return 0.5 * sum;
    }

    public static void solveLinearEquationsSet(double[][] a, double[] rightHandSide) throws Exception {
        StringBuilder row;
        int i;
        int[] rowPermuiatations = NewtonSolver.luDecomposition(a);
        for (i = 0; i < a.length; ++i) {
            row = new StringBuilder();
            for (int j = 0; j < a.length; ++j) {
                row.append(a[i][j]).append(" ");
            }
            System.out.println(row.toString());
        }
        row = new StringBuilder();
        for (i = 0; i < rowPermuiatations.length; ++i) {
            row.append(rowPermuiatations[i]).append(" ");
        }
        System.out.println("ROW:" + row.toString());
        NewtonSolver.luBackSubstitution(a, rowPermuiatations, rightHandSide);
    }
}

