# GANsForVirtualEye: Time Series Generation Package

[![Documentation Status](https://readthedocs.org/projects/gansforvirtualeye/badge/?version=latest)](https://gansforvirtualeye.readthedocs.io/en/latest/)
[![License: MIT](https://img.shields.io/badge/License-MIT-brightgreen)](https://github.com/shailendrabhandari/GANsForVirtualEye/blob/main/LICENSE)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/GANsforVirtualEye)](https://pypi.org/project/GANsforVirtualEye/)
[![PyPI](https://img.shields.io/pypi/v/GANsforVirtualEye)](https://pypi.org/project/GANsforVirtualEye/)
[![Downloads](https://pepy.tech/badge/gansforvirtualeye)](https://pepy.tech/project/gansforvirtualeye)
![GitHub watchers](https://img.shields.io/github/watchers/shailendrabhandari/GANsForVirtualEye?style=social)
![GitHub stars](https://img.shields.io/github/stars/shailendrabhandari/GANsForVirtualEye?style=social)

GANsForVirtualEye is a Python package that implements Generative Adversarial Networks (GANs) for time series data generation, offering flexible architecture options with CNN and LSTM models for both generators and discriminators.

## Architecture

![GAN Architecture](https://raw.githubusercontent.com/shailendrabhandari/GANsForVirtualEye/main/gan_package/results/Class_GAN_Arc.jpg)

## Installation

### Prerequisites

- Python 3.6 or higher
- `pip` package manager

### Steps

1. **Clone the Repository**

   ```bash
   git clone https://github.com/shailendrabhandari/GANsForVirtualEye.git
   cd GANsForVirtualEye
   ```

2. **Install Required Packages**

   It's recommended to use a virtual environment.

   ```bash
   pip install -r requirements.txt
   ```

3. **Install the Package**

   ```bash
   pip install .
   ```

## Documentation

Detailed documentation is available at [Read the Docs](https://gansforvirtualeye.readthedocs.io/en/latest/).

## Author

- **Shailendra Bhandari**  
  [GitHub](https://github.com/shailendrabhandari) | [Email](mailto:shailendra.bhandari@oslomet.no)

---

Thank you for using GANsForVirtualEye! Your feedback is valuable to us.