# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.gke_multicloud_v1 import gapic_version as package_version

__version__ = package_version.__version__


from .services.attached_clusters import (
    AttachedClustersAsyncClient,
    AttachedClustersClient,
)
from .services.aws_clusters import AwsClustersAsyncClient, AwsClustersClient
from .services.azure_clusters import AzureClustersAsyncClient, AzureClustersClient
from .types.attached_resources import (
    AttachedCluster,
    AttachedClusterError,
    AttachedClustersAuthorization,
    AttachedClusterUser,
    AttachedOidcConfig,
    AttachedPlatformVersionInfo,
    AttachedServerConfig,
)
from .types.attached_service import (
    CreateAttachedClusterRequest,
    DeleteAttachedClusterRequest,
    GenerateAttachedClusterInstallManifestRequest,
    GenerateAttachedClusterInstallManifestResponse,
    GetAttachedClusterRequest,
    GetAttachedServerConfigRequest,
    ImportAttachedClusterRequest,
    ListAttachedClustersRequest,
    ListAttachedClustersResponse,
    UpdateAttachedClusterRequest,
)
from .types.aws_resources import (
    AwsAuthorization,
    AwsAutoscalingGroupMetricsCollection,
    AwsCluster,
    AwsClusterError,
    AwsClusterNetworking,
    AwsClusterUser,
    AwsConfigEncryption,
    AwsControlPlane,
    AwsDatabaseEncryption,
    AwsInstancePlacement,
    AwsK8sVersionInfo,
    AwsNodeConfig,
    AwsNodePool,
    AwsNodePoolAutoscaling,
    AwsNodePoolError,
    AwsProxyConfig,
    AwsServerConfig,
    AwsServicesAuthentication,
    AwsSshConfig,
    AwsVolumeTemplate,
)
from .types.aws_service import (
    CreateAwsClusterRequest,
    CreateAwsNodePoolRequest,
    DeleteAwsClusterRequest,
    DeleteAwsNodePoolRequest,
    GenerateAwsAccessTokenRequest,
    GenerateAwsAccessTokenResponse,
    GetAwsClusterRequest,
    GetAwsNodePoolRequest,
    GetAwsServerConfigRequest,
    ListAwsClustersRequest,
    ListAwsClustersResponse,
    ListAwsNodePoolsRequest,
    ListAwsNodePoolsResponse,
    UpdateAwsClusterRequest,
    UpdateAwsNodePoolRequest,
)
from .types.azure_resources import (
    AzureAuthorization,
    AzureClient,
    AzureCluster,
    AzureClusterError,
    AzureClusterNetworking,
    AzureClusterResources,
    AzureClusterUser,
    AzureConfigEncryption,
    AzureControlPlane,
    AzureDatabaseEncryption,
    AzureDiskTemplate,
    AzureK8sVersionInfo,
    AzureNodeConfig,
    AzureNodePool,
    AzureNodePoolAutoscaling,
    AzureNodePoolError,
    AzureProxyConfig,
    AzureServerConfig,
    AzureServicesAuthentication,
    AzureSshConfig,
    ReplicaPlacement,
)
from .types.azure_service import (
    CreateAzureClientRequest,
    CreateAzureClusterRequest,
    CreateAzureNodePoolRequest,
    DeleteAzureClientRequest,
    DeleteAzureClusterRequest,
    DeleteAzureNodePoolRequest,
    GenerateAzureAccessTokenRequest,
    GenerateAzureAccessTokenResponse,
    GetAzureClientRequest,
    GetAzureClusterRequest,
    GetAzureNodePoolRequest,
    GetAzureServerConfigRequest,
    ListAzureClientsRequest,
    ListAzureClientsResponse,
    ListAzureClustersRequest,
    ListAzureClustersResponse,
    ListAzureNodePoolsRequest,
    ListAzureNodePoolsResponse,
    UpdateAzureClusterRequest,
    UpdateAzureNodePoolRequest,
)
from .types.common_resources import (
    Fleet,
    LoggingComponentConfig,
    LoggingConfig,
    ManagedPrometheusConfig,
    MaxPodsConstraint,
    MonitoringConfig,
    NodeTaint,
    OperationMetadata,
    WorkloadIdentityConfig,
)

__all__ = (
    "AttachedClustersAsyncClient",
    "AwsClustersAsyncClient",
    "AzureClustersAsyncClient",
    "AttachedCluster",
    "AttachedClusterError",
    "AttachedClusterUser",
    "AttachedClustersAuthorization",
    "AttachedClustersClient",
    "AttachedOidcConfig",
    "AttachedPlatformVersionInfo",
    "AttachedServerConfig",
    "AwsAuthorization",
    "AwsAutoscalingGroupMetricsCollection",
    "AwsCluster",
    "AwsClusterError",
    "AwsClusterNetworking",
    "AwsClusterUser",
    "AwsClustersClient",
    "AwsConfigEncryption",
    "AwsControlPlane",
    "AwsDatabaseEncryption",
    "AwsInstancePlacement",
    "AwsK8sVersionInfo",
    "AwsNodeConfig",
    "AwsNodePool",
    "AwsNodePoolAutoscaling",
    "AwsNodePoolError",
    "AwsProxyConfig",
    "AwsServerConfig",
    "AwsServicesAuthentication",
    "AwsSshConfig",
    "AwsVolumeTemplate",
    "AzureAuthorization",
    "AzureClient",
    "AzureCluster",
    "AzureClusterError",
    "AzureClusterNetworking",
    "AzureClusterResources",
    "AzureClusterUser",
    "AzureClustersClient",
    "AzureConfigEncryption",
    "AzureControlPlane",
    "AzureDatabaseEncryption",
    "AzureDiskTemplate",
    "AzureK8sVersionInfo",
    "AzureNodeConfig",
    "AzureNodePool",
    "AzureNodePoolAutoscaling",
    "AzureNodePoolError",
    "AzureProxyConfig",
    "AzureServerConfig",
    "AzureServicesAuthentication",
    "AzureSshConfig",
    "CreateAttachedClusterRequest",
    "CreateAwsClusterRequest",
    "CreateAwsNodePoolRequest",
    "CreateAzureClientRequest",
    "CreateAzureClusterRequest",
    "CreateAzureNodePoolRequest",
    "DeleteAttachedClusterRequest",
    "DeleteAwsClusterRequest",
    "DeleteAwsNodePoolRequest",
    "DeleteAzureClientRequest",
    "DeleteAzureClusterRequest",
    "DeleteAzureNodePoolRequest",
    "Fleet",
    "GenerateAttachedClusterInstallManifestRequest",
    "GenerateAttachedClusterInstallManifestResponse",
    "GenerateAwsAccessTokenRequest",
    "GenerateAwsAccessTokenResponse",
    "GenerateAzureAccessTokenRequest",
    "GenerateAzureAccessTokenResponse",
    "GetAttachedClusterRequest",
    "GetAttachedServerConfigRequest",
    "GetAwsClusterRequest",
    "GetAwsNodePoolRequest",
    "GetAwsServerConfigRequest",
    "GetAzureClientRequest",
    "GetAzureClusterRequest",
    "GetAzureNodePoolRequest",
    "GetAzureServerConfigRequest",
    "ImportAttachedClusterRequest",
    "ListAttachedClustersRequest",
    "ListAttachedClustersResponse",
    "ListAwsClustersRequest",
    "ListAwsClustersResponse",
    "ListAwsNodePoolsRequest",
    "ListAwsNodePoolsResponse",
    "ListAzureClientsRequest",
    "ListAzureClientsResponse",
    "ListAzureClustersRequest",
    "ListAzureClustersResponse",
    "ListAzureNodePoolsRequest",
    "ListAzureNodePoolsResponse",
    "LoggingComponentConfig",
    "LoggingConfig",
    "ManagedPrometheusConfig",
    "MaxPodsConstraint",
    "MonitoringConfig",
    "NodeTaint",
    "OperationMetadata",
    "ReplicaPlacement",
    "UpdateAttachedClusterRequest",
    "UpdateAwsClusterRequest",
    "UpdateAwsNodePoolRequest",
    "UpdateAzureClusterRequest",
    "UpdateAzureNodePoolRequest",
    "WorkloadIdentityConfig",
)
