import old_package.utils as utils
from datetime import datetime


class GridpointsError(utils.ErrorObject):

    def __init__(self, response):
        """An Error object for the alerts endpoints.

        Attributes
        ----------
        type: str
            A URI reference (RFC3986) that identifies the problem type.
        title: str
            A short, human-readable summary of the problem type.
        status: int
            The HTTP status code (RFC7231, Section 6) generated by the origin server for this occurrence of the problem.
            Minimum: 100, Max 999
        detail: str
            A human-readable explanation specific to this occurrence of the problem.
        instance: string
            A URI reference that identifies the specific occurrence of the problem.
        correlationId: str
            A unique identifier for the request, used for NWS debugging purposes.
            Please include this identifier with any correspondence to help the API maintainers investigate your issue.
        """

        super().__init__(response)


class ValidTimeObject:
    """The object to contain forecast values such as temperature, dewpoint, windspeed, etc."""

    def __init__(self, time):
        self._isotime = time # keep the original time string, just in case.
        self.time = datetime.fromisoformat(time)

    def _add_value(self, attribute_name, value):
        """Adds a value to the datetime object."""
        setattr(self, attribute_name, value)


# TODO: all of this below. Review it.
class RawForecast(utils.ObjectIterator):
    """The object that contains raw numerical forecast data for a 2.5km grid.

    Attributes
    ----------
    response_headers: requests.structures.CaseInsensitiveDict
        A dictionary containing the response headers.

    """

    n_errors = 0
    has_any_request_errors = False

    def __init__(self, wfo, gridX, gridY, user_agent):
        response = utils.request(f"https://api.weather.gov/gridpoints/{wfo}/{gridX},{gridY}", headers=user_agent)
        if not response.ok:
            self.terms = GridpointsError(response)
            self.n_errors += 1
            self.has_any_request_errors = True
        else:
            self.forecast = {}
            skip_elements = ['@id', '@type', 'updateTime', 'validTimes', 'elevation', 'forecastOffice', 'gridId', 'gridX', 'gridY']
            for element in response.json()['properties']:
                if element not in skip_elements:
                    self.forecast[element] = element


        self.response_headers = response.headers  # requests.structures.CaseInsensitiveDict

    # Utilities iterator only works for lists/tuples, not dictionaries.
    def __iter__(self):
        """Allows for iteration though self.terms."""
        self._terms_index = 0
        return self

    def __next__(self):
        """Allows for iteration through self.alerts."""
        if self._terms_index < len(self.terms):
            val = self.terms[self._terms_index]
            self._terms_index += 1
            return val
        else:
            raise StopIteration

    def __getitem__(self, term):
        """Allows for alerts object to be directly indexable."""
        if isinstance(term, int):  # if they're tyring to index like a list
            raise KeyError("Glossary not list, index using a term (i.e. Tornado).")
        return self.terms[term]