# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# Copyright 2020 Daniel Bakkelund
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 


'''
This init file defines the containing folder to be a namespace package,
it allows for re-opening.

This file was auomatically generated at Wed Feb 5 13:42:06 CET 2020
'''

from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import ophac.hierarchy as hierarchy
import ophac.rnd       as rnd

__version__ = '0.4.0'

def test():
    '''
    Smoke test of installation.
    '''
    D,Q  = rnd.randomOrderedDissimSpace(30,0.1,3)
    assert hierarchy.linkage(D,Q)        is not None
    assert hierarchy.approx_linkage(D,Q) is not None
    print('Smoke test of ophac seems to work just fine.')

