import { Test } from 'nodeunit';
declare const _default: {
    'default function'(test: Test): void;
    'adds policy permissions'(test: Test): void;
    'fails if inline code is used for an invalid runtime'(test: Test): void;
    addToResourcePolicy: {
        'can be used to add permissions to the Lambda function'(test: Test): void;
        'fails if the principal is not a service, account or arn principal'(test: Test): void;
        BYORole(test: Test): void;
    };
    fromFunctionArn(test: Test): void;
    'Lambda code can be read from a local directory via an asset'(test: Test): void;
    'default function with SQS DLQ when client sets deadLetterQueueEnabled to true and functionName defined by client'(test: Test): void;
    'default function with SQS DLQ when client sets deadLetterQueueEnabled to true and functionName not defined by client'(test: Test): void;
    'default function with SQS DLQ when client sets deadLetterQueueEnabled to false'(test: Test): void;
    'default function with SQS DLQ when client provides Queue to be used as DLQ'(test: Test): void;
    'default function with SQS DLQ when client provides Queue to be used as DLQ and deadLetterQueueEnabled set to true'(test: Test): void;
    'error when default function with SQS DLQ when client provides Queue to be used as DLQ and deadLetterQueueEnabled set to false'(test: Test): void;
    'default function with Active tracing'(test: Test): void;
    'default function with PassThrough tracing'(test: Test): void;
    'default function with Disabled tracing'(test: Test): void;
    grantInvoke: {
        'adds iam:InvokeFunction'(test: Test): void;
        'with a service principal'(test: Test): void;
        'with an account principal'(test: Test): void;
        'with an arn principal'(test: Test): void;
        'can be called twice for the same service principal'(test: Test): void;
    };
    'Can use metricErrors on a lambda Function'(test: Test): void;
    'addEventSource calls bind'(test: Test): void;
    'using an incompatible layer'(test: Test): void;
    'using more than 5 layers'(test: Test): void;
    'environment variables work in China'(test: Test): void;
    'environment variables work in an unspecified region'(test: Test): void;
    'support reserved concurrent executions'(test: Test): void;
    'its possible to specify event sources upon creation'(test: Test): void;
    'Provided Runtime returns the right values'(test: Test): void;
    'specify log retention'(test: Test): void;
    'imported lambda with imported security group and allowAllOutbound set to false'(test: Test): void;
    'with event invoke config'(test: Test): void;
    'throws when calling configureAsyncInvoke on already configured function'(test: Test): void;
    'event invoke config on imported lambda'(test: Test): void;
    'add a version with event invoke config'(test: Test): void;
    'check edge compatibility with env vars that can be removed'(test: Test): void;
    'check edge compatibility with env vars that cannot be removed'(test: Test): void;
};
export = _default;
