"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * Represents the filesystem for the Lambda function
 * @experimental
 */
class FileSystem {
    /**
     * @param config the FileSystem configurations for the Lambda function
     */
    constructor(config) {
        this.config = config;
    }
    /**
     * mount the filesystem from Amazon EFS
     * @param ap the Amazon EFS access point
     * @param mountPath the target path in the lambda runtime environment
     */
    static fromEfsAccessPoint(ap, mountPath) {
        return new FileSystem({
            localMountPath: mountPath,
            arn: ap.accessPointArn,
            dependency: [ap.fileSystem.mountTargetsAvailable],
            connections: ap.fileSystem.connections,
            policies: [
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientMount'],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'elasticfilesystem:AccessPointArn': ap.accessPointArn,
                        },
                    },
                }),
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientWrite'],
                    resources: [core_1.Stack.of(ap).formatArn({
                            service: 'elasticfilesystem',
                            resource: 'file-system',
                            resourceName: ap.fileSystem.fileSystemId,
                        })],
                }),
            ],
        });
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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