# -*- coding: utf-8 -*-
import unittest
import json
from download_mapping import create_parser, main, generate_regex_from_human, IDENTIFIER_FROM_HUMAN
from intelmq.lib.test import skip_internet


@skip_internet()
class TestDownloadMapping(unittest.TestCase):
    def test_download(self):
        parser = create_parser()
        args = parser.parse_args("")
        result = json.loads(main(args))
        self.assertGreater(len(result), 100)
        self.assertIsInstance(result, list)

    def test_download_identifier_expression(self):
        parser = create_parser()
        args = parser.parse_args('-e "^foobar$" -i foobar'.split(' '))
        result = json.loads(main(args))
        self.assertGreater(len(result), 100)
        self.assertIsInstance(result, list)


class TestDownloadMappingHelpers(unittest.TestCase):
    def test_generate_regex_from_human(self):
        self.assertEqual("^(foo[-_ ]?bar|bar[-_ ]?foo)$",
                         generate_regex_from_human("foo bar", "bar foo"))
        self.assertEqual("^(arid[-_ ]?viper)$",
                         generate_regex_from_human("AridViper"))
        self.assertEqual("^(apt[-_ ]?10)$",
                         generate_regex_from_human("APT 10"))
        self.assertEqual("^(foo[-_ ]?bar)$",
                         generate_regex_from_human("foo-bar"))
        self.assertEqual("^(cyber[-_ ]?fighters[-_ ]?of[-_ ]?izz[-_ ]?ad[-_ ]?din[-_ ]?al[-_ ]?qassam)$",
                         generate_regex_from_human("Cyber fighters of Izz Ad-Din Al Qassam"))

    def test_identifier_from_human(self):
        self.assertEqual("stealth-falcon",
                         IDENTIFIER_FROM_HUMAN.sub("-", "stealth falcon"))
