# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeArgs', 'Node']

@pulumi.input_type
class NodeArgs:
    def __init__(__self__, *,
                 member_id: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 node_configuration: pulumi.Input['NodeNodeConfigurationArgs']):
        """
        The set of arguments for constructing a Node resource.
        """
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "node_configuration", node_configuration)

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "member_id")

    @member_id.setter
    def member_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "member_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="nodeConfiguration")
    def node_configuration(self) -> pulumi.Input['NodeNodeConfigurationArgs']:
        return pulumi.get(self, "node_configuration")

    @node_configuration.setter
    def node_configuration(self, value: pulumi.Input['NodeNodeConfigurationArgs']):
        pulumi.set(self, "node_configuration", value)


warnings.warn("""Node is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class Node(pulumi.CustomResource):
    warnings.warn("""Node is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 member_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 node_configuration: Optional[pulumi.Input[pulumi.InputType['NodeNodeConfigurationArgs']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ManagedBlockchain::Node

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ManagedBlockchain::Node

        :param str resource_name: The name of the resource.
        :param NodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 member_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 node_configuration: Optional[pulumi.Input[pulumi.InputType['NodeNodeConfigurationArgs']]] = None,
                 __props__=None):
        pulumi.log.warn("""Node is deprecated: Node is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeArgs.__new__(NodeArgs)

            if member_id is None and not opts.urn:
                raise TypeError("Missing required property 'member_id'")
            __props__.__dict__["member_id"] = member_id
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if node_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'node_configuration'")
            __props__.__dict__["node_configuration"] = node_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["node_id"] = None
        super(Node, __self__).__init__(
            'aws-native:managedblockchain:Node',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Node':
        """
        Get an existing Node resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NodeArgs.__new__(NodeArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["member_id"] = None
        __props__.__dict__["network_id"] = None
        __props__.__dict__["node_configuration"] = None
        __props__.__dict__["node_id"] = None
        return Node(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="nodeConfiguration")
    def node_configuration(self) -> pulumi.Output['outputs.NodeNodeConfiguration']:
        return pulumi.get(self, "node_configuration")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "node_id")

