# coding: utf-8

"""
    Terra Scientific Pipelines Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PipelineRunReport(BaseModel):
    """
    Object containing metadata about the pipeline that was run, as well as pipeline run outputs if the run has completed successfully. 
    """ # noqa: E501
    pipeline_name: StrictStr = Field(description="The identifier string for the Pipeline. ", alias="pipelineName")
    pipeline_version: StrictInt = Field(description="An identifier Integer for the Pipeline Version. ", alias="pipelineVersion")
    tool_version: StrictStr = Field(description="An identifier string for the Pipeline Tool Version i.e. github repo tag/branch/release ", alias="toolVersion")
    outputs: Optional[Dict[str, Any]] = Field(default=None, description="The output(s) of a successful pipeline run. ")
    output_expiration_date: Optional[StrictStr] = Field(default=None, description="The Date when the pipeline outputs will expire. ", alias="outputExpirationDate")
    __properties: ClassVar[List[str]] = ["pipelineName", "pipelineVersion", "toolVersion", "outputs", "outputExpirationDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PipelineRunReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PipelineRunReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pipelineName": obj.get("pipelineName"),
            "pipelineVersion": obj.get("pipelineVersion"),
            "toolVersion": obj.get("toolVersion"),
            "outputs": obj.get("outputs"),
            "outputExpirationDate": obj.get("outputExpirationDate")
        })
        return _obj


