# coding: utf-8

"""
    Terra Scientific Pipelines Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PipelineRun(BaseModel):
    """
    Object containing the job id, status, user-provided description, time submitted, and (if run is complete) time completed of a Pipeline Run. 
    """ # noqa: E501
    job_id: StrictStr = Field(description="Required unique identifier (UUID) for a job. ", alias="jobId")
    pipeline_name: StrictStr = Field(description="The identifier string for the Pipeline. ", alias="pipelineName")
    status: StrictStr = Field(description="The current status of the pipeline run. ")
    description: Optional[StrictStr] = Field(default=None, description="The user-provided description for the pipeline run. ")
    time_submitted: StrictStr = Field(description="The time the job was submitted. ", alias="timeSubmitted")
    time_completed: Optional[StrictStr] = Field(default=None, description="The time the job was completed. ", alias="timeCompleted")
    quota_consumed: Optional[StrictInt] = Field(default=None, description="Quota consumed by the user ", alias="quotaConsumed")
    __properties: ClassVar[List[str]] = ["jobId", "pipelineName", "status", "description", "timeSubmitted", "timeCompleted", "quotaConsumed"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PipelineRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PipelineRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jobId": obj.get("jobId"),
            "pipelineName": obj.get("pipelineName"),
            "status": obj.get("status"),
            "description": obj.get("description"),
            "timeSubmitted": obj.get("timeSubmitted"),
            "timeCompleted": obj.get("timeCompleted"),
            "quotaConsumed": obj.get("quotaConsumed")
        })
        return _obj


