# coding: utf-8

"""
    Terra Scientific Pipelines Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class AdminPipeline(BaseModel):
    """
    Object containing the pipeline identifier, version, display name, description, and control workspace information for a Pipeline. 
    """ # noqa: E501
    pipeline_name: StrictStr = Field(description="The identifier string for the Pipeline. ", alias="pipelineName")
    pipeline_version: StrictInt = Field(description="An identifier Integer for the Pipeline Version. ", alias="pipelineVersion")
    display_name: StrictStr = Field(description="The display name for the Pipeline. ", alias="displayName")
    description: StrictStr = Field(description="The description for the Pipeline. ")
    tool_version: StrictStr = Field(description="An identifier string for the Pipeline Tool Version i.e. github repo tag/branch/release ", alias="toolVersion")
    workspace_billing_project: StrictStr = Field(description="The Terra billing project of the workspace to run the pipeline in. ", alias="workspaceBillingProject")
    workspace_name: StrictStr = Field(description="The name of the workspace to run the pipeline in. ", alias="workspaceName")
    workspace_storage_container_name: StrictStr = Field(description="The name of the workspace storage container (e.g. google bucket name, without gs:// prefix). ", alias="workspaceStorageContainerName")
    workspace_google_project: StrictStr = Field(description="The google project of the workspace to run the pipeline in. ", alias="workspaceGoogleProject")
    __properties: ClassVar[List[str]] = ["pipelineName", "pipelineVersion", "displayName", "description", "toolVersion", "workspaceBillingProject", "workspaceName", "workspaceStorageContainerName", "workspaceGoogleProject"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdminPipeline from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdminPipeline from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pipelineName": obj.get("pipelineName"),
            "pipelineVersion": obj.get("pipelineVersion"),
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "toolVersion": obj.get("toolVersion"),
            "workspaceBillingProject": obj.get("workspaceBillingProject"),
            "workspaceName": obj.get("workspaceName"),
            "workspaceStorageContainerName": obj.get("workspaceStorageContainerName"),
            "workspaceGoogleProject": obj.get("workspaceGoogleProject")
        })
        return _obj


