# terra-scientific-pipelines-service-api-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.16
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import teaspoons_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import teaspoons_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import teaspoons_client
from teaspoons_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = teaspoons_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: bearerAuth
configuration = teaspoons_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with teaspoons_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = teaspoons_client.AdminApi(api_client)
    pipeline_name = 'pipeline_name_example' # str | A string identifier to used to identify a pipeline in the service.
    pipeline_version = 56 # int | The integer version of the pipeline.

    try:
        # Get description for a given pipeline.
        api_response = api_instance.get_pipeline(pipeline_name, pipeline_version)
        print("The response of AdminApi->get_pipeline:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->get_pipeline: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**get_pipeline**](docs/AdminApi.md#get_pipeline) | **GET** /api/admin/v1/pipelines/{pipelineName}/{pipelineVersion} | Get description for a given pipeline.
*AdminApi* | [**get_quota_for_pipeline_and_user**](docs/AdminApi.md#get_quota_for_pipeline_and_user) | **GET** /api/admin/v1/quotas/{pipelineName}/{userId} | Get quota for a given pipeline and user.
*AdminApi* | [**update_pipeline**](docs/AdminApi.md#update_pipeline) | **PATCH** /api/admin/v1/pipelines/{pipelineName}/{pipelineVersion} | Update attributes for a given pipeline.
*AdminApi* | [**update_quota_limit_for_pipeline_and_user**](docs/AdminApi.md#update_quota_limit_for_pipeline_and_user) | **PATCH** /api/admin/v1/quotas/{pipelineName}/{userId} | Update quota limit for a given pipeline and user.
*JobsApi* | [**get_all_jobs**](docs/JobsApi.md#get_all_jobs) | **GET** /api/job/v1/jobs | Return a list of all jobs the caller has access to
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /api/job/v1/jobs/{jobId} | Retrieve a specified job
*PipelineRunsApi* | [**get_all_pipeline_runs**](docs/PipelineRunsApi.md#get_all_pipeline_runs) | **GET** /api/pipelineruns/v1/pipelineruns | Return a paginated list of all pipeline runs the caller has access to
*PipelineRunsApi* | [**get_pipeline_run_result**](docs/PipelineRunsApi.md#get_pipeline_run_result) | **GET** /api/pipelineruns/v1/result/{jobId} | Retrieve result for a specified pipeline run
*PipelineRunsApi* | [**prepare_pipeline_run**](docs/PipelineRunsApi.md#prepare_pipeline_run) | **POST** /api/pipelineruns/v1/prepare | Prepare a new pipeline run
*PipelineRunsApi* | [**start_pipeline_run**](docs/PipelineRunsApi.md#start_pipeline_run) | **POST** /api/pipelineruns/v1/start | Start a prepared pipeline run
*PipelinesApi* | [**get_pipeline_details**](docs/PipelinesApi.md#get_pipeline_details) | **POST** /api/pipelines/v1/{pipelineName} | Return info about the specified pipeline
*PipelinesApi* | [**get_pipelines**](docs/PipelinesApi.md#get_pipelines) | **GET** /api/pipelines/v1 | Return all available Pipelines
*PublicApi* | [**get_status**](docs/PublicApi.md#get_status) | **GET** /status | Check status of the service.
*PublicApi* | [**get_version**](docs/PublicApi.md#get_version) | **GET** /version | Get version info of the deployed service.
*QuotasApi* | [**get_quota_for_pipeline**](docs/QuotasApi.md#get_quota_for_pipeline) | **GET** /api/quotas/v1/{pipelineName} | Return info about the user&#39;s quota usage for the specified pipeline


## Documentation For Models

 - [AdminPipeline](docs/AdminPipeline.md)
 - [AdminQuota](docs/AdminQuota.md)
 - [AsyncPipelineRunResponse](docs/AsyncPipelineRunResponse.md)
 - [ErrorReport](docs/ErrorReport.md)
 - [GetJobsResponse](docs/GetJobsResponse.md)
 - [GetPipelineDetailsRequestBody](docs/GetPipelineDetailsRequestBody.md)
 - [GetPipelineRunsResponse](docs/GetPipelineRunsResponse.md)
 - [GetPipelinesResult](docs/GetPipelinesResult.md)
 - [JobControl](docs/JobControl.md)
 - [JobReport](docs/JobReport.md)
 - [JobResult](docs/JobResult.md)
 - [Pipeline](docs/Pipeline.md)
 - [PipelineQuota](docs/PipelineQuota.md)
 - [PipelineRun](docs/PipelineRun.md)
 - [PipelineRunReport](docs/PipelineRunReport.md)
 - [PipelineUserProvidedInputDefinition](docs/PipelineUserProvidedInputDefinition.md)
 - [PipelineWithDetails](docs/PipelineWithDetails.md)
 - [PreparePipelineRunRequestBody](docs/PreparePipelineRunRequestBody.md)
 - [PreparePipelineRunResponse](docs/PreparePipelineRunResponse.md)
 - [QuotaWithDetails](docs/QuotaWithDetails.md)
 - [StartPipelineRunRequestBody](docs/StartPipelineRunRequestBody.md)
 - [SystemStatus](docs/SystemStatus.md)
 - [SystemStatusSystemsValue](docs/SystemStatusSystemsValue.md)
 - [UpdatePipelineRequestBody](docs/UpdatePipelineRequestBody.md)
 - [UpdateQuotaLimitRequestBody](docs/UpdateQuotaLimitRequestBody.md)
 - [VersionProperties](docs/VersionProperties.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oidc"></a>
### oidc

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: [[${authorityEndpoint}]]
- **Scopes**: N/A

<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication


## Author




