/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.Rops;
import com.android.dx.ssa.BasicRegisterMapper;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.FirstFitLocalCombiningAllocator;
import com.android.dx.ssa.back.IdenticalBlockCombiner;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.LivenessAnalyzer;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;

public class SsaToRop {
    private static final boolean DEBUG = false;
    private final SsaMethod ssaMeth;
    private final boolean minimizeRegisters;
    private final InterferenceGraph interference;

    public static RopMethod convertToRopMethod(SsaMethod ssaMethod, boolean bl) {
        return new SsaToRop(ssaMethod, bl).convert();
    }

    private SsaToRop(SsaMethod ssaMethod, boolean bl) {
        this.minimizeRegisters = bl;
        this.ssaMeth = ssaMethod;
        this.interference = LivenessAnalyzer.constructInterferenceGraph(ssaMethod);
    }

    private RopMethod convert() {
        FirstFitLocalCombiningAllocator firstFitLocalCombiningAllocator = new FirstFitLocalCombiningAllocator(this.ssaMeth, this.interference, this.minimizeRegisters);
        RegisterMapper registerMapper = ((RegisterAllocator)firstFitLocalCombiningAllocator).allocateRegisters();
        this.ssaMeth.setBackMode();
        this.ssaMeth.mapRegisters(registerMapper);
        this.removePhiFunctions();
        if (((RegisterAllocator)firstFitLocalCombiningAllocator).wantsParamsMovedHigh()) {
            this.moveParametersToHighRegisters();
        }
        this.removeEmptyGotos();
        RopMethod ropMethod = new RopMethod(this.convertBasicBlocks(), this.ssaMeth.blockIndexToRopLabel(this.ssaMeth.getEntryBlockIndex()));
        ropMethod = new IdenticalBlockCombiner(ropMethod).process();
        return ropMethod;
    }

    private void removeEmptyGotos() {
        final ArrayList<SsaBasicBlock> arrayList = this.ssaMeth.getBlocks();
        this.ssaMeth.forEachBlockDepthFirst(false, new SsaBasicBlock.Visitor(){

            @Override
            public void visitBlock(SsaBasicBlock ssaBasicBlock, SsaBasicBlock ssaBasicBlock2) {
                ArrayList<SsaInsn> arrayList2 = ssaBasicBlock.getInsns();
                if (arrayList2.size() == 1 && arrayList2.get(0).getOpcode() == Rops.GOTO) {
                    BitSet bitSet = (BitSet)ssaBasicBlock.getPredecessors().clone();
                    int n = bitSet.nextSetBit(0);
                    while (n >= 0) {
                        SsaBasicBlock ssaBasicBlock3 = (SsaBasicBlock)arrayList.get(n);
                        ssaBasicBlock3.replaceSuccessor(ssaBasicBlock.getIndex(), ssaBasicBlock.getPrimarySuccessorIndex());
                        n = bitSet.nextSetBit(n + 1);
                    }
                }
            }
        });
    }

    private void removePhiFunctions() {
        ArrayList<SsaBasicBlock> arrayList = this.ssaMeth.getBlocks();
        for (SsaBasicBlock ssaBasicBlock : arrayList) {
            ssaBasicBlock.forEachPhiInsn(new PhiVisitor(arrayList));
            ssaBasicBlock.removeAllPhiInsns();
        }
        for (SsaBasicBlock ssaBasicBlock : arrayList) {
            ssaBasicBlock.scheduleMovesFromPhis();
        }
    }

    private void moveParametersToHighRegisters() {
        int n = this.ssaMeth.getParamWidth();
        BasicRegisterMapper basicRegisterMapper = new BasicRegisterMapper(this.ssaMeth.getRegCount());
        int n2 = this.ssaMeth.getRegCount();
        for (int i = 0; i < n2; ++i) {
            if (i < n) {
                basicRegisterMapper.addMapping(i, n2 - n + i, 1);
                continue;
            }
            basicRegisterMapper.addMapping(i, i - n, 1);
        }
        this.ssaMeth.mapRegisters(basicRegisterMapper);
    }

    private BasicBlockList convertBasicBlocks() {
        ArrayList<SsaBasicBlock> arrayList = this.ssaMeth.getBlocks();
        SsaBasicBlock ssaBasicBlock = this.ssaMeth.getExitBlock();
        this.ssaMeth.computeReachability();
        int n = this.ssaMeth.getCountReachableBlocks();
        BasicBlockList basicBlockList = new BasicBlockList(n -= ssaBasicBlock != null && ssaBasicBlock.isReachable() ? 1 : 0);
        int n2 = 0;
        for (SsaBasicBlock ssaBasicBlock2 : arrayList) {
            if (!ssaBasicBlock2.isReachable() || ssaBasicBlock2 == ssaBasicBlock) continue;
            basicBlockList.set(n2++, this.convertBasicBlock(ssaBasicBlock2));
        }
        if (ssaBasicBlock != null && ssaBasicBlock.getInsns().size() != 0) {
            throw new RuntimeException("Exit block must have no insns when leaving SSA form");
        }
        return basicBlockList;
    }

    private void verifyValidExitPredecessor(SsaBasicBlock ssaBasicBlock) {
        ArrayList<SsaInsn> arrayList = ssaBasicBlock.getInsns();
        SsaInsn ssaInsn = arrayList.get(arrayList.size() - 1);
        Rop rop = ssaInsn.getOpcode();
        if (rop.getBranchingness() != 2 && rop != Rops.THROW) {
            throw new RuntimeException("Exit predecessor must end in valid exit statement.");
        }
    }

    private BasicBlock convertBasicBlock(SsaBasicBlock ssaBasicBlock) {
        int n;
        IntList intList = ssaBasicBlock.getRopLabelSuccessorList();
        int n2 = ssaBasicBlock.getPrimarySuccessorRopLabel();
        SsaBasicBlock ssaBasicBlock2 = this.ssaMeth.getExitBlock();
        int n3 = n = ssaBasicBlock2 == null ? -1 : ssaBasicBlock2.getRopLabel();
        if (intList.contains(n)) {
            if (intList.size() > 1) {
                throw new RuntimeException("Exit predecessor must have no other successors" + Hex.u2(ssaBasicBlock.getRopLabel()));
            }
            intList = IntList.EMPTY;
            n2 = -1;
            this.verifyValidExitPredecessor(ssaBasicBlock);
        }
        intList.setImmutable();
        BasicBlock basicBlock = new BasicBlock(ssaBasicBlock.getRopLabel(), this.convertInsns(ssaBasicBlock.getInsns()), intList, n2);
        return basicBlock;
    }

    private InsnList convertInsns(ArrayList<SsaInsn> arrayList) {
        int n = arrayList.size();
        InsnList insnList = new InsnList(n);
        for (int i = 0; i < n; ++i) {
            insnList.set(i, arrayList.get(i).toRopInsn());
        }
        insnList.setImmutable();
        return insnList;
    }

    public int[] getRegistersByFrequency() {
        int n = this.ssaMeth.getRegCount();
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = i;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return SsaToRop.this.ssaMeth.getUseListForRegister(n2).size() - SsaToRop.this.ssaMeth.getUseListForRegister(n).size();
            }
        });
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    private static class PhiVisitor
    implements PhiInsn.Visitor {
        private final ArrayList<SsaBasicBlock> blocks;

        public PhiVisitor(ArrayList<SsaBasicBlock> arrayList) {
            this.blocks = arrayList;
        }

        @Override
        public void visitPhiInsn(PhiInsn phiInsn) {
            RegisterSpecList registerSpecList = phiInsn.getSources();
            RegisterSpec registerSpec = phiInsn.getResult();
            int n = registerSpecList.size();
            for (int i = 0; i < n; ++i) {
                RegisterSpec registerSpec2 = registerSpecList.get(i);
                SsaBasicBlock ssaBasicBlock = this.blocks.get(phiInsn.predBlockIndexForSourcesIndex(i));
                ssaBasicBlock.addMoveToEnd(registerSpec, registerSpec2);
            }
        }
    }
}

