/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.FillArrayDataInsn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.SwitchInsn;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.ToHuman;

public abstract class Insn
implements ToHuman {
    private final Rop opcode;
    private final SourcePosition position;
    private final RegisterSpec result;
    private final RegisterSpecList sources;

    public Insn(Rop rop, SourcePosition sourcePosition, RegisterSpec registerSpec, RegisterSpecList registerSpecList) {
        if (rop == null) {
            throw new NullPointerException("opcode == null");
        }
        if (sourcePosition == null) {
            throw new NullPointerException("position == null");
        }
        if (registerSpecList == null) {
            throw new NullPointerException("sources == null");
        }
        this.opcode = rop;
        this.position = sourcePosition;
        this.result = registerSpec;
        this.sources = registerSpecList;
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.toStringWithInline(this.getInlineString());
    }

    @Override
    public String toHuman() {
        return this.toHumanWithInline(this.getInlineString());
    }

    public String getInlineString() {
        return null;
    }

    public final Rop getOpcode() {
        return this.opcode;
    }

    public final SourcePosition getPosition() {
        return this.position;
    }

    public final RegisterSpec getResult() {
        return this.result;
    }

    public final RegisterSpec getLocalAssignment() {
        RegisterSpec registerSpec = this.opcode.getOpcode() == 54 ? this.sources.get(0) : this.result;
        if (registerSpec == null) {
            return null;
        }
        LocalItem localItem = registerSpec.getLocalItem();
        if (localItem == null) {
            return null;
        }
        return registerSpec;
    }

    public final RegisterSpecList getSources() {
        return this.sources;
    }

    public final boolean canThrow() {
        return this.opcode.canThrow();
    }

    public abstract TypeList getCatches();

    public abstract void accept(Visitor var1);

    public abstract Insn withAddedCatch(Type var1);

    public abstract Insn withRegisterOffset(int var1);

    public Insn withSourceLiteral() {
        return this;
    }

    public Insn copy() {
        return this.withRegisterOffset(0);
    }

    private static boolean equalsHandleNulls(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public boolean contentEquals(Insn insn) {
        return this.opcode == insn.getOpcode() && this.position.equals(insn.getPosition()) && this.getClass() == insn.getClass() && Insn.equalsHandleNulls(this.result, insn.getResult()) && Insn.equalsHandleNulls(this.sources, insn.getSources()) && StdTypeList.equalContents(this.getCatches(), insn.getCatches());
    }

    public abstract Insn withNewRegisters(RegisterSpec var1, RegisterSpecList var2);

    protected final String toStringWithInline(String string) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("Insn{");
        stringBuffer.append(this.position);
        stringBuffer.append(' ');
        stringBuffer.append(this.opcode);
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        stringBuffer.append(" :: ");
        if (this.result != null) {
            stringBuffer.append(this.result);
            stringBuffer.append(" <- ");
        }
        stringBuffer.append(this.sources);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected final String toHumanWithInline(String string) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(this.position);
        stringBuffer.append(": ");
        stringBuffer.append(this.opcode.getNickname());
        if (string != null) {
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        if (this.result == null) {
            stringBuffer.append(" .");
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(this.result.toHuman());
        }
        stringBuffer.append(" <-");
        int n = this.sources.size();
        if (n == 0) {
            stringBuffer.append(" .");
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(this.sources.get(i).toHuman());
            }
        }
        return stringBuffer.toString();
    }

    public static class BaseVisitor
    implements Visitor {
        @Override
        public void visitPlainInsn(PlainInsn plainInsn) {
        }

        @Override
        public void visitPlainCstInsn(PlainCstInsn plainCstInsn) {
        }

        @Override
        public void visitSwitchInsn(SwitchInsn switchInsn) {
        }

        @Override
        public void visitThrowingCstInsn(ThrowingCstInsn throwingCstInsn) {
        }

        @Override
        public void visitThrowingInsn(ThrowingInsn throwingInsn) {
        }

        @Override
        public void visitFillArrayDataInsn(FillArrayDataInsn fillArrayDataInsn) {
        }
    }

    public static interface Visitor {
        public void visitPlainInsn(PlainInsn var1);

        public void visitPlainCstInsn(PlainCstInsn var1);

        public void visitSwitchInsn(SwitchInsn var1);

        public void visitThrowingCstInsn(ThrowingCstInsn var1);

        public void visitThrowingInsn(ThrowingInsn var1);

        public void visitFillArrayDataInsn(FillArrayDataInsn var1);
    }
}

