/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dex.Annotation;
import com.android.dex.ClassDef;
import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.EncodedValue;
import com.android.dex.EncodedValueCodec;
import com.android.dex.EncodedValueReader;
import com.android.dex.FieldId;
import com.android.dex.Leb128;
import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import com.android.dex.TableOfContents;
import com.android.dex.TypeList;
import com.android.dex.util.ByteOutput;
import com.android.dx.merge.SortableType;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import java.util.HashMap;

public final class IndexMap {
    private final Dex target;
    public final int[] stringIds;
    public final short[] typeIds;
    public final short[] protoIds;
    public final short[] fieldIds;
    public final short[] methodIds;
    private final HashMap<Integer, Integer> typeListOffsets;
    private final HashMap<Integer, Integer> annotationOffsets;
    private final HashMap<Integer, Integer> annotationSetOffsets;
    private final HashMap<Integer, Integer> annotationSetRefListOffsets;
    private final HashMap<Integer, Integer> annotationDirectoryOffsets;
    private final HashMap<Integer, Integer> staticValuesOffsets;

    public IndexMap(Dex dex, TableOfContents tableOfContents) {
        this.target = dex;
        this.stringIds = new int[tableOfContents.stringIds.size];
        this.typeIds = new short[tableOfContents.typeIds.size];
        this.protoIds = new short[tableOfContents.protoIds.size];
        this.fieldIds = new short[tableOfContents.fieldIds.size];
        this.methodIds = new short[tableOfContents.methodIds.size];
        this.typeListOffsets = new HashMap();
        this.annotationOffsets = new HashMap();
        this.annotationSetOffsets = new HashMap();
        this.annotationSetRefListOffsets = new HashMap();
        this.annotationDirectoryOffsets = new HashMap();
        this.staticValuesOffsets = new HashMap();
        this.typeListOffsets.put(0, 0);
        this.annotationSetOffsets.put(0, 0);
        this.annotationDirectoryOffsets.put(0, 0);
        this.staticValuesOffsets.put(0, 0);
    }

    public void putTypeListOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.typeListOffsets.put(n, n2);
    }

    public void putAnnotationOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationOffsets.put(n, n2);
    }

    public void putAnnotationSetOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationSetOffsets.put(n, n2);
    }

    public void putAnnotationSetRefListOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationSetRefListOffsets.put(n, n2);
    }

    public void putAnnotationDirectoryOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationDirectoryOffsets.put(n, n2);
    }

    public void putStaticValuesOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.staticValuesOffsets.put(n, n2);
    }

    public int adjustString(int n) {
        return n == -1 ? -1 : this.stringIds[n];
    }

    public int adjustType(int n) {
        return n == -1 ? -1 : this.typeIds[n] & 0xFFFF;
    }

    public TypeList adjustTypeList(TypeList typeList) {
        if (typeList == TypeList.EMPTY) {
            return typeList;
        }
        short[] sArray = (short[])typeList.getTypes().clone();
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)this.adjustType(sArray[i]);
        }
        return new TypeList(this.target, sArray);
    }

    public int adjustProto(int n) {
        return this.protoIds[n] & 0xFFFF;
    }

    public int adjustField(int n) {
        return this.fieldIds[n] & 0xFFFF;
    }

    public int adjustMethod(int n) {
        return this.methodIds[n] & 0xFFFF;
    }

    public int adjustTypeListOffset(int n) {
        return this.typeListOffsets.get(n);
    }

    public int adjustAnnotation(int n) {
        return this.annotationOffsets.get(n);
    }

    public int adjustAnnotationSet(int n) {
        return this.annotationSetOffsets.get(n);
    }

    public int adjustAnnotationSetRefList(int n) {
        return this.annotationSetRefListOffsets.get(n);
    }

    public int adjustAnnotationDirectory(int n) {
        return this.annotationDirectoryOffsets.get(n);
    }

    public int adjustStaticValues(int n) {
        return this.staticValuesOffsets.get(n);
    }

    public MethodId adjust(MethodId methodId) {
        return new MethodId(this.target, this.adjustType(methodId.getDeclaringClassIndex()), this.adjustProto(methodId.getProtoIndex()), this.adjustString(methodId.getNameIndex()));
    }

    public FieldId adjust(FieldId fieldId) {
        return new FieldId(this.target, this.adjustType(fieldId.getDeclaringClassIndex()), this.adjustType(fieldId.getTypeIndex()), this.adjustString(fieldId.getNameIndex()));
    }

    public ProtoId adjust(ProtoId protoId) {
        return new ProtoId(this.target, this.adjustString(protoId.getShortyIndex()), this.adjustType(protoId.getReturnTypeIndex()), this.adjustTypeListOffset(protoId.getParametersOffset()));
    }

    public ClassDef adjust(ClassDef classDef) {
        return new ClassDef(this.target, classDef.getOffset(), this.adjustType(classDef.getTypeIndex()), classDef.getAccessFlags(), this.adjustType(classDef.getSupertypeIndex()), this.adjustTypeListOffset(classDef.getInterfacesOffset()), classDef.getSourceFileIndex(), classDef.getAnnotationsOffset(), classDef.getClassDataOffset(), classDef.getStaticValuesOffset());
    }

    public SortableType adjust(SortableType sortableType) {
        return new SortableType(sortableType.getDex(), this.adjust(sortableType.getClassDef()));
    }

    public EncodedValue adjustEncodedValue(EncodedValue encodedValue) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(byteArrayAnnotatedOutput).transform(new EncodedValueReader(encodedValue));
        return new EncodedValue(byteArrayAnnotatedOutput.toByteArray());
    }

    public EncodedValue adjustEncodedArray(EncodedValue encodedValue) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(byteArrayAnnotatedOutput).transformArray(new EncodedValueReader(encodedValue, 28));
        return new EncodedValue(byteArrayAnnotatedOutput.toByteArray());
    }

    public Annotation adjust(Annotation annotation) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(byteArrayAnnotatedOutput).transformAnnotation(annotation.getReader());
        return new Annotation(this.target, annotation.getVisibility(), new EncodedValue(byteArrayAnnotatedOutput.toByteArray()));
    }

    private final class EncodedValueTransformer {
        private final ByteOutput out;

        public EncodedValueTransformer(ByteOutput byteOutput) {
            this.out = byteOutput;
        }

        public void transform(EncodedValueReader encodedValueReader) {
            switch (encodedValueReader.peek()) {
                case 0: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 0, encodedValueReader.readByte());
                    break;
                }
                case 2: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 2, encodedValueReader.readShort());
                    break;
                }
                case 4: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 4, encodedValueReader.readInt());
                    break;
                }
                case 6: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 6, encodedValueReader.readLong());
                    break;
                }
                case 3: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 3, encodedValueReader.readChar());
                    break;
                }
                case 16: {
                    long l = (long)Float.floatToIntBits(encodedValueReader.readFloat()) << 32;
                    EncodedValueCodec.writeRightZeroExtendedValue(this.out, 16, l);
                    break;
                }
                case 17: {
                    EncodedValueCodec.writeRightZeroExtendedValue(this.out, 17, Double.doubleToLongBits(encodedValueReader.readDouble()));
                    break;
                }
                case 23: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 23, IndexMap.this.adjustString(encodedValueReader.readString()));
                    break;
                }
                case 24: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 24, IndexMap.this.adjustType(encodedValueReader.readType()));
                    break;
                }
                case 25: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 25, IndexMap.this.adjustField(encodedValueReader.readField()));
                    break;
                }
                case 27: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 27, IndexMap.this.adjustField(encodedValueReader.readEnum()));
                    break;
                }
                case 26: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 26, IndexMap.this.adjustMethod(encodedValueReader.readMethod()));
                    break;
                }
                case 28: {
                    this.writeTypeAndArg(28, 0);
                    this.transformArray(encodedValueReader);
                    break;
                }
                case 29: {
                    this.writeTypeAndArg(29, 0);
                    this.transformAnnotation(encodedValueReader);
                    break;
                }
                case 30: {
                    encodedValueReader.readNull();
                    this.writeTypeAndArg(30, 0);
                    break;
                }
                case 31: {
                    boolean bl = encodedValueReader.readBoolean();
                    this.writeTypeAndArg(31, bl ? 1 : 0);
                    break;
                }
                default: {
                    throw new DexException("Unexpected type: " + Integer.toHexString(encodedValueReader.peek()));
                }
            }
        }

        private void transformAnnotation(EncodedValueReader encodedValueReader) {
            int n = encodedValueReader.readAnnotation();
            Leb128.writeUnsignedLeb128(this.out, IndexMap.this.adjustType(encodedValueReader.getAnnotationType()));
            Leb128.writeUnsignedLeb128(this.out, n);
            for (int i = 0; i < n; ++i) {
                Leb128.writeUnsignedLeb128(this.out, IndexMap.this.adjustString(encodedValueReader.readAnnotationName()));
                this.transform(encodedValueReader);
            }
        }

        private void transformArray(EncodedValueReader encodedValueReader) {
            int n = encodedValueReader.readArray();
            Leb128.writeUnsignedLeb128(this.out, n);
            for (int i = 0; i < n; ++i) {
                this.transform(encodedValueReader);
            }
        }

        private void writeTypeAndArg(int n, int n2) {
            this.out.writeByte(n2 << 5 | n);
        }
    }
}

